/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="childrenArray()")
abstract class RefValueHashMap<K, V>
implements Map<K, V> {
    private final Map<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue;

    @NotNull
    static IncorrectOperationException pointlessContainsKey() {
        return new IncorrectOperationException("containsKey() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @NotNull
    static IncorrectOperationException pointlessContainsValue() {
        return new IncorrectOperationException("containsValue() makes no sense for weak/soft map because GC can clear the key any moment now");
    }

    protected abstract MyReference<K, V> createReference(@NotNull K var1, V var2, @NotNull ReferenceQueue<? super V> var3);

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)((Object)this.myQueue.poll())) != null) {
            Object key = ref.getKey();
            if (this.myMap.get(key) != ref) continue;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public V put(@NotNull K key, V value2) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(1);
        }
        this.processQueue();
        MyReference<K, V> reference = this.createReference(key, value2, this.myQueue);
        MyReference<K, V> oldRef = this.myMap.put(key, reference);
        return (V)SoftReference.deref(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            RefValueHashMap.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            RefValueHashMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result2 = new ArrayList();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            Object value2 = ref.get();
            if (value2 == null) continue;
            result2.add(value2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RefValueHashMap.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/RefValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/RefValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface MyReference<K, T>
    extends Getter<T> {
        @NotNull
        public K getKey();
    }
}

