/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarPostDataParam;
import edu.umass.cs.benchlab.har.HarPostDataParams;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPostData {
    public static String TABLE_NAME = "post";
    private String mimeType;
    private HarPostDataParams params;
    private String text;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarPostData(String mimeType, HarPostDataParams params, String text, String comment) {
        this.mimeType = mimeType;
        this.params = params;
        this.text = text;
        this.comment = comment;
    }

    public HarPostData(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"postData\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("mimeType".equals(name)) {
                this.setMimeType(jp.getText());
                continue;
            }
            if ("params".equals(name)) {
                this.setParams(new HarPostDataParams(jp, warnings));
                continue;
            }
            if ("text".equals(name)) {
                this.setText(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in page element", jp.getCurrentLocation());
        }
        if (this.mimeType == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing mimeType field in postData element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing mimeType field in postData element", jp.getCurrentLocation());
            }
        }
        if (this.params == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing params field in postData element", jp.getCurrentLocation()));
                this.setParams(new HarPostDataParams());
            } else {
                throw new JsonParseException("Missing params field in postData element", jp.getCurrentLocation());
            }
        }
        if (this.text == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing text field in postData element", jp.getCurrentLocation()));
                this.setText("");
            } else {
                throw new JsonParseException("Missing text field in postData element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarPostData(HarDatabaseConfig config, long requestId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,mime_type,text,comment FROM " + tableName + " WHERE request_id=?");
            ps.setLong(1, requestId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarPostData for request id " + requestId + " found in database");
            }
            long postDataId = rs.getLong(1);
            this.setMimeType(rs.getString(2));
            this.setText(rs.getString(3));
            this.setComment(rs.getString(4));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARPOSTDATA, postDataId);
            this.params = new HarPostDataParams(config, postDataId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("postData");
        g.writeStringField("mimeType", this.mimeType);
        this.params.writeHar(g);
        g.writeStringField("text", this.text);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long requestId, HarDatabaseConfig config, long logId) throws SQLException {
        String paramsTableName;
        Connection c = config.getConnection();
        String postTableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(postTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + postTableName + " (id " + config.getDbAutoGeneratedId() + ",mime_type " + config.getStringDbType() + ",text " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",request_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(postTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        if (!config.isCreatedTable(paramsTableName = config.getTablePrefix() + HarPostDataParam.TABLE_NAME)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + paramsTableName + " (id " + config.getDbAutoGeneratedId() + ",name " + config.getStringDbType() + ",value " + config.getStringDbType() + ",filename " + config.getStringDbType() + ",content_type " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",post_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(paramsTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        Statement postPs = null;
        ResultSet rs = null;
        PreparedStatement paramsPs = c.prepareStatement("INSERT INTO " + paramsTableName + " (name,value,filename,content_type,comment,post_id) VALUES (?,?,?,?,?,?)", 1);
        try {
            postPs = c.prepareStatement("INSERT INTO " + postTableName + " (mime_type,text,comment,request_id) VALUES (?,?,?,?)", 1);
            postPs.setString(1, this.mimeType);
            postPs.setString(2, this.text);
            if (this.comment == null) {
                postPs.setNull(3, -1);
            } else {
                postPs.setString(3, this.comment);
            }
            postPs.setLong(4, requestId);
            postPs.executeUpdate();
            rs = postPs.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarPostData entry");
            }
            long postId = rs.getLong(1);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARPOSTDATA, postId, logId);
            this.params.writeJDBC(config, postId, paramsPs, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (postPs != null) {
                    postPs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (paramsPs != null) {
                    paramsPs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String queryTableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(queryTableName)) {
            return;
        }
        this.params.deleteFromJDBC(config, logId);
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + queryTableName + " WHERE request_id IN (SELECT id FROM " + config.getTablePrefix() + "request WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, queryTableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public HarPostDataParams getParams() {
        return this.params;
    }

    public void setParams(HarPostDataParams params) {
        this.params = params;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"postData\": { \"mimeType\": \"" + this.mimeType + "\", " + this.params + ",  \"text\": \"" + this.text + " \",  \"comment\": \"" + this.comment + "\", " + this.customFields + " }\n";
    }
}

