/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.mahout.matrix.impl;

import org.carrot2.math.mahout.function.DoubleDoubleFunction;
import org.carrot2.math.mahout.function.DoubleFunction;
import org.carrot2.math.mahout.function.Functions;
import org.carrot2.math.mahout.function.Mult;
import org.carrot2.math.mahout.function.PlusMult;
import org.carrot2.math.mahout.matrix.DoubleMatrix1D;
import org.carrot2.math.mahout.matrix.DoubleMatrix2D;
import org.carrot2.math.mahout.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.math.mahout.matrix.impl.SelectedDenseDoubleMatrix1D;

public class DenseDoubleMatrix1D
extends DoubleMatrix1D {
    protected final double[] elements;

    public DenseDoubleMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseDoubleMatrix1D(int size) {
        this.setUp(size);
        this.elements = new double[size];
    }

    protected DenseDoubleMatrix1D(int size, double[] elements, int zero, int stride) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public void assign(double[] values) {
        if (this.isNoView) {
            if (values.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
            }
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            super.assign(values);
        }
    }

    @Override
    public void assign(double value) {
        int index = this.index(0);
        int s = this.stride;
        double[] elems = this.elements;
        int i = this.size;
        while (--i >= 0) {
            elems[index] = value;
            index += s;
        }
    }

    @Override
    public void assign(DoubleFunction function) {
        int s = this.stride;
        int i = this.index(0);
        double[] elems = this.elements;
        if (elems == null) {
            throw new IllegalStateException();
        }
        if (function instanceof Mult) {
            double multiplicator = ((Mult)function).getMultiplicator();
            if (multiplicator == 1.0) {
                return;
            }
            int k = this.size;
            while (--k >= 0) {
                int n = i;
                elems[n] = elems[n] * multiplicator;
                i += s;
            }
        } else {
            int k = this.size;
            while (--k >= 0) {
                elems[i] = function.apply(elems[i]);
                i += s;
            }
        }
    }

    @Override
    public DoubleMatrix1D assign(DoubleMatrix1D source) {
        if (!(source instanceof DenseDoubleMatrix1D)) {
            return super.assign(source);
        }
        DenseDoubleMatrix1D other = (DenseDoubleMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DoubleMatrix1D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix1D)) {
                return super.assign(source);
            }
            other = (DenseDoubleMatrix1D)c;
        }
        double[] elems = this.elements;
        double[] otherElems = other.elements;
        if (this.elements == null || otherElems == null) {
            throw new IllegalStateException();
        }
        int s = this.stride;
        int ys = other.stride;
        int index = this.index(0);
        int otherIndex = other.index(0);
        int k = this.size;
        while (--k >= 0) {
            elems[index] = otherElems[otherIndex];
            index += s;
            otherIndex += ys;
        }
        return this;
    }

    @Override
    public DoubleMatrix1D assign(DoubleMatrix1D y, DoubleDoubleFunction function) {
        if (!(y instanceof DenseDoubleMatrix1D)) {
            return super.assign(y, function);
        }
        DenseDoubleMatrix1D other = (DenseDoubleMatrix1D)y;
        this.checkSize(y);
        double[] elems = this.elements;
        double[] otherElems = other.elements;
        if (elems == null || otherElems == null) {
            throw new IllegalStateException();
        }
        int s = this.stride;
        int ys = other.stride;
        int index = this.index(0);
        int otherIndex = other.index(0);
        if (function == Functions.MULT) {
            int k = this.size;
            while (--k >= 0) {
                int n = index;
                elems[n] = elems[n] * otherElems[otherIndex];
                index += s;
                otherIndex += ys;
            }
        } else if (function == Functions.DIV) {
            int k = this.size;
            while (--k >= 0) {
                int n = index;
                elems[n] = elems[n] / otherElems[otherIndex];
                index += s;
                otherIndex += ys;
            }
        } else if (function instanceof PlusMult) {
            double multiplicator = ((PlusMult)function).getMultiplicator();
            if (multiplicator == 0.0) {
                return this;
            }
            if (multiplicator == 1.0) {
                int k = this.size;
                while (--k >= 0) {
                    int n = index;
                    elems[n] = elems[n] + otherElems[otherIndex];
                    index += s;
                    otherIndex += ys;
                }
            } else if (multiplicator == -1.0) {
                int k = this.size;
                while (--k >= 0) {
                    int n = index;
                    elems[n] = elems[n] - otherElems[otherIndex];
                    index += s;
                    otherIndex += ys;
                }
            } else {
                int k = this.size;
                while (--k >= 0) {
                    int n = index;
                    elems[n] = elems[n] + multiplicator * otherElems[otherIndex];
                    index += s;
                    otherIndex += ys;
                }
            }
        } else {
            int k = this.size;
            while (--k >= 0) {
                elems[index] = function.apply(elems[index], otherElems[otherIndex]);
                index += s;
                otherIndex += ys;
            }
        }
        return this;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int index = this.index(0);
        int s = this.stride;
        double[] elems = this.elements;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (elems[index] != 0.0) {
                ++cardinality;
            }
            index += s;
        }
        return cardinality;
    }

    @Override
    public double getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D otherMatrix = (SelectedDenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D otherMatrix = (DenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    @Override
    public void swap(DoubleMatrix1D other) {
        DenseDoubleMatrix1D y;
        if (!(other instanceof DenseDoubleMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseDoubleMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        double[] elems = this.elements;
        double[] otherElems = y.elements;
        if (this.elements == null || otherElems == null) {
            throw new IllegalStateException();
        }
        int s = this.stride;
        int ys = y.stride;
        int index = this.index(0);
        int otherIndex = y.index(0);
        int k = this.size;
        while (--k >= 0) {
            double tmp = elems[index];
            elems[index] = otherElems[otherIndex];
            otherElems[otherIndex] = tmp;
            index += s;
            otherIndex += ys;
        }
    }

    @Override
    public void toArray(double[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseDoubleMatrix1D(this.elements, offsets);
    }

    @Override
    public double zDotProduct(DoubleMatrix1D y, int from, int length) {
        if (!(y instanceof DenseDoubleMatrix1D)) {
            return super.zDotProduct(y, from, length);
        }
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        int tail = from + length;
        if (from < 0 || length < 0) {
            return 0.0;
        }
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        int min = tail - from;
        int i = this.index(from);
        int j = yy.index(from);
        int s = this.stride;
        int ys = yy.stride;
        double[] elems = this.elements;
        double[] yElems = yy.elements;
        if (elems == null || yElems == null) {
            throw new IllegalStateException();
        }
        i -= s;
        j -= ys;
        double sum = 0.0;
        int k = min / 4;
        while (--k >= 0) {
            int n = i + s;
            i = n;
            int n2 = j + ys;
            j = n2;
            int n3 = i + s;
            i = n3;
            int n4 = j + ys;
            j = n4;
            i = i + s;
            j = j + ys;
            sum += elems[n] * yElems[n2] + elems[n3] * yElems[n4] + elems[i] * yElems[j] + elems[i += s] * yElems[j += ys];
        }
        k = min % 4;
        while (--k >= 0) {
            sum += elems[i += s] * yElems[j += ys];
        }
        return sum;
    }

    @Override
    public double zSum() {
        int s = this.stride;
        int i = this.index(0);
        double[] elems = this.elements;
        if (elems == null) {
            throw new IllegalStateException();
        }
        double sum = 0.0;
        int k = this.size;
        while (--k >= 0) {
            sum += elems[i];
            i += s;
        }
        return sum;
    }
}

