/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.file.PathUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.backup.repository.BackupRepository;

public class LocalFileSystemRepository
implements BackupRepository {
    private NamedList<?> config = null;

    @Override
    public void init(NamedList<?> args) {
        this.config = args;
    }

    @Override
    public <T> T getConfigProperty(String name) {
        return (T)this.config.get(name);
    }

    @Override
    public URI createURI(String location) {
        Objects.requireNonNull(location);
        URI result = null;
        try {
            result = new URI(location);
            if (!result.isAbsolute()) {
                result = Path.of(location, new String[0]).toUri();
            }
        }
        catch (URISyntaxException ex) {
            result = Path.of(location, new String[0]).toUri();
        }
        return result;
    }

    @Override
    public URI resolve(URI baseUri, String ... pathComponents) {
        Preconditions.checkArgument((pathComponents.length > 0 ? 1 : 0) != 0);
        Path result = Path.of(baseUri);
        for (int i = 0; i < pathComponents.length; ++i) {
            try {
                result = result.resolve(pathComponents[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result.toUri();
    }

    @Override
    public void createDirectory(URI path) throws IOException {
        Path p = Path.of(path);
        if (!Files.exists(p, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectory(p, new FileAttribute[0]);
        }
    }

    @Override
    public void deleteDirectory(URI path) throws IOException {
        PathUtils.deleteDirectory((Path)Path.of(path));
    }

    @Override
    public boolean exists(URI path) throws IOException {
        return Files.exists(Path.of(path), new LinkOption[0]);
    }

    @Override
    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            IndexInput indexInput = dir.openInput(fileName, ctx);
            return indexInput;
        }
    }

    @Override
    public OutputStream createOutput(URI path) throws IOException {
        return Files.newOutputStream(Path.of(path), new OpenOption[0]);
    }

    @Override
    public String[] listAll(URI dirPath) throws IOException {
        if (!this.exists(dirPath)) {
            return new String[0];
        }
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            String[] stringArray = dir.listAll();
            return stringArray;
        }
    }

    @Override
    public BackupRepository.PathType getPathType(URI path) throws IOException {
        return Files.isDirectory(Path.of(path), new LinkOption[0]) ? BackupRepository.PathType.DIRECTORY : BackupRepository.PathType.FILE;
    }

    @Override
    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(destDir), (LockFactory)NoLockFactory.INSTANCE);){
            this.copyIndexFileFrom(sourceDir, sourceFileName, (Directory)dir, destFileName);
        }
    }

    @Override
    public void copyIndexFileTo(URI sourceDir, String sourceFileName, Directory dest, String destFileName) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(sourceDir), (LockFactory)NoLockFactory.INSTANCE);){
            dest.copyFrom((Directory)dir, sourceFileName, destFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(URI path, Collection<String> files, boolean ignoreNoSuchFileException) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(path), (LockFactory)NoLockFactory.INSTANCE);){
            for (String file : files) {
                try {
                    dir.deleteFile(file);
                }
                catch (NoSuchFileException e) {
                    if (ignoreNoSuchFileException) continue;
                    throw e;
                    return;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

