/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.net.URI;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.RestoreCore;
import org.apache.solr.handler.admin.CoreAdminHandler;

class RestoreCoreOp
implements CoreAdminHandler.CoreAdminOp {
    RestoreCoreOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        String name = params.get("name");
        String shardBackupIdStr = params.get("shardBackupId");
        String repoName = params.get("repository");
        if (shardBackupIdStr == null && name == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either 'name' or 'shardBackupId' must be specified");
        }
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
        }
        try (BackupRepository repository = it.handler.coreContainer.newBackupRepository(repoName);
             SolrCore core = it.handler.coreContainer.getCore(cname);){
            RestoreCore restoreCore;
            String location = repository.getBackupLocation(params.get("location"));
            if (location == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property");
            }
            URI locationUri = repository.createDirectoryURI(location);
            CloudDescriptor cd = core.getCoreDescriptor().getCloudDescriptor();
            Slice slice = zkController.getClusterState().getCollection(cd.getCollectionName()).getSlice(cd.getShardId());
            if (slice.getReplicas().size() != 1 && !core.readOnly) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName() + ", the core must be the only replica in its shard or it must be read only");
            }
            if (shardBackupIdStr != null) {
                ShardBackupId shardBackupId = ShardBackupId.from(shardBackupIdStr);
                restoreCore = RestoreCore.createWithMetaFile(repository, core, locationUri, shardBackupId);
            } else {
                restoreCore = RestoreCore.create(repository, core, locationUri, name);
            }
            boolean success = restoreCore.doRestore();
            if (!success) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName());
            }
            zkController.getShardTerms(cd.getCollectionName(), cd.getShardId()).ensureHighestTermsAreNotZero();
        }
    }
}

