/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.TableExpressionFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSamplingParameters;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.stream.Delta;
import org.apache.calcite.rel.stream.LogicalDelta;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.type.TableFunctionReturnTypeInference;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.CollectNamespace;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.MatchRecognizeScope;
import org.apache.calcite.sql.validate.ParameterScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.AuxiliaryConverter;
import org.apache.calcite.sql2rel.DeduplicateCorrelateVariables;
import org.apache.calcite.sql2rel.ImmutableSqlToRelConverter;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.apache.calcite.sql2rel.SqlNodeToRexConverter;
import org.apache.calcite.sql2rel.SqlNodeToRexConverterImpl;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.sql2rel.SubQueryConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;
import org.slf4j.Logger;

@Value.Enclosing
public class SqlToRelConverter {
    public static final Config CONFIG = ImmutableSqlToRelConverter.Config.builder().withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withRelBuilderConfigTransform(c -> c.withPushJoinCondition(true)).withHintStrategyTable(HintStrategyTable.EMPTY).build();
    protected static final Logger SQL2REL_LOGGER = CalciteTrace.getSqlToRelTracer();
    public static final int DEFAULT_IN_SUB_QUERY_THRESHOLD = 20;
    @Deprecated
    public static final int DEFAULT_IN_SUBQUERY_THRESHOLD = 20;
    public final @Nullable SqlValidator validator;
    protected final RexBuilder rexBuilder;
    protected final Prepare.CatalogReader catalogReader;
    protected final RelOptCluster cluster;
    private SubQueryConverter subQueryConverter;
    protected final Map<RelNode, Integer> leaves = new HashMap<RelNode, Integer>();
    private final List<@Nullable SqlDynamicParam> dynamicParamSqlNodes = new ArrayList<SqlDynamicParam>();
    private final SqlOperatorTable opTab;
    protected final RelDataTypeFactory typeFactory;
    private final SqlNodeToRexConverter exprConverter;
    private final HintStrategyTable hintStrategies;
    private int explainParamCount;
    public final Config config;
    private final RelBuilder relBuilder;
    private final Map<CorrelationId, DeferredLookup> mapCorrelToDeferred = new HashMap<CorrelationId, DeferredLookup>();
    private final Deque<String> datasetStack = new ArrayDeque<String>();
    private final Map<SqlNode, RexNode> mapConvertedNonCorrSubqs = new HashMap<SqlNode, RexNode>();
    public final RelOptTable.ViewExpander viewExpander;

    @Deprecated
    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptPlanner planner, RexBuilder rexBuilder, SqlRexConvertletTable convertletTable) {
        this(viewExpander, validator, catalogReader, RelOptCluster.create(planner, rexBuilder), convertletTable, SqlToRelConverter.config());
    }

    @Deprecated
    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable) {
        this(viewExpander, validator, catalogReader, cluster, convertletTable, SqlToRelConverter.config());
    }

    public SqlToRelConverter(RelOptTable.ViewExpander viewExpander, @Nullable SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, Config config) {
        this.viewExpander = viewExpander;
        this.opTab = validator == null ? SqlStdOperatorTable.instance() : validator.getOperatorTable();
        this.validator = validator;
        this.catalogReader = catalogReader;
        this.subQueryConverter = new NoOpSubQueryConverter();
        this.rexBuilder = cluster.getRexBuilder();
        this.typeFactory = this.rexBuilder.getTypeFactory();
        this.exprConverter = new SqlNodeToRexConverterImpl(convertletTable);
        this.explainParamCount = 0;
        this.config = Objects.requireNonNull(config, "config");
        this.relBuilder = config.getRelBuilderFactory().create(cluster, null).transform(config.getRelBuilderConfigTransform());
        this.hintStrategies = config.getHintStrategyTable();
        cluster.setHintStrategies(this.hintStrategies);
        this.cluster = Objects.requireNonNull(cluster, "cluster");
    }

    private SqlValidator validator() {
        return Objects.requireNonNull(this.validator, "validator");
    }

    private <T extends SqlValidatorNamespace> T getNamespace(SqlNode node) {
        return (T)((SqlValidatorNamespace)Objects.requireNonNull(this.getNamespaceOrNull(node), () -> "Namespace is not found for " + node));
    }

    private <T extends SqlValidatorNamespace> @Nullable T getNamespaceOrNull(SqlNode node) {
        return (T)this.validator().getNamespace(node);
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public int getDynamicParamCount() {
        return this.dynamicParamSqlNodes.size();
    }

    public RelDataType getDynamicParamType(int index) {
        SqlNode sqlNode = this.dynamicParamSqlNodes.get(index);
        if (sqlNode == null) {
            throw Util.needToImplement("dynamic param type inference");
        }
        return this.validator().getValidatedNodeType(sqlNode);
    }

    public int getDynamicParamCountInExplain(boolean increment) {
        int retVal = this.explainParamCount++;
        if (increment) {
            // empty if block
        }
        return retVal;
    }

    public Map<SqlNode, RexNode> getMapConvertedNonCorrSubqs() {
        return this.mapConvertedNonCorrSubqs;
    }

    public void addConvertedNonCorrSubqs(Map<SqlNode, RexNode> alreadyConvertedNonCorrSubqs) {
        this.mapConvertedNonCorrSubqs.putAll(alreadyConvertedNonCorrSubqs);
    }

    public void setSubQueryConverter(SubQueryConverter converter) {
        this.subQueryConverter = converter;
    }

    public void setDynamicParamCountInExplain(int explainParamCount) {
        assert (this.config.isExplain());
        this.explainParamCount = explainParamCount;
    }

    private void checkConvertedType(SqlNode query, RelNode result) {
        if (query.isA(SqlKind.DML)) {
            return;
        }
        List<RelDataTypeField> validatedFields = this.validator().getValidatedNodeType(query).getFieldList();
        RelDataType validatedRowType = this.validator().getTypeFactory().createStructType(Pair.right(validatedFields), SqlValidatorUtil.uniquify(Pair.left(validatedFields), this.catalogReader.nameMatcher().isCaseSensitive()));
        List<RelDataTypeField> convertedFields = result.getRowType().getFieldList().subList(0, validatedFields.size());
        RelDataType convertedRowType = this.validator().getTypeFactory().createStructType(convertedFields);
        if (!RelOptUtil.equal("validated row type", validatedRowType, "converted row type", convertedRowType, Litmus.IGNORE)) {
            throw new AssertionError((Object)("Conversion to relational algebra failed to preserve datatypes:\nvalidated type:\n" + validatedRowType.getFullTypeString() + "\nconverted type:\n" + convertedRowType.getFullTypeString() + "\nrel:\n" + RelOptUtil.toString(result)));
        }
    }

    public RelNode flattenTypes(RelNode rootRel, boolean restructure) {
        RelStructuredTypeFlattener typeFlattener = new RelStructuredTypeFlattener(this.relBuilder, this.rexBuilder, this.createToRelContext((List<RelHint>)ImmutableList.of()), restructure);
        return typeFlattener.rewrite(rootRel);
    }

    public RelNode decorrelate(SqlNode query, RelNode rootRel) {
        if (!this.config.isDecorrelationEnabled()) {
            return rootRel;
        }
        RelNode result = this.decorrelateQuery(rootRel);
        if (result != rootRel) {
            this.checkConvertedType(query, result);
        }
        return result;
    }

    public RelNode trimUnusedFields(boolean ordered, RelNode rootRel) {
        if (this.config.isTrimUnusedFields()) {
            RelFieldTrimmer trimmer = this.newFieldTrimmer();
            List<RelCollation> collations = rootRel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
            rootRel = trimmer.trim(rootRel);
            if (!(ordered || collations == null || collations.isEmpty() || collations.equals(ImmutableList.of((Object)RelCollations.EMPTY)))) {
                RelTraitSet traitSet = rootRel.getTraitSet().replace(RelCollationTraitDef.INSTANCE, collations);
                rootRel = rootRel.copy(traitSet, rootRel.getInputs());
            }
            if (SQL2REL_LOGGER.isDebugEnabled()) {
                SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after trimming unused fields", rootRel, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
            }
        }
        return rootRel;
    }

    protected RelFieldTrimmer newFieldTrimmer() {
        return new RelFieldTrimmer(this.validator, this.relBuilder);
    }

    public RelRoot convertQuery(SqlNode query, boolean needsValidation, boolean top) {
        SqlSelect select;
        if (needsValidation) {
            query = this.validator().validate(query);
        }
        RelNode result = this.convertQueryRecursive((SqlNode)query, (boolean)top, null).rel;
        if (top && SqlToRelConverter.isStream(query)) {
            result = new LogicalDelta(this.cluster, result.getTraitSet(), result);
        }
        RelCollation collation = RelCollations.EMPTY;
        if (!query.isA(SqlKind.DML) && SqlToRelConverter.isOrdered(query)) {
            collation = SqlToRelConverter.requiredCollation(result);
        }
        this.checkConvertedType(query, result);
        if (SQL2REL_LOGGER.isDebugEnabled()) {
            SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after converting SqlNode to RelNode", result, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        RelDataType validatedRowType = this.validator().getValidatedNodeType(query);
        ArrayList<RelHint> hints = new ArrayList();
        if (query.getKind() == SqlKind.SELECT && (select = (SqlSelect)query).hasHints()) {
            hints = SqlUtil.getRelHint(this.hintStrategies, select.getHints());
        }
        if (this.config.isAddJsonTypeOperatorEnabled()) {
            result = result.accept(new NestedJsonFunctionRelRewriter());
        }
        result = RelOptUtil.propagateRelHints(result, false);
        return RelRoot.of(result, validatedRowType, query.getKind()).withCollation(collation).withHints(hints);
    }

    private static boolean isStream(SqlNode query) {
        return query instanceof SqlSelect && ((SqlSelect)query).isKeywordPresent(SqlSelectKeyword.STREAM);
    }

    public static boolean isOrdered(SqlNode query) {
        switch (query.getKind()) {
            case SELECT: {
                SqlNodeList orderList = ((SqlSelect)query).getOrderList();
                return orderList != null && orderList.size() > 0;
            }
            case WITH: {
                return SqlToRelConverter.isOrdered(((SqlWith)query).body);
            }
            case ORDER_BY: {
                return ((SqlOrderBy)query).orderList.size() > 0;
            }
        }
        return false;
    }

    private static RelCollation requiredCollation(RelNode r) {
        if (r instanceof Sort) {
            return ((Sort)r).collation;
        }
        if (r instanceof Project) {
            return SqlToRelConverter.requiredCollation(((Project)r).getInput());
        }
        if (r instanceof Delta) {
            return SqlToRelConverter.requiredCollation(((Delta)r).getInput());
        }
        throw new AssertionError();
    }

    public RelNode convertSelect(SqlSelect select, boolean top) {
        SqlValidatorScope selectScope = this.validator().getWhereScope(select);
        Blackboard bb = this.createBlackboard(selectScope, null, top);
        this.convertSelectImpl(bb, select);
        return (RelNode)Nullness.castNonNull((Object)bb.root);
    }

    protected Blackboard createBlackboard(@Nullable SqlValidatorScope scope, @Nullable Map<String, RexNode> nameToNodeMap, boolean top) {
        return new Blackboard(scope, nameToNodeMap, top);
    }

    protected void convertSelectImpl(Blackboard bb, SqlSelect select) {
        this.convertFrom(bb, select.getFrom());
        if (RelOptUtil.isPureOrder((RelNode)Nullness.castNonNull((Object)bb.root)) && this.config.isRemoveSortInSubQuery() && (!bb.top || this.validator().isAggregate(select) || select.isDistinct() || select.hasOrderBy() || select.getFetch() != null || select.getOffset() != null)) {
            bb.setRoot(((RelNode)Nullness.castNonNull((Object)bb.root)).getInput(0), true);
        }
        this.convertWhere(bb, select.getWhere());
        ArrayList<SqlNode> orderExprList = new ArrayList<SqlNode>();
        ArrayList<RelFieldCollation> collationList = new ArrayList<RelFieldCollation>();
        this.gatherOrderExprs(bb, select, select.getOrderList(), orderExprList, collationList);
        RelCollation collation = this.cluster.traitSet().canonize(RelCollations.of(collationList));
        if (this.validator().isAggregate(select)) {
            this.convertAgg(bb, select, orderExprList);
        } else {
            this.convertSelectList(bb, select, orderExprList);
        }
        if (select.isDistinct()) {
            this.distinctify(bb, true);
        }
        this.convertOrder(select, bb, collation, orderExprList, select.getOffset(), select.getFetch());
        if (select.hasHints()) {
            final List<RelHint> hints = SqlUtil.getRelHint(this.hintStrategies, select.getHints());
            bb.setRoot(bb.root().accept(new RelShuttleImpl(){
                boolean attached = false;

                @Override
                public RelNode visitChild(RelNode parent, int i, RelNode child) {
                    if (parent instanceof Hintable && !this.attached) {
                        this.attached = true;
                        return ((Hintable)((Object)parent)).attachHints(hints);
                    }
                    return super.visitChild(parent, i, child);
                }
            }), true);
        } else {
            bb.setRoot(bb.root(), true);
        }
    }

    private void distinctify(Blackboard bb, boolean checkForDupExprs) {
        RelNode rel = bb.root;
        if (checkForDupExprs && rel instanceof LogicalProject) {
            LogicalProject project = (LogicalProject)rel;
            List<RexNode> projectExprs = project.getProjects();
            ArrayList<Integer> origins = new ArrayList<Integer>();
            int dupCount = 0;
            for (int i = 0; i < projectExprs.size(); ++i) {
                int x = projectExprs.indexOf(projectExprs.get(i));
                if (x >= 0 && x < i) {
                    origins.add(x);
                    ++dupCount;
                    continue;
                }
                origins.add(i);
            }
            if (dupCount == 0) {
                this.distinctify(bb, false);
                return;
            }
            HashMap<Integer, Integer> squished = new HashMap<Integer, Integer>();
            List<RelDataTypeField> fields = rel.getRowType().getFieldList();
            ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
            for (int i = 0; i < fields.size(); ++i) {
                if ((Integer)origins.get(i) != i) continue;
                squished.put(i, newProjects.size());
                newProjects.add(RexInputRef.of2(i, fields));
            }
            bb.root = rel = LogicalProject.create(rel, (List<RelHint>)ImmutableList.of(), Pair.left(newProjects), Pair.right(newProjects));
            this.distinctify(bb, false);
            rel = bb.root();
            ArrayList<Pair<RexInputRef, String>> undoProjects = new ArrayList<Pair<RexInputRef, String>>();
            for (int i = 0; i < fields.size(); ++i) {
                int origin = (Integer)origins.get(i);
                RelDataTypeField field = fields.get(i);
                undoProjects.add(Pair.of(new RexInputRef((Integer)Nullness.castNonNull(squished.get(origin)), field.getType()), field.getName()));
            }
            rel = LogicalProject.create(rel, (List<RelHint>)ImmutableList.of(), Pair.left(undoProjects), Pair.right(undoProjects));
            bb.setRoot(rel, false);
            return;
        }
        assert (rel != null) : "rel must not be null, root = " + bb.root;
        ImmutableBitSet groupSet = ImmutableBitSet.range(rel.getRowType().getFieldCount());
        rel = this.createAggregate(bb, groupSet, (ImmutableList<ImmutableBitSet>)ImmutableList.of((Object)groupSet), (List<AggregateCall>)ImmutableList.of());
        bb.setRoot(rel, false);
    }

    protected void convertOrder(SqlSelect select, Blackboard bb, RelCollation collation, List<SqlNode> orderExprList, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        if (this.removeSortInSubQuery(bb.top) || select.getOrderList() == null || select.getOrderList().isEmpty()) {
            assert (this.removeSortInSubQuery(bb.top) || collation.getFieldCollations().isEmpty());
            if ((offset == null || offset instanceof SqlLiteral && Objects.equals(((SqlLiteral)offset).bigDecimalValue(), BigDecimal.ZERO)) && fetch == null) {
                return;
            }
        }
        bb.setRoot(LogicalSort.create(bb.root(), collation, offset == null ? null : this.convertExpression(offset), fetch == null ? null : this.convertExpression(fetch)), false);
        if (orderExprList.size() > 0 && !bb.top) {
            ArrayList<RexInputRef> exprs = new ArrayList<RexInputRef>();
            RelDataType rowType = bb.root().getRowType();
            int fieldCount = rowType.getFieldCount() - orderExprList.size();
            for (int i = 0; i < fieldCount; ++i) {
                exprs.add(this.rexBuilder.makeInputRef(bb.root(), i));
            }
            bb.setRoot(LogicalProject.create(bb.root(), (List<RelHint>)ImmutableList.of(), exprs, rowType.getFieldNames().subList(0, fieldCount)), false);
        }
    }

    private boolean removeSortInSubQuery(boolean top) {
        return this.config.isRemoveSortInSubQuery() && !top;
    }

    private static boolean containsInOperator(SqlNode node) {
        try {
            SqlBasicVisitor<Void> visitor = new SqlBasicVisitor<Void>(){

                @Override
                public Void visit(SqlCall call) {
                    if (call.getOperator() instanceof SqlInOperator) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visit(call);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    private static SqlNode pushDownNotForIn(SqlValidatorScope scope, SqlNode sqlNode) {
        if (!(sqlNode instanceof SqlCall) || !SqlToRelConverter.containsInOperator(sqlNode)) {
            return sqlNode;
        }
        SqlCall sqlCall = (SqlCall)sqlNode;
        switch (sqlCall.getKind()) {
            case AND: 
            case OR: {
                ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
                for (SqlNode operand : sqlCall.getOperandList()) {
                    operands.add(SqlToRelConverter.pushDownNotForIn(scope, operand));
                }
                SqlCall newCall = sqlCall.getOperator().createCall(sqlCall.getParserPosition(), operands);
                return SqlToRelConverter.reg(scope, newCall);
            }
            case NOT: {
                assert (sqlCall.operand(0) instanceof SqlCall);
                SqlCall call = (SqlCall)sqlCall.operand(0);
                switch (((SqlNode)sqlCall.operand(0)).getKind()) {
                    case CASE: {
                        SqlCase caseNode = (SqlCase)call;
                        SqlNodeList thenOperands = new SqlNodeList(SqlParserPos.ZERO);
                        for (SqlNode thenOperand : caseNode.getThenOperands()) {
                            SqlCall not = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, thenOperand);
                            thenOperands.add(SqlToRelConverter.pushDownNotForIn(scope, SqlToRelConverter.reg(scope, not)));
                        }
                        SqlNode elseOperand = Objects.requireNonNull(caseNode.getElseOperand(), "getElseOperand for " + caseNode);
                        if (!SqlUtil.isNull(elseOperand)) {
                            SqlCall not = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, elseOperand);
                            elseOperand = SqlToRelConverter.pushDownNotForIn(scope, SqlToRelConverter.reg(scope, not));
                        }
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.CASE.createCall(SqlParserPos.ZERO, caseNode.getValueOperand(), caseNode.getWhenOperands(), thenOperands, elseOperand));
                    }
                    case AND: {
                        ArrayList<SqlNode> orOperands = new ArrayList<SqlNode>();
                        for (SqlNode operand : call.getOperandList()) {
                            orOperands.add(SqlToRelConverter.pushDownNotForIn(scope, SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, operand))));
                        }
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.OR.createCall(SqlParserPos.ZERO, orOperands));
                    }
                    case OR: {
                        ArrayList<SqlNode> andOperands = new ArrayList<SqlNode>();
                        for (SqlNode operand : call.getOperandList()) {
                            andOperands.add(SqlToRelConverter.pushDownNotForIn(scope, SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, operand))));
                        }
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, andOperands));
                    }
                    case NOT: {
                        assert (call.operandCount() == 1);
                        return SqlToRelConverter.pushDownNotForIn(scope, call.operand(0));
                    }
                    case NOT_IN: {
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, call.getOperandList()));
                    }
                    case IN: {
                        return SqlToRelConverter.reg(scope, SqlStdOperatorTable.NOT_IN.createCall(SqlParserPos.ZERO, call.getOperandList()));
                    }
                }
                break;
            }
        }
        return sqlNode;
    }

    private static SqlNode reg(SqlValidatorScope scope, SqlNode e) {
        scope.getValidator().deriveType(scope, e);
        return e;
    }

    private void convertWhere(Blackboard bb, @Nullable SqlNode where) {
        RelNode r;
        if (where == null) {
            return;
        }
        SqlNode newWhere = SqlToRelConverter.pushDownNotForIn(bb.scope(), where);
        this.replaceSubQueries(bb, newWhere, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
        RexNode convertedWhere = bb.convertExpression(newWhere);
        RexNode convertedWhere2 = RexUtil.removeNullabilityCast(this.typeFactory, convertedWhere);
        if (convertedWhere2.isAlwaysTrue()) {
            return;
        }
        RelFactories.FilterFactory filterFactory = RelFactories.DEFAULT_FILTER_FACTORY;
        RelNode filter = filterFactory.createFilter(bb.root(), convertedWhere2, (Set<CorrelationId>)ImmutableSet.of());
        CorrelationUse p = this.getCorrelationUse(bb, filter);
        if (p != null) {
            assert (p.r instanceof Filter);
            Filter f = (Filter)p.r;
            r = LogicalFilter.create(f.getInput(), f.getCondition(), (ImmutableSet<CorrelationId>)ImmutableSet.of((Object)p.id));
        } else {
            r = filter;
        }
        bb.setRoot(r, false);
    }

    private void replaceSubQueries(Blackboard bb, SqlNode expr, RelOptUtil.Logic logic) {
        this.findSubQueries(bb, expr, logic, false);
        for (SubQuery node : bb.subQueryList) {
            this.substituteSubQuery(bb, node);
        }
    }

    private void substituteSubQuery(Blackboard bb, SubQuery subQuery) {
        RexNode expr = subQuery.expr;
        if (expr != null) {
            return;
        }
        switch (subQuery.node.getKind()) {
            case CURSOR: {
                this.convertCursor(bb, subQuery);
                return;
            }
            case ARRAY_QUERY_CONSTRUCTOR: 
            case MAP_QUERY_CONSTRUCTOR: 
            case MULTISET_QUERY_CONSTRUCTOR: {
                if (!this.config.isExpand()) {
                    return;
                }
            }
            case MULTISET_VALUE_CONSTRUCTOR: {
                RelNode rel = this.convertMultisets((List<SqlNode>)ImmutableList.of((Object)subQuery.node), bb);
                subQuery.expr = bb.register(rel, JoinRelType.INNER);
                return;
            }
            case NOT_IN: 
            case IN: 
            case SOME: 
            case ALL: {
                SqlNodeList valueList;
                ImmutableList leftKeys;
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(1);
                if (!this.config.isExpand() && !(query instanceof SqlNodeList)) {
                    return;
                }
                Object leftKeyNode = call.operand(0);
                switch (((SqlNode)leftKeyNode).getKind()) {
                    case ROW: {
                        leftKeys = new ArrayList();
                        for (SqlNode sqlExpr : ((SqlBasicCall)leftKeyNode).getOperandList()) {
                            leftKeys.add(bb.convertExpression(sqlExpr));
                        }
                        break;
                    }
                    default: {
                        leftKeys = ImmutableList.of((Object)bb.convertExpression((SqlNode)leftKeyNode));
                    }
                }
                if (query instanceof SqlNodeList && ((valueList = (SqlNodeList)query).size() < this.config.getInSubQueryThreshold() || valueList.accept(new SqlIdentifierFinder()).booleanValue())) {
                    subQuery.expr = this.convertInToOr(bb, (List<RexNode>)leftKeys, valueList, (SqlInOperator)call.getOperator());
                    return;
                }
                if (bb.root == null) {
                    return;
                }
                RelDataType targetRowType = SqlTypeUtil.promoteToRowType(this.typeFactory, this.validator().getValidatedNodeType((SqlNode)leftKeyNode), null);
                boolean notIn = call.getOperator().kind == SqlKind.NOT_IN;
                RelOptUtil.Exists converted = this.convertExists((SqlNode)query, RelOptUtil.SubQueryType.IN, subQuery.logic, notIn, targetRowType);
                if (converted.indicator) {
                    RelDataType longType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
                    RelNode seek = converted.r.getInput(0);
                    int keyCount = leftKeys.size();
                    List<Integer> args = ImmutableIntList.range(0, keyCount);
                    LogicalAggregate aggregate = LogicalAggregate.create(seek, (List<RelHint>)ImmutableList.of(), ImmutableBitSet.of(), null, (List<AggregateCall>)ImmutableList.of((Object)AggregateCall.create(SqlStdOperatorTable.COUNT, false, false, false, (List<Integer>)ImmutableList.of(), -1, null, RelCollations.EMPTY, longType, null), (Object)AggregateCall.create(SqlStdOperatorTable.COUNT, false, false, false, args, -1, null, RelCollations.EMPTY, longType, null)));
                    LogicalJoin join = LogicalJoin.create(bb.root(), aggregate, (List<RelHint>)ImmutableList.of(), this.rexBuilder.makeLiteral(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER);
                    bb.setRoot(join, false);
                }
                RexNode rex = bb.register(converted.r, converted.outerJoin ? JoinRelType.LEFT : JoinRelType.INNER, (List<RexNode>)leftKeys);
                RelOptUtil.Logic logic = subQuery.logic;
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        if (converted.indicator) break;
                        logic = RelOptUtil.Logic.TRUE_FALSE;
                        break;
                    }
                }
                subQuery.expr = this.translateIn(logic, bb.root, rex);
                if (notIn) {
                    subQuery.expr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, subQuery.expr);
                }
                return;
            }
            case EXISTS: {
                if (!this.config.isExpand()) {
                    return;
                }
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(0);
                SqlValidatorScope seekScope = query instanceof SqlSelect ? this.validator().getSelectScope((SqlSelect)query) : null;
                Blackboard seekBb = this.createBlackboard(seekScope, null, false);
                RelNode seekRel = this.convertQueryOrInList(seekBb, (SqlNode)query, null);
                Objects.requireNonNull(seekRel, () -> "seekRel is null for query " + query);
                RelMetadataQuery mq = seekRel.getCluster().getMetadataQuery();
                Double minRowCount = mq.getMinRowCount(seekRel);
                if (minRowCount != null && minRowCount >= 1.0) {
                    subQuery.expr = this.rexBuilder.makeLiteral(true);
                    return;
                }
                RelOptUtil.Exists converted = RelOptUtil.createExistsPlan(seekRel, RelOptUtil.SubQueryType.EXISTS, subQuery.logic, true, this.relBuilder);
                assert (!converted.indicator);
                if (this.convertNonCorrelatedSubQuery(subQuery, bb, converted.r, true)) {
                    return;
                }
                subQuery.expr = bb.register(converted.r, JoinRelType.LEFT);
                return;
            }
            case UNIQUE: {
                return;
            }
            case SCALAR_QUERY: {
                if (!this.config.isExpand()) {
                    return;
                }
                SqlBasicCall call = (SqlBasicCall)subQuery.node;
                Object query = call.operand(0);
                RelOptUtil.Exists converted = this.convertExists((SqlNode)query, RelOptUtil.SubQueryType.SCALAR, subQuery.logic, true, null);
                assert (!converted.indicator);
                if (this.convertNonCorrelatedSubQuery(subQuery, bb, converted.r, false)) {
                    return;
                }
                RelNode rel = this.convertToSingleValueSubq((SqlNode)query, converted.r);
                subQuery.expr = bb.register(rel, JoinRelType.LEFT);
                return;
            }
            case SELECT: {
                RelOptUtil.Exists converted = this.convertExists(subQuery.node, RelOptUtil.SubQueryType.SCALAR, subQuery.logic, true, null);
                assert (!converted.indicator);
                subQuery.expr = bb.register(converted.r, JoinRelType.LEFT);
                bb.cursors.add(converted.r);
                return;
            }
            case SET_SEMANTICS_TABLE: {
                if (!this.config.isExpand()) {
                    return;
                }
                this.substituteSubQueryOfSetSemanticsInputTable(bb, subQuery);
                return;
            }
        }
        throw new AssertionError((Object)("unexpected kind of sub-query: " + subQuery.node));
    }

    private void substituteSubQueryOfSetSemanticsInputTable(Blackboard bb, SubQuery subQuery) {
        SqlBasicCall call = (SqlBasicCall)subQuery.node;
        Object query = call.operand(0);
        SqlValidatorScope innerTableScope = query instanceof SqlSelect ? this.validator().getSelectScope((SqlSelect)query) : null;
        Blackboard setSemanticsTableBb = this.createBlackboard(innerTableScope, null, false);
        RelNode inputOfSetSemanticsTable = this.convertQueryRecursive((SqlNode)query, false, null).project();
        Objects.requireNonNull(inputOfSetSemanticsTable, () -> "input RelNode is null for query " + query);
        SqlNodeList partitionList = (SqlNodeList)call.operand(1);
        ImmutableBitSet partitionKeys = this.buildPartitionKeys(setSemanticsTableBb, partitionList);
        RelDistribution distribution = partitionKeys.isEmpty() ? RelDistributions.SINGLETON : RelDistributions.hash(partitionKeys.asList());
        SqlNodeList orderList = (SqlNodeList)call.operand(2);
        RelCollation orders = this.buildCollation(setSemanticsTableBb, orderList);
        this.relBuilder.push(inputOfSetSemanticsTable);
        if (orderList.isEmpty()) {
            this.relBuilder.exchange(distribution);
        } else {
            this.relBuilder.sortExchange(distribution, orders);
        }
        RelNode tableRel = this.relBuilder.build();
        subQuery.expr = bb.register(tableRel, JoinRelType.LEFT);
        bb.cursors.add(tableRel);
    }

    private ImmutableBitSet buildPartitionKeys(Blackboard bb, SqlNodeList partitionList) {
        ImmutableBitSet.Builder partitionKeys = ImmutableBitSet.builder();
        for (SqlNode partition : partitionList) {
            this.validator().deriveType(bb.scope(), partition);
            RexNode e = bb.convertExpression(partition);
            partitionKeys.set(SqlToRelConverter.parseFieldIdx(e));
        }
        return partitionKeys.build();
    }

    private RelCollation buildCollation(Blackboard bb, SqlNodeList orderList) {
        ArrayList<RelFieldCollation> orderKeys = new ArrayList<RelFieldCollation>();
        for (SqlNode orderItem : orderList) {
            orderKeys.add(this.convertOrderItem(bb, orderItem, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED));
        }
        return this.cluster.traitSet().canonize(RelCollations.of(orderKeys));
    }

    private RelFieldCollation convertOrderItem(Blackboard bb, SqlNode orderItem, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        switch (orderItem.getKind()) {
            case DESCENDING: {
                return this.convertOrderItem(bb, (SqlNode)((SqlCall)orderItem).operand(0), RelFieldCollation.Direction.DESCENDING, nullDirection);
            }
            case NULLS_FIRST: {
                return this.convertOrderItem(bb, (SqlNode)((SqlCall)orderItem).operand(0), direction, RelFieldCollation.NullDirection.FIRST);
            }
            case NULLS_LAST: {
                return this.convertOrderItem(bb, (SqlNode)((SqlCall)orderItem).operand(0), direction, RelFieldCollation.NullDirection.LAST);
            }
        }
        switch (nullDirection) {
            case UNSPECIFIED: {
                nullDirection = this.validator().config().defaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
                break;
            }
        }
        RexNode e = bb.convertExpression(orderItem);
        return new RelFieldCollation(SqlToRelConverter.parseFieldIdx(e), direction, nullDirection);
    }

    private static int parseFieldIdx(RexNode e) {
        switch (e.getKind()) {
            case FIELD_ACCESS: {
                RexFieldAccess f = (RexFieldAccess)e;
                return f.getField().getIndex();
            }
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)e;
                return ref.getIndex();
            }
        }
        throw new AssertionError();
    }

    private RexNode translateIn(RelOptUtil.Logic logic, @Nullable RelNode root, RexNode rex) {
        switch (logic) {
            case TRUE: {
                return this.rexBuilder.makeLiteral(true);
            }
            case TRUE_FALSE: 
            case UNKNOWN_AS_FALSE: {
                assert (rex instanceof RexRangeRef);
                int fieldCount = rex.getType().getFieldCount();
                RexNode rexNode = this.rexBuilder.makeFieldAccess(rex, fieldCount - 1);
                rexNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, rexNode);
                int k = (fieldCount - 1) / 2;
                ImmutableList.Builder rexNodeBuilder = ImmutableList.builder();
                rexNodeBuilder.add((Object)rexNode);
                for (int i = 0; i < k; ++i) {
                    rexNodeBuilder.add((Object)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, this.rexBuilder.makeFieldAccess(rex, i)));
                }
                rexNode = this.rexBuilder.makeCall(rexNode.getType(), SqlStdOperatorTable.AND, RexUtil.flatten((List<? extends RexNode>)rexNodeBuilder.build(), SqlStdOperatorTable.AND));
                return rexNode;
            }
            case TRUE_FALSE_UNKNOWN: 
            case UNKNOWN_AS_TRUE: {
                Join join = (Join)Objects.requireNonNull(root, "root");
                Project left = (Project)join.getLeft();
                RelNode leftLeft = ((Join)left.getInput()).getLeft();
                int leftLeftCount = leftLeft.getRowType().getFieldCount();
                RelDataType longType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
                RexInputRef cRef = this.rexBuilder.makeInputRef(root, leftLeftCount);
                RexInputRef ckRef = this.rexBuilder.makeInputRef(root, leftLeftCount + 1);
                RexInputRef iRef = this.rexBuilder.makeInputRef(root, root.getRowType().getFieldCount() - 1);
                RexLiteral zero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO, longType);
                RexLiteral trueLiteral = this.rexBuilder.makeLiteral(true);
                RexLiteral falseLiteral = this.rexBuilder.makeLiteral(false);
                RexLiteral unknownLiteral = this.rexBuilder.makeNullLiteral(trueLiteral.getType());
                ImmutableList.Builder args = ImmutableList.builder();
                args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, cRef, zero), falseLiteral, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, iRef), trueLiteral});
                JoinInfo joinInfo = join.analyzeCondition();
                for (int leftKey : joinInfo.leftKeys) {
                    RexInputRef kRef = this.rexBuilder.makeInputRef(root, leftKey);
                    args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, kRef), unknownLiteral});
                }
                args.add((Object[])new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, ckRef, cRef), unknownLiteral, falseLiteral});
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, (List<? extends RexNode>)args.build());
            }
        }
        throw new AssertionError((Object)logic);
    }

    private boolean convertNonCorrelatedSubQuery(SubQuery subQuery, Blackboard bb, RelNode converted, boolean isExists) {
        SqlBasicCall call = (SqlBasicCall)subQuery.node;
        if (this.subQueryConverter.canConvertSubQuery() && this.isSubQueryNonCorrelated(converted, bb)) {
            RexNode constExpr = this.mapConvertedNonCorrSubqs.get(call);
            if (constExpr == null) {
                constExpr = this.subQueryConverter.convertSubQuery(call, this, isExists, this.config.isExplain());
            }
            if (constExpr != null) {
                subQuery.expr = constExpr;
                this.mapConvertedNonCorrSubqs.put(call, constExpr);
                return true;
            }
        }
        return false;
    }

    public RelNode convertToSingleValueSubq(SqlNode query, RelNode plan) {
        SqlCall exprCall;
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = select.getSelectList();
            SqlNodeList groupList = select.getGroup();
            if (selectList.size() == 1 && (groupList == null || groupList.size() == 0)) {
                long value;
                SqlCall selectExprCall;
                SqlNode selectExpr = selectList.get(0);
                if (selectExpr instanceof SqlCall && Util.isSingleValue(selectExprCall = (SqlCall)selectExpr)) {
                    return plan;
                }
                SqlNode fetch = select.getFetch();
                if (fetch instanceof SqlNumericLiteral && (value = ((SqlNumericLiteral)fetch).getValueAs(Long.class).longValue()) < 2L) {
                    return plan;
                }
            }
        } else if (query instanceof SqlCall && (exprCall = (SqlCall)query).getOperator() instanceof SqlValuesOperator && Util.isSingleValue(exprCall)) {
            return plan;
        }
        return RelOptUtil.createSingleValueAggRel(this.cluster, plan);
    }

    private @Nullable RexNode convertInToOr(Blackboard bb, List<RexNode> leftKeys, SqlNodeList valuesList, SqlInOperator op) {
        ArrayList<RexNode> comparisons = new ArrayList<RexNode>();
        for (SqlNode rightVals : valuesList) {
            RexNode rexComparison;
            SqlOperator comparisonOp = op instanceof SqlQuantifyOperator ? RelOptUtil.op(((SqlQuantifyOperator)op).comparisonKind, SqlStdOperatorTable.EQUALS) : SqlStdOperatorTable.EQUALS;
            if (leftKeys.size() == 1) {
                rexComparison = this.rexBuilder.makeCall(comparisonOp, leftKeys.get(0), this.ensureSqlType(leftKeys.get(0).getType(), bb.convertExpression(rightVals)));
            } else {
                assert (rightVals instanceof SqlCall);
                SqlBasicCall call = (SqlBasicCall)rightVals;
                assert (call.getOperator() instanceof SqlRowOperator && call.operandCount() == leftKeys.size());
                rexComparison = RexUtil.composeConjunction(this.rexBuilder, Util.transform(Pair.zip(leftKeys, call.getOperandList()), pair -> this.rexBuilder.makeCall(comparisonOp, (RexNode)pair.left, this.ensureSqlType(((RexNode)Objects.requireNonNull(pair.left, "pair.left")).getType(), bb.convertExpression((SqlNode)pair.right)))));
            }
            comparisons.add(rexComparison);
        }
        switch (op.kind) {
            case ALL: {
                return RexUtil.composeConjunction(this.rexBuilder, comparisons, true);
            }
            case NOT_IN: {
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, RexUtil.composeDisjunction(this.rexBuilder, comparisons));
            }
            case IN: 
            case SOME: {
                return RexUtil.composeDisjunction(this.rexBuilder, comparisons, true);
            }
        }
        throw new AssertionError();
    }

    private RexNode ensureSqlType(RelDataType type, RexNode node) {
        if (type.getSqlTypeName() == node.getType().getSqlTypeName() || type.getSqlTypeName() == SqlTypeName.VARCHAR && node.getType().getSqlTypeName() == SqlTypeName.CHAR) {
            return node;
        }
        return this.rexBuilder.ensureType(type, node, true);
    }

    @Deprecated
    protected int getInSubqueryThreshold() {
        return this.config.getInSubQueryThreshold();
    }

    private RelOptUtil.Exists convertExists(SqlNode seek, RelOptUtil.SubQueryType subQueryType, RelOptUtil.Logic logic, boolean notIn, @Nullable RelDataType targetDataType) {
        SqlValidatorScope seekScope = seek instanceof SqlSelect ? this.validator().getSelectScope((SqlSelect)seek) : null;
        Blackboard seekBb = this.createBlackboard(seekScope, null, false);
        RelNode seekRel = this.convertQueryOrInList(seekBb, seek, targetDataType);
        Objects.requireNonNull(seekRel, () -> "seekRel is null for query " + seek);
        return RelOptUtil.createExistsPlan(seekRel, subQueryType, logic, notIn, this.relBuilder);
    }

    private @Nullable RelNode convertQueryOrInList(Blackboard bb, SqlNode seek, @Nullable RelDataType targetRowType) {
        if (seek instanceof SqlNodeList) {
            return this.convertRowValues(bb, seek, (SqlNodeList)seek, false, targetRowType);
        }
        return this.convertQueryRecursive(seek, false, null).project();
    }

    private @Nullable RelNode convertRowValues(Blackboard bb, SqlNode rowList, Collection<SqlNode> rows, boolean allowLiteralsOnly, @Nullable RelDataType targetRowType) {
        AbstractRelNode resultRel;
        ImmutableList.Builder tupleList = ImmutableList.builder();
        RelDataType listType = this.validator().getValidatedNodeType(rowList);
        RelDataType rowType = targetRowType != null ? SqlTypeUtil.keepSourceTypeAndTargetNullability(targetRowType, listType, this.typeFactory) : SqlTypeUtil.promoteToRowType(this.typeFactory, listType, null);
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        for (SqlNode node : rows) {
            SqlBasicCall call;
            if (SqlToRelConverter.isRowConstructor(node)) {
                call = (SqlBasicCall)node;
                ImmutableList.Builder tuple = ImmutableList.builder();
                for (Ord operand : Ord.zip(call.getOperandList())) {
                    RexLiteral rexLiteral = this.convertLiteralInValuesList((SqlNode)operand.e, bb, rowType, operand.i);
                    if (rexLiteral == null && allowLiteralsOnly) {
                        return null;
                    }
                    if (rexLiteral == null || !this.config.isCreateValuesRel()) {
                        tuple = null;
                        break;
                    }
                    tuple.add((Object)rexLiteral);
                }
                if (tuple != null) {
                    tupleList.add((Object)tuple.build());
                    continue;
                }
            } else {
                RexLiteral rexLiteral = this.convertLiteralInValuesList(node, bb, rowType, 0);
                if (rexLiteral != null && this.config.isCreateValuesRel()) {
                    tupleList.add((Object)ImmutableList.of((Object)rexLiteral));
                    continue;
                }
                if (rexLiteral == null && allowLiteralsOnly) {
                    return null;
                }
                call = (SqlBasicCall)SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, node);
            }
            unionInputs.add(this.convertRowConstructor(bb, call));
        }
        LogicalValues values = LogicalValues.create(this.cluster, rowType, (ImmutableList<ImmutableList<RexLiteral>>)tupleList.build());
        if (unionInputs.isEmpty()) {
            resultRel = values;
        } else {
            if (!values.getTuples().isEmpty()) {
                unionInputs.add(values);
            }
            resultRel = LogicalUnion.create(unionInputs, true);
        }
        this.leaves.put(resultRel, resultRel.getRowType().getFieldCount());
        return resultRel;
    }

    private @Nullable RexLiteral convertLiteralInValuesList(@Nullable SqlNode sqlNode, Blackboard bb, RelDataType rowType, int iField) {
        if (!(sqlNode instanceof SqlLiteral)) {
            return null;
        }
        RelDataTypeField field = rowType.getFieldList().get(iField);
        RelDataType type = field.getType();
        if (type.isStruct()) {
            return null;
        }
        return this.convertLiteral((SqlLiteral)sqlNode, bb, type);
    }

    private RexLiteral convertLiteral(SqlLiteral sqlLiteral, Blackboard bb, RelDataType type) {
        RexNode literalExpr = this.exprConverter.convertLiteral(bb, sqlLiteral);
        if (!(literalExpr instanceof RexLiteral)) {
            assert (literalExpr.isA(SqlKind.CAST));
            RexNode child = ((RexCall)literalExpr).getOperands().get(0);
            assert (RexLiteral.isNullLiteral(child));
            return (RexLiteral)child;
        }
        RexLiteral literal = (RexLiteral)literalExpr;
        Comparable value = literal.getValue();
        if (SqlTypeUtil.isExactNumeric(type) && SqlTypeUtil.hasScale(type)) {
            BigDecimal roundedValue = NumberUtil.rescaleBigDecimal((BigDecimal)value, type.getScale());
            return this.rexBuilder.makeExactLiteral(roundedValue, type);
        }
        if (value instanceof NlsString && type.getSqlTypeName() == SqlTypeName.CHAR) {
            NlsString unpadded = (NlsString)value;
            return this.rexBuilder.makeCharLiteral(new NlsString(Spaces.padRight((String)unpadded.getValue(), (int)type.getPrecision()), unpadded.getCharsetName(), unpadded.getCollation()));
        }
        return literal;
    }

    private static boolean isRowConstructor(SqlNode node) {
        if (node.getKind() != SqlKind.ROW) {
            return false;
        }
        SqlCall call = (SqlCall)node;
        return call.getOperator().getName().equalsIgnoreCase("row");
    }

    private void findSubQueries(Blackboard bb, SqlNode node, RelOptUtil.Logic logic, boolean registerOnlyScalarSubQueries) {
        SqlKind kind = node.getKind();
        switch (kind) {
            case SELECT: 
            case CURSOR: 
            case ARRAY_QUERY_CONSTRUCTOR: 
            case MAP_QUERY_CONSTRUCTOR: 
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: 
            case EXISTS: 
            case UNIQUE: 
            case SCALAR_QUERY: 
            case SET_SEMANTICS_TABLE: {
                if (!registerOnlyScalarSubQueries || kind == SqlKind.SCALAR_QUERY) {
                    bb.registerSubQuery(node, RelOptUtil.Logic.TRUE_FALSE);
                }
                return;
            }
            case IN: {
                break;
            }
            case NOT: 
            case NOT_IN: {
                logic = logic.negate();
                break;
            }
        }
        if (node instanceof SqlCall) {
            switch (kind) {
                case AND: 
                case NOT_IN: 
                case IN: {
                    break;
                }
                default: {
                    logic = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
                }
            }
            for (SqlNode operand : ((SqlCall)node).getOperandList()) {
                if (operand == null) continue;
                this.findSubQueries(bb, operand, logic, kind == SqlKind.IN || kind == SqlKind.NOT_IN || kind == SqlKind.SOME || kind == SqlKind.ALL || registerOnlyScalarSubQueries);
            }
        } else if (node instanceof SqlNodeList) {
            for (SqlNode child : (SqlNodeList)node) {
                this.findSubQueries(bb, child, logic, kind == SqlKind.IN || kind == SqlKind.NOT_IN || kind == SqlKind.SOME || kind == SqlKind.ALL || registerOnlyScalarSubQueries);
            }
        }
        switch (kind) {
            case NOT_IN: 
            case IN: 
            case SOME: 
            case ALL: {
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: {
                        RelDataType type = this.validator().getValidatedNodeTypeIfKnown(node);
                        if (type != null) break;
                        return;
                    }
                    case UNKNOWN_AS_FALSE: {
                        logic = RelOptUtil.Logic.TRUE;
                        break;
                    }
                }
                bb.registerSubQuery(node, logic);
                break;
            }
        }
    }

    public RexNode convertExpression(SqlNode node) {
        Map<String, RelDataType> nameToTypeMap = Collections.emptyMap();
        ParameterScope scope = new ParameterScope((SqlValidatorImpl)this.validator(), nameToTypeMap);
        Blackboard bb = this.createBlackboard(scope, null, false);
        this.replaceSubQueries(bb, node, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        return bb.convertExpression(node);
    }

    public RexNode convertExpression(SqlNode node, Map<String, RexNode> nameToNodeMap) {
        HashMap<String, RelDataType> nameToTypeMap = new HashMap<String, RelDataType>();
        for (Map.Entry<String, RexNode> entry : nameToNodeMap.entrySet()) {
            nameToTypeMap.put(entry.getKey(), entry.getValue().getType());
        }
        ParameterScope scope = new ParameterScope((SqlValidatorImpl)this.validator(), nameToTypeMap);
        Blackboard bb = this.createBlackboard(scope, nameToNodeMap, false);
        this.replaceSubQueries(bb, node, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        return bb.convertExpression(node);
    }

    protected @Nullable RexNode convertExtendedExpression(SqlNode node, Blackboard bb) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RexNode convertOver(Blackboard bb, SqlNode node) {
        SqlCall call = (SqlCall)node;
        SqlCall aggCall = (SqlCall)call.operand(0);
        boolean ignoreNulls = false;
        switch (aggCall.getKind()) {
            case IGNORE_NULLS: {
                ignoreNulls = true;
            }
            case RESPECT_NULLS: {
                aggCall = (SqlCall)aggCall.operand(0);
                break;
            }
        }
        Object windowOrRef = call.operand(1);
        SqlWindow window = this.validator().resolveWindow((SqlNode)windowOrRef, bb.scope());
        SqlNode sqlLowerBound = window.getLowerBound();
        SqlNode sqlUpperBound = window.getUpperBound();
        boolean rows = window.isRows();
        SqlNodeList orderList = window.getOrderList();
        if (!aggCall.getOperator().allowsFraming()) {
            sqlLowerBound = SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO);
            sqlUpperBound = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
            if (aggCall.getKind() == SqlKind.ROW_NUMBER) {
                rows = true;
            }
        } else if (orderList.size() == 0) {
            sqlLowerBound = SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO);
            sqlUpperBound = SqlWindow.createUnboundedFollowing(SqlParserPos.ZERO);
        } else if (sqlLowerBound == null && sqlUpperBound == null) {
            sqlLowerBound = SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO);
            sqlUpperBound = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
        } else if (sqlUpperBound == null) {
            sqlUpperBound = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
        } else if (sqlLowerBound == null) {
            sqlLowerBound = SqlWindow.createCurrentRow(SqlParserPos.ZERO);
        }
        SqlNodeList partitionList = window.getPartitionList();
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        for (SqlNode partition : partitionList) {
            this.validator().deriveType(bb.scope(), partition);
            partitionKeys.add((Object)bb.convertExpression(partition));
        }
        RexNode lowerBound = bb.convertExpression(Objects.requireNonNull(sqlLowerBound, "sqlLowerBound"));
        RexNode upperBound = bb.convertExpression(Objects.requireNonNull(sqlUpperBound, "sqlUpperBound"));
        if (orderList.size() == 0 && !rows && (orderList = bb.scope().getOrderList()) == null) {
            throw new AssertionError((Object)"Relation should have sort key for implicit ORDER BY");
        }
        ImmutableList.Builder orderKeys = ImmutableList.builder();
        for (SqlNode order : orderList) {
            orderKeys.add((Object)bb.convertSortExpression(order, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED, (x$0, x$1, x$2) -> bb.sortToRex(x$0, x$1, x$2)));
        }
        try {
            Preconditions.checkArgument((bb.window == null ? 1 : 0) != 0, (Object)"already in window agg mode");
            bb.window = window;
            RexNode rexAgg = this.exprConverter.convertCall(bb, aggCall);
            rexAgg = this.rexBuilder.ensureType(this.validator().getValidatedNodeType(call), rexAgg, false);
            SqlLiteral q = aggCall.getFunctionQuantifier();
            boolean isDistinct = q != null && q.getValue() == SqlSelectKeyword.DISTINCT;
            HistogramShuttle visitor = new HistogramShuttle((ImmutableList<RexNode>)partitionKeys.build(), (ImmutableList<RexNode>)orderKeys.build(), rows, RexWindowBounds.create(sqlLowerBound, lowerBound), RexWindowBounds.create(sqlUpperBound, upperBound), window.isAllowPartial(), isDistinct, ignoreNulls);
            RexNode rexNode = rexAgg.accept(visitor);
            return rexNode;
        }
        finally {
            bb.window = null;
        }
    }

    protected void convertFrom(Blackboard bb, @Nullable SqlNode from) {
        this.convertFrom(bb, from, Collections.emptyList());
    }

    protected void convertFrom(Blackboard bb, @Nullable SqlNode from, @Nullable List<String> fieldNames) {
        if (from == null) {
            bb.setRoot(LogicalValues.createOneRow(this.cluster), false);
            return;
        }
        switch (from.getKind()) {
            case AS: {
                SqlCall call = (SqlCall)from;
                Object firstOperand = call.operand(0);
                List<String> fieldNameList = call.operandCount() > 2 ? SqlIdentifier.simpleNames(Util.skip(call.getOperandList(), 2)) : null;
                this.convertFrom(bb, (SqlNode)firstOperand, fieldNameList);
                return;
            }
            case MATCH_RECOGNIZE: {
                this.convertMatchRecognize(bb, (SqlMatchRecognize)from);
                return;
            }
            case PIVOT: {
                this.convertPivot(bb, (SqlPivot)from);
                return;
            }
            case UNPIVOT: {
                this.convertUnpivot(bb, (SqlUnpivot)from);
                return;
            }
            case WITH_ITEM: {
                this.convertFrom(bb, ((SqlWithItem)from).query);
                return;
            }
            case WITH: {
                this.convertFrom(bb, ((SqlWith)from).body);
                return;
            }
            case TABLESAMPLE: {
                List<SqlNode> operands = ((SqlCall)from).getOperandList();
                SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(Objects.requireNonNull(operands.get(1), () -> "operand[1] of " + from));
                if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                    String sampleName = ((SqlSampleSpec.SqlSubstitutionSampleSpec)sampleSpec).getName();
                    this.datasetStack.push(sampleName);
                    this.convertFrom(bb, operands.get(0));
                    this.datasetStack.pop();
                } else if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                    SqlSampleSpec.SqlTableSampleSpec tableSampleSpec = (SqlSampleSpec.SqlTableSampleSpec)sampleSpec;
                    this.convertFrom(bb, operands.get(0));
                    RelOptSamplingParameters params = new RelOptSamplingParameters(tableSampleSpec.isBernoulli(), tableSampleSpec.getSamplePercentage(), tableSampleSpec.isRepeatable(), tableSampleSpec.getRepeatableSeed());
                    bb.setRoot(new Sample(this.cluster, bb.root(), params), false);
                } else {
                    throw new AssertionError((Object)("unknown TABLESAMPLE type: " + sampleSpec));
                }
                return;
            }
            case TABLE_REF: {
                SqlCall call = (SqlCall)from;
                this.convertIdentifier(bb, (SqlIdentifier)call.operand(0), null, (SqlNodeList)call.operand(1));
                return;
            }
            case IDENTIFIER: {
                this.convertIdentifier(bb, (SqlIdentifier)from, null, null);
                return;
            }
            case EXTEND: {
                SqlCall call = (SqlCall)from;
                SqlNode operand0 = call.getOperandList().get(0);
                SqlIdentifier id = operand0.getKind() == SqlKind.TABLE_REF ? (SqlIdentifier)((SqlCall)operand0).operand(0) : (SqlIdentifier)operand0;
                SqlNodeList extendedColumns = (SqlNodeList)call.getOperandList().get(1);
                this.convertIdentifier(bb, id, extendedColumns, null);
                return;
            }
            case SNAPSHOT: {
                this.convertTemporalTable(bb, (SqlCall)from);
                return;
            }
            case JOIN: {
                this.convertJoin(bb, (SqlJoin)from);
                return;
            }
            case SELECT: 
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                RelNode rel = this.convertQueryRecursive(from, false, null).project();
                bb.setRoot(rel, true);
                return;
            }
            case VALUES: {
                this.convertValuesImpl(bb, (SqlCall)from, null);
                if (fieldNames != null) {
                    bb.setRoot(this.relBuilder.push(bb.root()).rename(fieldNames).build(), true);
                }
                return;
            }
            case UNNEST: {
                this.convertUnnest(bb, (SqlCall)from, fieldNames);
                return;
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)from;
                assert (call.getOperandList().size() == 1);
                SqlCall call2 = (SqlCall)call.operand(0);
                this.convertCollectionTable(bb, call2);
                return;
            }
        }
        throw new AssertionError((Object)("not a join operator " + from));
    }

    private void convertUnnest(Blackboard bb, SqlCall call, @Nullable List<String> fieldNames) {
        List<SqlNode> nodes = call.getOperandList();
        SqlUnnestOperator operator = (SqlUnnestOperator)call.getOperator();
        for (SqlNode sqlNode : nodes) {
            this.replaceSubQueries(bb, sqlNode, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        }
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (Ord node : Ord.zip(nodes)) {
            exprs.add(this.relBuilder.alias(bb.convertExpression((SqlNode)node.e), this.validator().deriveAlias((SqlNode)node.e, node.i)));
        }
        RelNode relNode = null != bb.root ? bb.root : LogicalValues.createOneRow(this.cluster);
        RelNode uncollect = this.validator().config().conformance().allowAliasUnnestItems() ? this.relBuilder.push(relNode).project(exprs).uncollect(Objects.requireNonNull(fieldNames, "fieldNames"), operator.withOrdinality).build() : this.relBuilder.push(relNode).project(exprs).uncollect(Collections.emptyList(), operator.withOrdinality).let(r -> fieldNames == null ? r : r.rename(fieldNames)).build();
        bb.setRoot(uncollect, true);
    }

    protected void convertMatchRecognize(Blackboard bb, SqlMatchRecognize matchRecognize) {
        RexNode after;
        List<SqlNode> operands;
        Object ns = this.getNamespace(matchRecognize);
        SqlValidatorScope scope = this.validator().getMatchRecognizeScope(matchRecognize);
        Blackboard matchBb = this.createBlackboard(scope, null, false);
        RelDataType rowType = ns.getRowType();
        SqlNode expr = matchRecognize.getTableRef();
        this.convertFrom(matchBb, expr);
        RelNode input = matchBb.root();
        SqlNodeList partitionList = matchRecognize.getPartitionList();
        ImmutableBitSet partitionKeys = this.buildPartitionKeys(matchBb, partitionList);
        SqlNodeList orderList = matchRecognize.getOrderList();
        ArrayList<RelFieldCollation> orderKeys = new ArrayList<RelFieldCollation>();
        for (SqlNode order : orderList) {
            RelFieldCollation.Direction direction;
            switch (order.getKind()) {
                case DESCENDING: {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    order = ((SqlCall)order).operand(0);
                    break;
                }
                case NULLS_FIRST: 
                case NULLS_LAST: {
                    throw new AssertionError();
                }
                default: {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
            }
            RelFieldCollation.NullDirection nullDirection = this.validator().config().defaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            RexNode e = matchBb.convertExpression(order);
            orderKeys.add(new RelFieldCollation(((RexInputRef)e).getIndex(), direction, nullDirection));
        }
        RelCollation orders = this.cluster.traitSet().canonize(RelCollations.of(orderKeys));
        final HashSet<String> patternVarsSet = new HashSet<String>();
        SqlNode pattern = matchRecognize.getPattern();
        SqlBasicVisitor<@Nullable RexNode> patternVarVisitor = new SqlBasicVisitor<RexNode>(){

            @Override
            public RexNode visit(SqlCall call) {
                List<SqlNode> operands = call.getOperandList();
                ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
                for (SqlNode node : operands) {
                    RexNode arg = Objects.requireNonNull(node.accept(this), node::toString);
                    newOperands.add(arg);
                }
                return SqlToRelConverter.this.rexBuilder.makeCall(SqlToRelConverter.this.validator().getUnknownType(), call.getOperator(), newOperands);
            }

            @Override
            public RexNode visit(SqlIdentifier id) {
                assert (id.isSimple());
                patternVarsSet.add(id.getSimple());
                return SqlToRelConverter.this.rexBuilder.makeLiteral(id.getSimple());
            }

            @Override
            public RexNode visit(SqlLiteral literal) {
                if (literal instanceof SqlNumericLiteral) {
                    return SqlToRelConverter.this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(literal.intValue(true)));
                }
                return SqlToRelConverter.this.rexBuilder.makeLiteral(literal.booleanValue());
            }
        };
        RexNode patternNode = pattern.accept(patternVarVisitor);
        assert (patternNode != null) : "pattern is not found in " + pattern;
        SqlLiteral interval = matchRecognize.getInterval();
        RexNode intervalNode = null;
        if (interval != null) {
            intervalNode = matchBb.convertLiteral(interval);
        }
        SqlNodeList subsets = matchRecognize.getSubsetList();
        HashMap<String, TreeSet<String>> subsetMap = new HashMap<String, TreeSet<String>>();
        for (SqlNode node : subsets) {
            operands = ((SqlCall)node).getOperandList();
            SqlIdentifier left = (SqlIdentifier)operands.get(0);
            patternVarsSet.add(left.getSimple());
            SqlNodeList rights = (SqlNodeList)operands.get(1);
            TreeSet<String> list = new TreeSet<String>(SqlIdentifier.simpleNames(rights));
            subsetMap.put(left.getSimple(), list);
        }
        SqlNode afterMatch = matchRecognize.getAfter();
        if (afterMatch == null) {
            afterMatch = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.symbol(SqlParserPos.ZERO);
        }
        if (afterMatch instanceof SqlCall) {
            operands = ((SqlCall)afterMatch).getOperandList();
            SqlOperator operator = ((SqlCall)afterMatch).getOperator();
            assert (operands.size() == 1);
            SqlIdentifier id = (SqlIdentifier)operands.get(0);
            assert (patternVarsSet.contains(id.getSimple())) : id.getSimple() + " not defined in pattern";
            RexLiteral rex = this.rexBuilder.makeLiteral(id.getSimple());
            after = this.rexBuilder.makeCall(this.validator().getUnknownType(), operator, (List<RexNode>)ImmutableList.of((Object)rex));
        } else {
            after = matchBb.convertExpression(afterMatch);
        }
        matchBb.setPatternVarRef(true);
        ImmutableMap.Builder measureNodes = ImmutableMap.builder();
        for (Object measure : matchRecognize.getMeasureList()) {
            List<SqlNode> operands2 = ((SqlCall)measure).getOperandList();
            String alias = ((SqlIdentifier)operands2.get(1)).getSimple();
            RexNode rex = matchBb.convertExpression(operands2.get(0));
            measureNodes.put((Object)alias, (Object)rex);
        }
        ImmutableMap.Builder definitionNodes = ImmutableMap.builder();
        for (SqlNode def : matchRecognize.getPatternDefList()) {
            this.replaceSubQueries(matchBb, def, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
            List<SqlNode> operands3 = ((SqlCall)def).getOperandList();
            String alias = ((SqlIdentifier)operands3.get(1)).getSimple();
            RexNode rex = matchBb.convertExpression(operands3.get(0));
            definitionNodes.put((Object)alias, (Object)rex);
        }
        SqlLiteral rowsPerMatch = matchRecognize.getRowsPerMatch();
        boolean allRows = rowsPerMatch != null && rowsPerMatch.getValue() == SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS;
        matchBb.setPatternVarRef(false);
        RelFactories.MatchFactory factory = RelFactories.DEFAULT_MATCH_FACTORY;
        RelNode rel = factory.createMatch(input, patternNode, rowType, matchRecognize.getStrictStart().booleanValue(), matchRecognize.getStrictEnd().booleanValue(), (Map<String, RexNode>)definitionNodes.build(), (Map<String, RexNode>)measureNodes.build(), after, subsetMap, allRows, partitionKeys, orders, intervalNode);
        bb.setRoot(rel, false);
    }

    protected void convertPivot(Blackboard bb, SqlPivot pivot) {
        SqlValidatorScope scope = this.validator().getJoinScope(pivot);
        Blackboard pivotBb = this.createBlackboard(scope, null, false);
        this.convertFrom(pivotBb, pivot.query);
        RelNode input = pivotBb.root();
        RelDataType inputRowType = input.getRowType();
        this.relBuilder.push(input);
        AggConverter aggConverter = new AggConverter(pivotBb, (AggregatingSelectScope)null);
        Set<String> usedColumnNames = pivot.usedColumnNames();
        inputRowType.getFieldList().stream().filter(field -> !usedColumnNames.contains(field.getName())).forEach(field -> aggConverter.addGroupExpr(new SqlIdentifier(field.getName(), SqlParserPos.ZERO)));
        pivot.axisList.forEach(aggConverter::addGroupExpr);
        pivotBb.agg = aggConverter;
        ArrayList<@Nullable E> aggAliasList = new ArrayList();
        assert (aggConverter.aggCalls.size() == 0);
        pivot.forEachAgg((alias, call) -> {
            call.accept(aggConverter);
            aggAliasList.add(alias);
            assert (aggConverter.aggCalls.size() == aggAliasList.size());
        });
        pivotBb.agg = null;
        this.relBuilder.project(Pair.left(aggConverter.getPreExprs()), Pair.right(aggConverter.getPreExprs()));
        RelBuilder.GroupKey groupKey = this.relBuilder.groupKey(inputRowType.getFieldList().stream().filter(field -> !usedColumnNames.contains(field.getName())).map(field -> aggConverter.addGroupExpr(new SqlIdentifier(field.getName(), SqlParserPos.ZERO))).collect(ImmutableBitSet.toImmutableBitSet()));
        ArrayList<RexInputRef> axes = new ArrayList<RexInputRef>();
        for (SqlNode axis : pivot.axisList) {
            axes.add(this.relBuilder.field(aggConverter.addGroupExpr(axis)));
        }
        ArrayList aggCalls = new ArrayList();
        Pair.forEach(aggAliasList, aggConverter.aggCalls, (alias, aggregateCall) -> aggCalls.add(this.relBuilder.aggregateCall((AggregateCall)aggregateCall).as((String)alias)));
        ImmutableList.Builder valueList = ImmutableList.builder();
        pivot.forEachNameValues((alias, nodeList) -> valueList.add(Pair.of(alias, nodeList.stream().map(bb::convertExpression).collect(Util.toImmutableList()))));
        RelNode rel = this.relBuilder.pivot(groupKey, aggCalls, axes, (Iterable<? extends Map.Entry<String, ? extends Iterable<? extends RexNode>>>)valueList.build()).build();
        bb.setRoot(rel, true);
    }

    protected void convertUnpivot(Blackboard bb, SqlUnpivot unpivot) {
        SqlValidatorScope scope = this.validator().getJoinScope(unpivot);
        Blackboard unpivotBb = this.createBlackboard(scope, null, false);
        this.convertFrom(unpivotBb, unpivot.query);
        RelNode input = unpivotBb.root();
        this.relBuilder.push(input);
        List measureNames = (List)unpivot.measureList.stream().map(node -> ((SqlIdentifier)node).getSimple()).collect(Util.toImmutableList());
        List axisNames = (List)unpivot.axisList.stream().map(node -> ((SqlIdentifier)node).getSimple()).collect(Util.toImmutableList());
        ImmutableList.Builder axisMap = ImmutableList.builder();
        unpivot.forEachNameValues((nodeList, valueList) -> {
            if (valueList == null) {
                valueList = new SqlNodeList(Collections.nCopies(axisNames.size(), SqlLiteral.createCharString(SqlUnpivot.aliasValue(nodeList), SqlParserPos.ZERO)), SqlParserPos.ZERO);
            }
            ArrayList literals = new ArrayList();
            Pair.forEach(valueList, unpivot.axisList, (value, axis) -> {
                RelDataType type = this.validator().getValidatedNodeType((SqlNode)axis);
                literals.add(this.convertLiteral((SqlLiteral)value, bb, type));
            });
            List nodes = (List)nodeList.stream().map(unpivotBb::convertExpression).collect(Util.toImmutableList());
            axisMap.add(Pair.of(literals, nodes));
        });
        this.relBuilder.unpivot(unpivot.includeNulls, measureNames, axisNames, (Iterable<? extends Map.Entry<? extends List<? extends RexLiteral>, ? extends List<? extends RexNode>>>)axisMap.build());
        this.relBuilder.convert(this.getNamespace(unpivot).getRowType(), false);
        bb.setRoot(this.relBuilder.build(), true);
    }

    private void convertIdentifier(Blackboard bb, SqlIdentifier id, @Nullable SqlNodeList extendedColumns, @Nullable SqlNodeList tableHints) {
        SqlValidatorNamespace fromNamespace = this.getNamespace(id).resolve();
        if (fromNamespace.getNode() != null) {
            this.convertFrom(bb, fromNamespace.getNode());
            return;
        }
        String datasetName = this.datasetStack.isEmpty() ? null : this.datasetStack.peek();
        boolean[] usedDataset = new boolean[]{false};
        RelOptTable table = SqlValidatorUtil.getRelOptTable(fromNamespace, this.catalogReader, datasetName, usedDataset);
        assert (table != null) : "getRelOptTable returned null for " + fromNamespace;
        if (extendedColumns != null && extendedColumns.size() > 0) {
            SqlValidatorTable validatorTable = table.unwrapOrThrow(SqlValidatorTable.class);
            List<RelDataTypeField> extendedFields = SqlValidatorUtil.getExtendedColumns(this.validator, validatorTable, extendedColumns);
            table = table.extend(extendedFields);
        }
        List<RelHint> hints = this.hintStrategies.apply(SqlUtil.getRelHint(this.hintStrategies, tableHints), LogicalTableScan.create(this.cluster, table, (List<RelHint>)ImmutableList.of()));
        RelNode tableRel = this.toRel(table, hints);
        bb.setRoot(tableRel, true);
        if (RelOptUtil.isPureOrder((RelNode)Nullness.castNonNull((Object)bb.root)) && this.removeSortInSubQuery(bb.top)) {
            bb.setRoot(((RelNode)Nullness.castNonNull((Object)bb.root)).getInput(0), true);
        }
        if (usedDataset[0]) {
            bb.setDataset(datasetName);
        }
    }

    protected void convertCollectionTable(Blackboard bb, SqlCall call) {
        Type elementType;
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.TABLESAMPLE) {
            String sampleName = SqlLiteral.unchain(call.operand(0)).getValueAs(String.class);
            this.datasetStack.push(sampleName);
            SqlCall cursorCall = (SqlCall)call.operand(1);
            Object query = cursorCall.operand(0);
            RelNode converted = this.convertQuery(query, (boolean)false, (boolean)false).rel;
            bb.setRoot(converted, false);
            this.datasetStack.pop();
            return;
        }
        this.replaceSubQueries(bb, call, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        SqlCallBinding callBinding = new SqlCallBinding(bb.scope().getValidator(), bb.scope, call);
        if (operator instanceof SqlUserDefinedTableMacro) {
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            TranslatableTable table = udf.getTable(callBinding);
            RelDataType rowType = table.getRowType(this.typeFactory);
            CalciteSchema schema = Schemas.subSchema(this.catalogReader.getRootSchema(), udf.getNameAsId().skipLast((int)1).names);
            TableExpressionFactory expressionFunction = clazz -> Schemas.getTableExpression(Objects.requireNonNull(schema, "schema").plus(), Util.last(udf.getNameAsId().names), table, clazz);
            RelOptTableImpl relOptTable = RelOptTableImpl.create(null, rowType, udf.getNameAsId().names, (Table)table, expressionFunction);
            RelNode converted = this.toRel(relOptTable, (List<RelHint>)ImmutableList.of());
            bb.setRoot(converted, true);
            return;
        }
        if (operator instanceof SqlUserDefinedTableFunction) {
            SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)operator;
            elementType = udtf.getElementType(callBinding);
        } else {
            elementType = null;
        }
        RexNode rexCall = bb.convertExpression(call);
        ImmutableList<RelNode> inputs = bb.retrieveCursors();
        Set<RelColumnMapping> columnMappings = SqlToRelConverter.getColumnMappings(operator);
        LogicalTableFunctionScan callRel = LogicalTableFunctionScan.create(this.cluster, inputs, rexCall, elementType, this.validator().getValidatedNodeType(call), columnMappings);
        bb.setRoot(callRel, true);
        this.afterTableFunction(bb, call, callRel);
    }

    protected void afterTableFunction(Blackboard bb, SqlCall call, LogicalTableFunctionScan callRel) {
    }

    private void convertTemporalTable(Blackboard bb, SqlCall call) {
        SqlSnapshot snapshot = (SqlSnapshot)call;
        RexNode period = bb.convertExpression(snapshot.getPeriod());
        SqlNode expr = snapshot.getTableRef();
        this.convertFrom(bb, expr);
        RelNode snapshotRel = this.relBuilder.push(bb.root()).snapshot(period).build();
        bb.setRoot(snapshotRel, false);
    }

    private static @Nullable Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference rti = op.getReturnTypeInference();
        if (rti == null) {
            return null;
        }
        if (rti instanceof TableFunctionReturnTypeInference) {
            TableFunctionReturnTypeInference tfrti = (TableFunctionReturnTypeInference)rti;
            return tfrti.getColumnMappings();
        }
        return null;
    }

    protected RelNode createJoin(Blackboard bb, RelNode leftRel, RelNode rightRel, RexNode joinCond, JoinRelType joinType) {
        assert (joinCond != null);
        CorrelationUse p = this.getCorrelationUse(bb, rightRel);
        if (p != null) {
            RelNode innerRel = p.r;
            ImmutableBitSet requiredCols = p.requiredColumns;
            if (!joinCond.isAlwaysTrue()) {
                RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
                RexCorrelVariable rexCorrel = (RexCorrelVariable)this.rexBuilder.makeCorrel(leftRel.getRowType(), p.id);
                RexAccessShuttle shuttle = new RexAccessShuttle(this.rexBuilder, rexCorrel);
                RexNode newCond = joinCond.accept(shuttle);
                innerRel = factory.createFilter(p.r, newCond, (Set<CorrelationId>)ImmutableSet.of());
                requiredCols = ImmutableBitSet.fromBitSet(shuttle.varCols).union(p.requiredColumns);
            }
            return LogicalCorrelate.create(leftRel, innerRel, (List<RelHint>)ImmutableList.of(), p.id, requiredCols, joinType);
        }
        RelNode node = this.relBuilder.push(leftRel).push(rightRel).join(joinType, joinCond).build();
        if (node instanceof Project) {
            Join newJoin = (Join)node.getInputs().get(0);
            if (this.leaves.containsKey(leftRel)) {
                this.leaves.put(newJoin.getLeft(), this.leaves.get(leftRel));
            }
            if (this.leaves.containsKey(rightRel)) {
                this.leaves.put(newJoin.getRight(), this.leaves.get(rightRel));
            }
        }
        return node;
    }

    private @Nullable CorrelationUse getCorrelationUse(Blackboard bb, RelNode r0) {
        Set<CorrelationId> correlatedVariables = RelOptUtil.getVariablesUsed(r0);
        if (correlatedVariables.isEmpty()) {
            return null;
        }
        ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        ArrayList<CorrelationId> correlNames = new ArrayList<CorrelationId>();
        SqlValidatorNamespace prevNs = null;
        for (CorrelationId correlName : correlatedVariables) {
            DeferredLookup lookup = Objects.requireNonNull(this.mapCorrelToDeferred.get(correlName), () -> "correlation variable is not found: " + correlName);
            RexFieldAccess fieldAccess = lookup.getFieldAccess(correlName);
            String originalRelName = lookup.getOriginalRelName();
            String originalFieldName = fieldAccess.getField().getName();
            SqlNameMatcher nameMatcher = bb.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            lookup.bb.scope().resolve((List<String>)ImmutableList.of((Object)originalRelName), nameMatcher, false, resolved);
            assert (resolved.count() == 1);
            SqlValidatorScope.Resolve resolve = resolved.only();
            SqlValidatorNamespace foundNs = resolve.namespace;
            RelDataType rowType = resolve.rowType();
            int childNamespaceIndex = resolve.path.steps().get((int)0).i;
            SqlValidatorScope ancestorScope = resolve.scope;
            boolean correlInCurrentScope = bb.scope().isWithin(ancestorScope);
            if (!correlInCurrentScope) continue;
            if (prevNs == null) {
                prevNs = foundNs;
            } else assert (prevNs == foundNs) : "All correlation variables should resolve to the same namespace. Prev ns=" + prevNs + ", new ns=" + foundNs;
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                assert (ancestorScope instanceof ListScope);
                List<SqlValidatorNamespace> children = ((ListScope)ancestorScope).getChildren();
                for (int i = 0; i < childNamespaceIndex; ++i) {
                    SqlValidatorNamespace child = children.get(i);
                    namespaceOffset += child.getRowType().getFieldCount();
                }
            }
            RexFieldAccess topLevelFieldAccess = fieldAccess;
            while (topLevelFieldAccess.getReferenceExpr() instanceof RexFieldAccess) {
                topLevelFieldAccess = (RexFieldAccess)topLevelFieldAccess.getReferenceExpr();
            }
            RelDataTypeField field = rowType.getFieldList().get(topLevelFieldAccess.getField().getIndex() - namespaceOffset);
            int pos = namespaceOffset + field.getIndex();
            assert (field.getType() == topLevelFieldAccess.getField().getType());
            assert (pos != -1);
            Map exprProjection = (Map)bb.mapRootRelToFieldProjection.get(bb.root);
            if (exprProjection != null) {
                Integer projection = (Integer)exprProjection.get(pos);
                if (projection != null) {
                    pos = projection;
                } else {
                    throw new AssertionError((Object)("Identifier '" + originalRelName + "." + originalFieldName + "' is not a group expr"));
                }
            }
            requiredColumns.set(pos);
            correlNames.add(correlName);
        }
        if (correlNames.isEmpty()) {
            return null;
        }
        RelNode r = r0;
        if (correlNames.size() > 1) {
            r = DeduplicateCorrelateVariables.go(this.rexBuilder, (CorrelationId)correlNames.get(0), Util.skip(correlNames), r0);
            this.leaves.put(r, r.getRowType().getFieldCount());
        }
        return new CorrelationUse((CorrelationId)correlNames.get(0), requiredColumns.build(), r);
    }

    private boolean isSubQueryNonCorrelated(RelNode subq, Blackboard bb) {
        Set<CorrelationId> correlatedVariables = RelOptUtil.getVariablesUsed(subq);
        for (CorrelationId correlName : correlatedVariables) {
            DeferredLookup lookup = Objects.requireNonNull(this.mapCorrelToDeferred.get(correlName), () -> "correlation variable is not found: " + correlName);
            String originalRelName = lookup.getOriginalRelName();
            SqlNameMatcher nameMatcher = lookup.bb.scope().getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            lookup.bb.scope().resolve((List<String>)ImmutableList.of((Object)originalRelName), nameMatcher, false, resolved);
            SqlValidatorScope ancestorScope = resolved.only().scope;
            SqlValidatorScope parentScope = bb.scope;
            do {
                if (ancestorScope != parentScope) continue;
                return false;
            } while (parentScope instanceof DelegatingScope && (parentScope = ((DelegatingScope)parentScope).getParent()) != null);
        }
        return true;
    }

    protected List<RelDataTypeField> getSystemFields() {
        return Collections.emptyList();
    }

    private void convertJoin(Blackboard bb, SqlJoin join) {
        RelNode rightRel;
        RexNode condition;
        SqlValidator validator = this.validator();
        SqlValidatorScope scope = validator.getJoinScope(join);
        Blackboard fromBlackboard = this.createBlackboard(scope, null, false);
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlValidatorScope leftScope = Util.first(validator.getJoinScope(left), ((DelegatingScope)bb.scope()).getParent());
        Blackboard leftBlackboard = this.createBlackboard(leftScope, null, false);
        SqlValidatorScope rightScope = Util.first(validator.getJoinScope(right), ((DelegatingScope)bb.scope()).getParent());
        Blackboard rightBlackboard = this.createBlackboard(rightScope, null, false);
        this.convertFrom(leftBlackboard, left);
        RelNode leftRel = Objects.requireNonNull(leftBlackboard.root, "leftBlackboard.root");
        this.convertFrom(rightBlackboard, right);
        RelNode tempRightRel = Objects.requireNonNull(rightBlackboard.root, "rightBlackboard.root");
        JoinConditionType conditionType = join.getConditionType();
        if (join.isNatural()) {
            condition = this.convertNaturalCondition((SqlValidatorNamespace)this.getNamespace(left), (SqlValidatorNamespace)this.getNamespace(right));
            rightRel = tempRightRel;
        } else {
            switch (conditionType) {
                case NONE: {
                    condition = this.rexBuilder.makeLiteral(true);
                    rightRel = tempRightRel;
                    break;
                }
                case USING: {
                    condition = this.convertUsingCondition(join, (SqlValidatorNamespace)this.getNamespace(left), (SqlValidatorNamespace)this.getNamespace(right));
                    rightRel = tempRightRel;
                    break;
                }
                case ON: {
                    Pair<RexNode, RelNode> conditionAndRightNode = this.convertOnCondition(fromBlackboard, join, leftRel, tempRightRel);
                    condition = (RexNode)conditionAndRightNode.left;
                    rightRel = (RelNode)conditionAndRightNode.right;
                    break;
                }
                default: {
                    throw Util.unexpected(conditionType);
                }
            }
        }
        RelNode joinRel = this.createJoin(fromBlackboard, leftRel, rightRel, condition, SqlToRelConverter.convertJoinType(join.getJoinType()));
        this.relBuilder.push(joinRel);
        RelNode newProjectRel = this.relBuilder.project((Iterable<? extends RexNode>)this.relBuilder.fields()).build();
        bb.setRoot(newProjectRel, false);
    }

    private RexNode convertNaturalCondition(SqlValidatorNamespace leftNamespace, SqlValidatorNamespace rightNamespace) {
        List<String> columnList = SqlValidatorUtil.deriveNaturalJoinColumnList(this.catalogReader.nameMatcher(), leftNamespace.getRowType(), rightNamespace.getRowType());
        return this.convertUsing(leftNamespace, rightNamespace, columnList);
    }

    private RexNode convertUsingCondition(SqlJoin join, SqlValidatorNamespace leftNamespace, SqlValidatorNamespace rightNamespace) {
        SqlNodeList list = (SqlNodeList)Objects.requireNonNull(join.getCondition(), () -> "getCondition for join " + join);
        return this.convertUsing(leftNamespace, rightNamespace, (List<String>)ImmutableList.copyOf(SqlIdentifier.simpleNames(list)));
    }

    private Pair<RexNode, RelNode> convertOnCondition(Blackboard bb, SqlJoin join, RelNode leftRel, RelNode rightRel) {
        SqlNode condition = Objects.requireNonNull(join.getCondition(), () -> "getCondition for join " + join);
        bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)rightRel));
        this.replaceSubQueries(bb, condition, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
        RelNode newRightRel = bb.root == null || bb.registered.size() == 0 ? rightRel : bb.reRegister(rightRel);
        bb.setRoot((List<RelNode>)ImmutableList.of((Object)leftRel, (Object)newRightRel));
        RexNode conditionExp = bb.convertExpression(condition);
        if (conditionExp instanceof RexInputRef && newRightRel != rightRel) {
            int leftFieldCount = leftRel.getRowType().getFieldCount();
            List<RelDataTypeField> rightFieldList = newRightRel.getRowType().getFieldList();
            int rightFieldCount = newRightRel.getRowType().getFieldCount();
            conditionExp = this.rexBuilder.makeInputRef(rightFieldList.get(rightFieldCount - 1).getType(), leftFieldCount + rightFieldCount - 1);
        }
        return Pair.of(conditionExp, newRightRel);
    }

    private RexNode convertUsing(SqlValidatorNamespace leftNamespace, SqlValidatorNamespace rightNamespace, List<String> nameList) {
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (String name : nameList) {
            ArrayList<RexInputRef> operands = new ArrayList<RexInputRef>();
            int offset = 0;
            for (SqlValidatorNamespace n : ImmutableList.of((Object)leftNamespace, (Object)rightNamespace)) {
                RelDataType rowType = n.getRowType();
                RelDataTypeField field = nameMatcher.field(rowType, name);
                assert (field != null) : "field " + name + " is not found in " + rowType + " with " + nameMatcher;
                operands.add(this.rexBuilder.makeInputRef(field.getType(), offset + field.getIndex()));
                offset += rowType.getFieldList().size();
            }
            list.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, operands));
        }
        return RexUtil.composeConjunction(this.rexBuilder, list);
    }

    private static JoinRelType convertJoinType(JoinType joinType) {
        switch (joinType) {
            case COMMA: 
            case INNER: 
            case CROSS: {
                return JoinRelType.INNER;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
        }
        throw Util.unexpected(joinType);
    }

    protected void convertAgg(Blackboard bb, SqlSelect select, List<SqlNode> orderExprList) {
        assert (bb.root != null) : "precondition: child != null";
        SqlNodeList groupList = select.getGroup();
        SqlNodeList selectList = select.getSelectList();
        SqlNode having = select.getHaving();
        AggConverter aggConverter = new AggConverter(bb, select);
        this.createAggImpl(bb, aggConverter, selectList, groupList, having, orderExprList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createAggImpl(Blackboard bb, AggConverter aggConverter, SqlNodeList selectList, @Nullable SqlNodeList groupList, @Nullable SqlNode having, List<SqlNode> orderExprList) {
        RexNode havingExpr;
        AggregateFinder aggregateFinder = new AggregateFinder();
        selectList.accept(aggregateFinder);
        if (having != null) {
            having.accept(aggregateFinder);
        }
        this.replaceSubQueries(bb, aggregateFinder.list, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        this.replaceSubQueries(bb, aggregateFinder.filterList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        this.replaceSubQueries(bb, aggregateFinder.orderList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        if (groupList == null) {
            groupList = SqlNodeList.EMPTY;
        }
        this.replaceSubQueries(bb, groupList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        AggregatingSelectScope scope = Objects.requireNonNull(aggConverter.aggregatingSelectScope, "aggregatingSelectScope");
        AggregatingSelectScope.Resolved r = scope.resolved.get();
        for (SqlNode groupExpr : r.groupExprList) {
            aggConverter.addGroupExpr(groupExpr);
        }
        ArrayList<Pair<RexNode, Object>> projects = new ArrayList<Pair<RexNode, Object>>();
        try {
            ImmutableList preExprs;
            Preconditions.checkArgument((bb.agg == null ? 1 : 0) != 0, (Object)"already in agg mode");
            bb.agg = aggConverter;
            selectList.accept(aggConverter);
            assert (!aggConverter.inOver);
            for (SqlNode expr : orderExprList) {
                expr.accept(aggConverter);
                assert (!aggConverter.inOver);
            }
            if (having != null) {
                having.accept(aggConverter);
                assert (!aggConverter.inOver);
            }
            if ((preExprs = aggConverter.getPreExprs()).size() == 0) {
                RexLiteral zero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO);
                preExprs = ImmutableList.of(Pair.of(zero, null));
            }
            RelNode inputRel = bb.root();
            bb.setRoot(this.relBuilder.push(inputRel).projectNamed(Pair.left(preExprs), Pair.right(preExprs), false).build(), false);
            bb.mapRootRelToFieldProjection.put(bb.root(), r.groupExprProjection);
            bb.columnMonotonicities.clear();
            for (SqlNode groupItem : groupList) {
                bb.columnMonotonicities.add(bb.scope().getMonotonicity(groupItem));
            }
            bb.setRoot(this.createAggregate(bb, r.groupSet, (ImmutableList<ImmutableBitSet>)r.groupSets.asList(), aggConverter.getAggCalls()), false);
            bb.mapRootRelToFieldProjection.put(bb.root(), r.groupExprProjection);
            if (having != null) {
                SqlNode newHaving = SqlToRelConverter.pushDownNotForIn(bb.scope(), having);
                this.replaceSubQueries(bb, newHaving, RelOptUtil.Logic.UNKNOWN_AS_FALSE);
                havingExpr = bb.convertExpression(newHaving);
            } else {
                havingExpr = this.relBuilder.literal(true);
            }
            this.replaceSubQueries(bb, selectList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
            int k = 0;
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(bb.scope);
            assert (selectScope != null);
            Object selectNamespace = this.getNamespaceOrNull(selectScope.getNode());
            assert (selectNamespace != null) : "selectNamespace must not be null for " + selectScope;
            List<String> names = selectNamespace.getRowType().getFieldNames();
            int sysFieldCount = selectList.size() - names.size();
            for (SqlNode expr : selectList) {
                projects.add(Pair.of(bb.convertExpression(expr), k < sysFieldCount ? (String)Nullness.castNonNull((Object)this.validator().deriveAlias(expr, k++)) : names.get(k++ - sysFieldCount)));
            }
            for (SqlNode expr : orderExprList) {
                projects.add(Pair.of(bb.convertExpression(expr), Nullness.castNonNull((Object)this.validator().deriveAlias(expr, k++))));
            }
        }
        finally {
            bb.agg = null;
        }
        this.relBuilder.push(bb.root());
        if (havingExpr != null) {
            this.relBuilder.filter(havingExpr);
        }
        this.relBuilder.project(Pair.left(projects), Pair.right(projects)).rename(Pair.right(projects));
        bb.setRoot(this.relBuilder.build(), false);
        bb.columnMonotonicities.clear();
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(bb.scope().getMonotonicity(selectItem));
        }
    }

    protected RelNode createAggregate(Blackboard bb, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        this.relBuilder.push(bb.root());
        RelBuilder.GroupKey groupKey = this.relBuilder.groupKey(groupSet, (Iterable<? extends ImmutableBitSet>)groupSets);
        return this.relBuilder.aggregate(groupKey, aggCalls).build();
    }

    public RexDynamicParam convertDynamicParam(SqlDynamicParam dynamicParam) {
        while (dynamicParam.getIndex() >= this.dynamicParamSqlNodes.size()) {
            this.dynamicParamSqlNodes.add(null);
        }
        this.dynamicParamSqlNodes.set(dynamicParam.getIndex(), dynamicParam);
        return this.rexBuilder.makeDynamicParam(this.getDynamicParamType(dynamicParam.getIndex()), dynamicParam.getIndex());
    }

    protected void gatherOrderExprs(Blackboard bb, SqlSelect select, @Nullable SqlNodeList orderList, List<SqlNode> extraOrderExprs, List<RelFieldCollation> collationList) {
        SqlNode offset;
        assert (bb.root != null) : "precondition: child != null";
        assert (select != null);
        if (orderList == null) {
            return;
        }
        if (this.removeSortInSubQuery(bb.top) && ((offset = select.getOffset()) == null || offset instanceof SqlLiteral && Objects.equals(((SqlLiteral)offset).bigDecimalValue(), BigDecimal.ZERO)) && select.getFetch() == null) {
            return;
        }
        for (SqlNode orderItem : orderList) {
            collationList.add(this.convertOrderItem(select, orderItem, extraOrderExprs, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED));
        }
    }

    protected RelFieldCollation convertOrderItem(SqlSelect select, SqlNode orderItem, List<SqlNode> extraExprs, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        assert (select != null);
        switch (orderItem.getKind()) {
            case DESCENDING: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, RelFieldCollation.Direction.DESCENDING, nullDirection);
            }
            case NULLS_FIRST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.FIRST);
            }
            case NULLS_LAST: {
                return this.convertOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0), extraExprs, direction, RelFieldCollation.NullDirection.LAST);
            }
        }
        SqlNode converted = this.validator().expandOrderExpr(select, orderItem);
        switch (nullDirection) {
            case UNSPECIFIED: {
                nullDirection = this.validator().config().defaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
                break;
            }
        }
        SelectScope selectScope = Objects.requireNonNull(this.validator().getRawSelectScope(select), () -> "getRawSelectScope is not found for " + select);
        int ordinal = -1;
        List<SqlNode> expandedSelectList = selectScope.getExpandedSelectList();
        for (SqlNode selectItem : Objects.requireNonNull(expandedSelectList, "expandedSelectList")) {
            ++ordinal;
            if (!converted.equalsDeep(SqlUtil.stripAs(selectItem), Litmus.IGNORE)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        for (SqlNode extraExpr : extraExprs) {
            ++ordinal;
            if (!converted.equalsDeep(extraExpr, Litmus.IGNORE)) continue;
            return new RelFieldCollation(ordinal, direction, nullDirection);
        }
        extraExprs.add(converted);
        return new RelFieldCollation(ordinal + 1, direction, nullDirection);
    }

    private static boolean desc(RelFieldCollation.Direction direction) {
        switch (direction) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    protected boolean enableDecorrelation() {
        return this.config.isDecorrelationEnabled();
    }

    protected RelNode decorrelateQuery(RelNode rootRel) {
        return RelDecorrelator.decorrelateQuery(rootRel, this.relBuilder);
    }

    @Deprecated
    public boolean isTrimUnusedFields() {
        return this.config.isTrimUnusedFields();
    }

    protected RelRoot convertQueryRecursive(SqlNode query, boolean top, @Nullable RelDataType targetRowType) {
        SqlKind kind = query.getKind();
        switch (kind) {
            case SELECT: {
                return RelRoot.of(this.convertSelect((SqlSelect)query, top), kind);
            }
            case INSERT: {
                return RelRoot.of(this.convertInsert((SqlInsert)query), kind);
            }
            case DELETE: {
                return RelRoot.of(this.convertDelete((SqlDelete)query), kind);
            }
            case UPDATE: {
                return RelRoot.of(this.convertUpdate((SqlUpdate)query), kind);
            }
            case MERGE: {
                return RelRoot.of(this.convertMerge((SqlMerge)query), kind);
            }
            case INTERSECT: 
            case EXCEPT: 
            case UNION: {
                return RelRoot.of(this.convertSetOp((SqlCall)query), kind);
            }
            case WITH: {
                return this.convertWith((SqlWith)query, top);
            }
            case VALUES: {
                return RelRoot.of(this.convertValues((SqlCall)query, targetRowType), kind);
            }
        }
        throw new AssertionError((Object)("not a query: " + query));
    }

    protected RelNode convertSetOp(SqlCall call) {
        RelNode left = this.convertQueryRecursive((SqlNode)call.operand(0), false, null).project();
        RelNode right = this.convertQueryRecursive((SqlNode)call.operand(1), false, null).project();
        switch (call.getKind()) {
            case UNION: {
                return LogicalUnion.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), SqlToRelConverter.all(call));
            }
            case INTERSECT: {
                return LogicalIntersect.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), SqlToRelConverter.all(call));
            }
            case EXCEPT: {
                return LogicalMinus.create((List<RelNode>)ImmutableList.of((Object)left, (Object)right), SqlToRelConverter.all(call));
            }
        }
        throw Util.unexpected(call.getKind());
    }

    private static boolean all(SqlCall call) {
        return ((SqlSetOperator)call.getOperator()).isAll();
    }

    protected RelNode convertInsert(SqlInsert call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = this.validator().getValidatedNodeType(call);
        assert (targetRowType != null);
        RelNode sourceRel = this.convertQueryRecursive(call.getSource(), true, targetRowType).project();
        RelNode massagedRel = this.convertColumnList(call, sourceRel);
        return this.createModify(targetTable, massagedRel);
    }

    private RelNode createModify(RelOptTable targetTable, RelNode source) {
        ModifiableTable modifiableTable = targetTable.unwrap(ModifiableTable.class);
        if (modifiableTable != null && modifiableTable == targetTable.unwrap(Table.class)) {
            return modifiableTable.toModificationRel(this.cluster, targetTable, this.catalogReader, source, TableModify.Operation.INSERT, null, null, false);
        }
        ModifiableView modifiableView = targetTable.unwrap(ModifiableView.class);
        if (modifiableView != null) {
            Table delegateTable = modifiableView.getTable();
            RelDataType delegateRowType = delegateTable.getRowType(this.typeFactory);
            RelOptTableImpl delegateRelOptTable = RelOptTableImpl.create(null, delegateRowType, delegateTable, modifiableView.getTablePath());
            RelNode newSource = this.createSource(targetTable, source, modifiableView, delegateRowType);
            return this.createModify(delegateRelOptTable, newSource);
        }
        return LogicalTableModify.create(targetTable, this.catalogReader, source, TableModify.Operation.INSERT, null, null, false);
    }

    private RelNode createSource(RelOptTable targetTable, RelNode source, ModifiableView modifiableView, RelDataType delegateRowType) {
        ImmutableIntList mapping = modifiableView.getColumnMapping();
        assert (mapping.size() == targetTable.getRowType().getFieldCount());
        HashMap<Integer, RexNode> projectMap = new HashMap<Integer, RexNode>();
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        for (int i = 0; i < mapping.size(); ++i) {
            int target = mapping.get(i);
            if (target < 0) continue;
            projectMap.put(target, RexInputRef.of(i, source.getRowType()));
        }
        RexNode constraint = modifiableView.getConstraint(this.rexBuilder, delegateRowType);
        RelOptUtil.inferViewPredicates(projectMap, filters, constraint);
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        for (RelDataTypeField field : delegateRowType.getFieldList()) {
            RexNode node = (RexNode)projectMap.get(field.getIndex());
            if (node == null) {
                node = this.rexBuilder.makeNullLiteral(field.getType());
            }
            projects.add(Pair.of(this.rexBuilder.ensureType(field.getType(), node, false), field.getName()));
        }
        return this.relBuilder.push(source).projectNamed(Pair.left(projects), Pair.right(projects), false).filter(filters).build();
    }

    private RelOptTable.ToRelContext createToRelContext(List<RelHint> hints) {
        return ViewExpanders.toRelContext(this.viewExpander, this.cluster, hints);
    }

    public RelNode toRel(RelOptTable table, List<RelHint> hints) {
        RelNode scan = table.toRel(this.createToRelContext(hints));
        InitializerExpressionFactory ief = table.maybeUnwrap(InitializerExpressionFactory.class).orElse(NullInitializerExpressionFactory.INSTANCE);
        boolean hasVirtualFields = table.getRowType().getFieldList().stream().anyMatch(f -> ief.generationStrategy(table, f.getIndex()) == ColumnStrategy.VIRTUAL);
        if (hasVirtualFields) {
            RexNode sourceRef = this.rexBuilder.makeRangeReference(scan);
            Blackboard bb = this.createInsertBlackboard(table, sourceRef, table.getRowType().getFieldNames());
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            block3: for (RelDataTypeField f2 : table.getRowType().getFieldList()) {
                ColumnStrategy strategy = ief.generationStrategy(table, f2.getIndex());
                switch (strategy) {
                    case VIRTUAL: {
                        list.add(ief.newColumnDefaultValue(table, f2.getIndex(), bb));
                        continue block3;
                    }
                }
                list.add(this.rexBuilder.makeInputRef(scan, RelOptTableImpl.realOrdinal(table, f2.getIndex())));
            }
            this.relBuilder.push(scan);
            this.relBuilder.project(list);
            RelNode project = this.relBuilder.build();
            BiFunction<InitializerContext, RelNode, RelNode> postConversionHook = ief.postExpressionConversionHook();
            if (postConversionHook != null) {
                return postConversionHook.apply(bb, project);
            }
            return project;
        }
        return scan;
    }

    protected RelOptTable getTargetTable(SqlNode call) {
        SqlValidatorImpl.DmlNamespace targetNs = this.getNamespace(call);
        SqlValidatorNamespace namespace = targetNs.isWrapperFor(SqlValidatorImpl.DmlNamespace.class) ? (SqlValidatorNamespace)targetNs.unwrap(SqlValidatorImpl.DmlNamespace.class) : targetNs.resolve();
        RelOptTable table = SqlValidatorUtil.getRelOptTable(namespace, this.catalogReader, null, null);
        return Objects.requireNonNull(table, "no table found for " + call);
    }

    protected RelNode convertColumnList(SqlInsert call, RelNode source) {
        RelDataTypeField field;
        RelDataType sourceRowType = source.getRowType();
        RexRangeRef sourceRef = this.rexBuilder.makeRangeReference(sourceRowType, 0, false);
        ArrayList<String> targetColumnNames = new ArrayList<String>();
        ArrayList<RexNode> columnExprs = new ArrayList<RexNode>();
        this.collectInsertTargets(call, sourceRef, targetColumnNames, columnExprs);
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType targetRowType = RelOptTableImpl.realRowType(targetTable);
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        ArrayList<@Nullable Object> sourceExps = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        ArrayList<@Nullable Object> fieldNames = new ArrayList<Object>(Collections.nCopies(targetFields.size(), null));
        InitializerExpressionFactory initializerFactory = SqlToRelConverter.getInitializerFactory(this.getNamespace(call).getTable());
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        for (Pair<String, RexNode> p : Pair.zip(targetColumnNames, columnExprs)) {
            field = nameMatcher.field(targetRowType, (String)p.left);
            assert (field != null) : "column " + (String)p.left + " not found";
            sourceExps.set(field.getIndex(), p.right);
        }
        Supplier<Blackboard> bb = () -> this.createInsertBlackboard(targetTable, sourceRef, targetColumnNames);
        for (int i = 0; i < targetFields.size(); ++i) {
            field = targetFields.get(i);
            String fieldName = field.getName();
            fieldNames.set(i, fieldName);
            RexNode sourceExpression = (RexNode)sourceExps.get(i);
            if (sourceExpression != null && sourceExpression.getKind() != SqlKind.DEFAULT) continue;
            sourceExpression = initializerFactory.newColumnDefaultValue(targetTable, i, bb.get());
            sourceExpression = this.castNullLiteralIfNeeded(sourceExpression, field.getType());
            sourceExps.set(i, sourceExpression);
        }
        ArrayList<Object> nonNullExprs = sourceExps;
        return this.relBuilder.push(source).projectNamed(nonNullExprs, fieldNames, false).build();
    }

    private Blackboard createInsertBlackboard(RelOptTable targetTable, RexNode sourceRef, List<String> targetColumnNames) {
        HashMap<String, RexNode> nameToNodeMap = new HashMap<String, RexNode>();
        int j = 0;
        List<ColumnStrategy> strategies = targetTable.getColumnStrategies();
        List<String> targetFields = targetTable.getRowType().getFieldNames();
        block3: for (String targetColumnName : targetColumnNames) {
            int i = targetFields.indexOf(targetColumnName);
            switch (strategies.get(i)) {
                case VIRTUAL: 
                case STORED: {
                    continue block3;
                }
            }
            nameToNodeMap.put(targetColumnName, this.rexBuilder.makeFieldAccess(sourceRef, j++));
        }
        return this.createBlackboard(null, nameToNodeMap, false);
    }

    private static InitializerExpressionFactory getInitializerFactory(@Nullable SqlValidatorTable validatorTable) {
        InitializerExpressionFactory f;
        Table table = SqlToRelConverter.unwrap(validatorTable, Table.class);
        if (table != null && (f = SqlToRelConverter.unwrap(table, InitializerExpressionFactory.class)) != null) {
            return f;
        }
        return NullInitializerExpressionFactory.INSTANCE;
    }

    private static <T> @Nullable T unwrap(@Nullable Object o, Class<T> clazz) {
        if (o instanceof Wrapper) {
            return ((Wrapper)o).unwrap(clazz);
        }
        return null;
    }

    private RexNode castNullLiteralIfNeeded(RexNode node, RelDataType type) {
        if (!RexLiteral.isNullLiteral(node)) {
            return node;
        }
        return this.rexBuilder.makeCast(type, node);
    }

    protected void collectInsertTargets(SqlInsert call, RexNode sourceRef, List<String> targetColumnNames, List<RexNode> columnExprs) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelDataType tableRowType = targetTable.getRowType();
        SqlNodeList targetColumnList = call.getTargetColumnList();
        if (targetColumnList == null) {
            if (this.validator().config().conformance().isInsertSubsetColumnsAllowed()) {
                RelDataType targetRowType = this.typeFactory.createStructType(tableRowType.getFieldList().subList(0, sourceRef.getType().getFieldCount()));
                targetColumnNames.addAll(targetRowType.getFieldNames());
            } else {
                targetColumnNames.addAll(tableRowType.getFieldNames());
            }
        } else {
            for (int i = 0; i < targetColumnList.size(); ++i) {
                SqlIdentifier id = (SqlIdentifier)targetColumnList.get(i);
                RelDataTypeField field = SqlValidatorUtil.getTargetField(tableRowType, this.typeFactory, id, this.catalogReader, targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNames.add(field.getName());
            }
        }
        Blackboard bb = this.createInsertBlackboard(targetTable, sourceRef, targetColumnNames);
        List<ColumnStrategy> strategies = targetTable.getColumnStrategies();
        for (String columnName : targetColumnNames) {
            RexNode expr;
            int i = tableRowType.getFieldNames().indexOf(columnName);
            switch (strategies.get(i)) {
                case STORED: {
                    InitializerExpressionFactory f = targetTable.maybeUnwrap(InitializerExpressionFactory.class).orElse(NullInitializerExpressionFactory.INSTANCE);
                    expr = f.newColumnDefaultValue(targetTable, i, bb);
                    break;
                }
                case VIRTUAL: {
                    expr = null;
                    break;
                }
                default: {
                    expr = (RexNode)Objects.requireNonNull(bb.nameToNodeMap, "nameToNodeMap").get(columnName);
                }
            }
            columnExprs.add((RexNode)Nullness.castNonNull(expr));
        }
        for (int i = 0; i < targetColumnNames.size(); ++i) {
            if (columnExprs.get(i) != null) continue;
            columnExprs.remove(i);
            targetColumnNames.remove(i);
            --i;
        }
    }

    private RelNode convertDelete(SqlDelete call) {
        RelOptTable targetTable = this.getTargetTable(call);
        RelNode sourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        return LogicalTableModify.create(targetTable, this.catalogReader, sourceRel, TableModify.Operation.DELETE, null, null, false);
    }

    private RelNode convertUpdate(SqlUpdate call) {
        SqlValidatorScope scope = this.validator().getWhereScope(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call));
        Blackboard bb = this.createBlackboard(scope, null, false);
        this.replaceSubQueries(bb, call, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField field = SqlValidatorUtil.getTargetField(targetRowType, this.typeFactory, id, this.catalogReader, targetTable);
            assert (field != null) : "column " + id.toString() + " not found";
            targetColumnNameList.add(field.getName());
        }
        RelNode sourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        bb.setRoot(sourceRel, false);
        ImmutableList.Builder rexNodeSourceExpressionListBuilder = ImmutableList.builder();
        for (SqlNode n : call.getSourceExpressionList()) {
            RexNode rn = bb.convertExpression(n);
            rexNodeSourceExpressionListBuilder.add((Object)rn);
        }
        return LogicalTableModify.create(targetTable, this.catalogReader, sourceRel, TableModify.Operation.UPDATE, targetColumnNameList, (List<RexNode>)rexNodeSourceExpressionListBuilder.build(), false);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable(call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataTypeField field = SqlValidatorUtil.getTargetField(targetRowType, this.typeFactory, id, this.catalogReader, targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNameList.add(field.getName());
            }
        }
        RelNode mergeSourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        SqlInsert insertCall = call.getInsertCall();
        int nLevel1Exprs = 0;
        List<RexNode> level1InsertExprs = null;
        List<RexNode> level2InsertExprs = null;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            level1InsertExprs = ((LogicalProject)insertRel.getInput(0)).getProjects();
            if (insertRel.getInput(0).getInput(0) instanceof LogicalProject) {
                level2InsertExprs = ((LogicalProject)insertRel.getInput(0).getInput(0)).getProjects();
            }
            nLevel1Exprs = level1InsertExprs.size();
        }
        LogicalJoin join = (LogicalJoin)mergeSourceRel.getInput(0);
        int nSourceFields = join.getLeft().getRowType().getFieldCount();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int level1Idx = 0; level1Idx < nLevel1Exprs; ++level1Idx) {
            Objects.requireNonNull(level1InsertExprs, "level1InsertExprs");
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add(level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add(level1InsertExprs.get(level1Idx));
        }
        if (updateCall != null) {
            LogicalProject project = (LogicalProject)mergeSourceRel;
            projects.addAll(Util.skip(project.getProjects(), nSourceFields));
        }
        this.relBuilder.push(join).project(projects);
        return LogicalTableModify.create(targetTable, this.catalogReader, this.relBuilder.build(), TableModify.Operation.MERGE, targetColumnNameList, null, false);
    }

    private RexNode convertIdentifier(Blackboard bb, SqlIdentifier identifier) {
        SqlCall call = bb.getValidator().makeNullaryCall(identifier);
        if (call != null) {
            return bb.convertExpression(call);
        }
        String pv = null;
        if (bb.isPatternVarRef && identifier.names.size() > 1) {
            pv = (String)identifier.names.get(0);
        }
        SqlQualified qualified = bb.scope != null ? bb.scope.fullyQualify(identifier) : SqlQualified.create(null, 1, null, identifier);
        Pair<RexNode, @Nullable BiFunction<RexNode, String, RexNode>> e0 = bb.lookupExp(qualified);
        RexNode e = (RexNode)e0.left;
        for (String name : qualified.suffix()) {
            if (e == e0.left && e0.right != null) {
                e = (RexNode)((BiFunction)e0.right).apply(e, name);
                continue;
            }
            boolean caseSensitive = true;
            if (identifier.isStar() && bb.scope instanceof MatchRecognizeScope) {
                e = this.rexBuilder.makeFieldAccess(e, 0);
                continue;
            }
            e = this.rexBuilder.makeFieldAccess(e, name, true);
        }
        if (e instanceof RexInputRef) {
            e = this.adjustInputRef(bb, (RexInputRef)e);
            if (pv != null) {
                e = RexPatternFieldRef.of(pv, (RexInputRef)e);
            }
        }
        if (e0.left instanceof RexCorrelVariable) {
            assert (e instanceof RexFieldAccess);
            RexNode prev = bb.mapCorrelateToRex.put(((RexCorrelVariable)e0.left).id, (RexFieldAccess)e);
            assert (prev == null);
        }
        return e;
    }

    protected RexNode adjustInputRef(Blackboard bb, RexInputRef inputRef) {
        RelDataTypeField field = bb.getRootField(inputRef);
        if (field != null) {
            if (!SqlTypeUtil.equalSansNullability(this.typeFactory, field.getType(), inputRef.getType())) {
                return inputRef;
            }
            return this.rexBuilder.makeInputRef(field.getType(), inputRef.getIndex());
        }
        return inputRef;
    }

    private RelNode convertRowConstructor(Blackboard bb, SqlCall rowConstructor) {
        Preconditions.checkArgument((boolean)SqlToRelConverter.isRowConstructor(rowConstructor));
        List<SqlNode> operands = rowConstructor.getOperandList();
        return this.convertMultisets(operands, bb);
    }

    private RelNode convertCursor(Blackboard bb, SubQuery subQuery) {
        SqlCall cursorCall = (SqlCall)subQuery.node;
        assert (cursorCall.operandCount() == 1);
        Object query = cursorCall.operand(0);
        RelNode converted = this.convertQuery(query, (boolean)false, (boolean)false).rel;
        int iCursor = bb.cursors.size();
        bb.cursors.add(converted);
        subQuery.expr = new RexInputRef(iCursor, converted.getRowType());
        return converted;
    }

    private RelNode convertMultisets(List<SqlNode> operands, Blackboard bb) {
        int i;
        ArrayList<Cloneable> joinList = new ArrayList<Cloneable>();
        ArrayList<SqlNode> lastList = new ArrayList<SqlNode>();
        block4: for (i = 0; i < operands.size(); ++i) {
            RelNode input;
            SqlNode operand = operands.get(i);
            if (!(operand instanceof SqlCall)) {
                lastList.add(operand);
                continue;
            }
            final SqlCall call = (SqlCall)operand;
            switch (call.getKind()) {
                case MULTISET_VALUE_CONSTRUCTOR: 
                case ARRAY_VALUE_CONSTRUCTOR: {
                    SqlNodeList list = new SqlNodeList(call.getOperandList(), call.getParserPosition());
                    CollectNamespace nss = (CollectNamespace)this.getNamespaceOrNull(call);
                    Blackboard usedBb = null != nss ? this.createBlackboard(nss.getScope(), null, false) : this.createBlackboard(new ListScope(bb.scope()){

                        @Override
                        public SqlNode getNode() {
                            return call;
                        }
                    }, null, false);
                    RelDataType multisetType = this.validator().getValidatedNodeType(call);
                    this.validator().setValidatedNodeType(list, Objects.requireNonNull(multisetType.getComponentType(), () -> "componentType for multisetType " + multisetType));
                    input = this.convertQueryOrInList(usedBb, list, null);
                    break;
                }
                case ARRAY_QUERY_CONSTRUCTOR: 
                case MAP_QUERY_CONSTRUCTOR: 
                case MULTISET_QUERY_CONSTRUCTOR: {
                    RelRoot root = this.convertQuery((SqlNode)call.operand(0), false, true);
                    input = root.rel;
                    break;
                }
                default: {
                    lastList.add(operand);
                    continue block4;
                }
            }
            if (lastList.size() > 0) {
                joinList.add(lastList);
            }
            lastList = new ArrayList();
            this.relBuilder.push(Collect.create(Objects.requireNonNull(input, "input"), call.getKind(), (String)Nullness.castNonNull((Object)this.validator().deriveAlias(call, i))));
            joinList.add(this.relBuilder.build());
        }
        if (joinList.size() == 0) {
            joinList.add(lastList);
        }
        for (i = 0; i < joinList.size(); ++i) {
            Object o = joinList.get(i);
            if (!(o instanceof List)) continue;
            List projectList = (List)o;
            ArrayList<RexNode> selectList = new ArrayList<RexNode>();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (int j = 0; j < projectList.size(); ++j) {
                SqlNode operand = (SqlNode)projectList.get(j);
                selectList.add(bb.convertExpression(operand));
                fieldNameList.add(SqlUtil.deriveAliasFromOrdinal(j));
            }
            this.relBuilder.push(LogicalValues.createOneRow(this.cluster)).projectNamed(selectList, fieldNameList, true);
            joinList.set(i, this.relBuilder.build());
        }
        RelNode ret = (RelNode)joinList.get(0);
        for (int i2 = 1; i2 < joinList.size(); ++i2) {
            RelNode relNode = (RelNode)joinList.get(i2);
            ret = RelFactories.DEFAULT_JOIN_FACTORY.createJoin(ret, relNode, (List<RelHint>)ImmutableList.of(), this.rexBuilder.makeLiteral(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER, false);
        }
        return ret;
    }

    private void convertSelectList(Blackboard bb, SqlSelect select, List<SqlNode> orderList) {
        SqlNodeList selectList = select.getSelectList();
        selectList = this.validator().expandStar(selectList, select, false);
        this.replaceSubQueries(bb, selectList, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
        List<String> fieldNames = new ArrayList<String>();
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        TreeSet<String> aliases = new TreeSet<String>();
        ArrayList<SqlMonotonicity> columnMonotonicityList = new ArrayList<SqlMonotonicity>();
        this.extraSelectItems(bb, select, exprs, fieldNames, aliases, columnMonotonicityList);
        int i = -1;
        for (SqlNode expr : selectList) {
            exprs.add(bb.convertExpression(expr));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        for (SqlNode expr : orderList) {
            SqlNode expr2 = this.validator().expandOrderExpr(select, expr);
            exprs.add(bb.convertExpression(expr2));
            fieldNames.add(this.deriveAlias(expr, aliases, ++i));
        }
        fieldNames = SqlValidatorUtil.uniquify(fieldNames, this.catalogReader.nameMatcher().isCaseSensitive());
        this.relBuilder.push(bb.root()).projectNamed(exprs, fieldNames, true);
        RelNode project = this.relBuilder.build();
        CorrelationUse p = this.getCorrelationUse(bb, project);
        RelNode r = p != null ? p.r : project;
        bb.setRoot(r, false);
        assert (bb.columnMonotonicities.isEmpty());
        bb.columnMonotonicities.addAll(columnMonotonicityList);
        for (SqlNode selectItem : selectList) {
            bb.columnMonotonicities.add(selectItem.getMonotonicity(bb.scope));
        }
    }

    protected void extraSelectItems(Blackboard bb, SqlSelect select, List<RexNode> exprList, List<String> nameList, Collection<String> aliasList, List<SqlMonotonicity> columnMonotonicityList) {
    }

    private String deriveAlias(SqlNode node, Collection<String> aliases, int ordinal) {
        String alias = this.validator().deriveAlias(node, ordinal);
        if (alias == null || aliases.contains(alias)) {
            String aliasBase = Util.first(alias, "EXPR$");
            int j = 0;
            while (aliases.contains(alias = aliasBase + j)) {
                ++j;
            }
        }
        aliases.add(alias);
        return alias;
    }

    public RelRoot convertWith(SqlWith with, boolean top) {
        return this.convertQuery(with.body, false, top);
    }

    public RelNode convertValues(SqlCall values, @Nullable RelDataType targetRowType) {
        SqlValidatorScope scope = this.validator().getOverScope(values);
        assert (scope != null);
        Blackboard bb = this.createBlackboard(scope, null, false);
        this.convertValuesImpl(bb, values, targetRowType);
        return bb.root();
    }

    private void convertValuesImpl(Blackboard bb, SqlCall values, @Nullable RelDataType targetRowType) {
        RelNode valuesRel = this.convertRowValues(bb, values, values.getOperandList(), true, targetRowType);
        if (valuesRel != null) {
            bb.setRoot(valuesRel, true);
            return;
        }
        for (SqlNode rowConstructor1 : values.getOperandList()) {
            SqlCall rowConstructor = (SqlCall)rowConstructor1;
            Blackboard tmpBb = this.createBlackboard(bb.scope, null, false);
            this.replaceSubQueries(tmpBb, rowConstructor, RelOptUtil.Logic.TRUE_FALSE_UNKNOWN);
            ArrayList<Pair<RexNode, Object>> exps = new ArrayList<Pair<RexNode, Object>>();
            for (Ord operand : Ord.zip(rowConstructor.getOperandList())) {
                exps.add(Pair.of(tmpBb.convertExpression((SqlNode)operand.e), Nullness.castNonNull((Object)this.validator().deriveAlias((SqlNode)operand.e, operand.i))));
            }
            RelNode in = null == tmpBb.root ? LogicalValues.createOneRow(this.cluster) : tmpBb.root;
            this.relBuilder.push(in).project(Pair.left(exps), Pair.right(exps));
        }
        bb.setRoot(this.relBuilder.union(true, values.getOperandList().size()).build(), true);
    }

    private static SqlQuantifyOperator negate(SqlQuantifyOperator operator) {
        assert (operator.kind == SqlKind.ALL);
        return SqlStdOperatorTable.some(operator.comparisonKind.negateNullSafe());
    }

    public static Config config() {
        return CONFIG;
    }

    private class JsonFunctionRexRewriter
    extends RexShuttle {
        private final Set<Integer> jsonInputFields;

        JsonFunctionRexRewriter(Set<Integer> jsonInputFields) {
            this.jsonInputFields = jsonInputFields;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            if (call.getOperator() == SqlStdOperatorTable.JSON_OBJECT) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < call.operands.size(); ++i) {
                    if ((i & 1) == 0 && i != 0) {
                        builder.add((Object)this.forceChildJsonType((RexNode)call.operands.get(i)));
                        continue;
                    }
                    builder.add(call.operands.get(i));
                }
                return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, (List<? extends RexNode>)builder.build());
            }
            if (call.getOperator() == SqlStdOperatorTable.JSON_ARRAY) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add(call.operands.get(0));
                for (int i = 1; i < call.operands.size(); ++i) {
                    builder.add((Object)this.forceChildJsonType((RexNode)call.operands.get(i)));
                }
                return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, (List<? extends RexNode>)builder.build());
            }
            return super.visitCall(call);
        }

        private RexNode forceChildJsonType(RexNode rexNode) {
            RexNode childResult = rexNode.accept(this);
            if (this.isJsonResult(rexNode)) {
                return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_TYPE_OPERATOR, childResult);
            }
            return childResult;
        }

        private boolean isJsonResult(RexNode rexNode) {
            if (rexNode instanceof RexCall) {
                RexCall call = (RexCall)rexNode;
                SqlOperator operator = call.getOperator();
                return operator == SqlStdOperatorTable.JSON_OBJECT || operator == SqlStdOperatorTable.JSON_ARRAY || operator == SqlStdOperatorTable.JSON_VALUE;
            }
            if (rexNode instanceof RexInputRef) {
                RexInputRef inputRef = (RexInputRef)rexNode;
                return this.jsonInputFields.contains(inputRef.getIndex());
            }
            return false;
        }
    }

    private class NestedJsonFunctionRelRewriter
    extends RelShuttleImpl {
        private NestedJsonFunctionRelRewriter() {
        }

        @Override
        public RelNode visit(LogicalProject project) {
            Set<Integer> jsonInputFields = this.findJsonInputs(project.getInput());
            Set requiredJsonFieldsFromParent = this.stack.size() > 0 ? this.requiredJsonOutputFromParent((RelNode)this.stack.getLast()) : Collections.emptySet();
            List<RexNode> originalProjections = project.getProjects();
            ImmutableList.Builder newProjections = ImmutableList.builder();
            JsonFunctionRexRewriter rexRewriter = new JsonFunctionRexRewriter(jsonInputFields);
            for (int i = 0; i < originalProjections.size(); ++i) {
                if (requiredJsonFieldsFromParent.contains(i)) {
                    newProjections.add((Object)rexRewriter.forceChildJsonType(originalProjections.get(i)));
                    continue;
                }
                newProjections.add((Object)originalProjections.get(i).accept(rexRewriter));
            }
            RelNode newInput = project.getInput().accept(this);
            return LogicalProject.create(newInput, project.getHints(), (List<? extends RexNode>)newProjections.build(), project.getRowType().getFieldNames());
        }

        private Set<Integer> requiredJsonOutputFromParent(RelNode relNode) {
            if (!(relNode instanceof Aggregate)) {
                return Collections.emptySet();
            }
            Aggregate aggregate = (Aggregate)relNode;
            List<AggregateCall> aggregateCalls = aggregate.getAggCallList();
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (AggregateCall call : aggregateCalls) {
                if (call.getAggregation() == SqlStdOperatorTable.JSON_OBJECTAGG) {
                    result.add((Object)call.getArgList().get(1));
                    continue;
                }
                if (call.getAggregation() != SqlStdOperatorTable.JSON_ARRAYAGG) continue;
                result.add((Object)call.getArgList().get(0));
            }
            return result.build();
        }

        private Set<Integer> findJsonInputs(RelNode relNode) {
            if (!(relNode instanceof Aggregate)) {
                return Collections.emptySet();
            }
            Aggregate aggregate = (Aggregate)relNode;
            List<AggregateCall> aggregateCalls = aggregate.getAggCallList();
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (int i = 0; i < aggregateCalls.size(); ++i) {
                AggregateCall call = aggregateCalls.get(i);
                if (call.getAggregation() != SqlStdOperatorTable.JSON_OBJECTAGG && call.getAggregation() != SqlStdOperatorTable.JSON_ARRAYAGG) continue;
                result.add((Object)(aggregate.getGroupCount() + i));
            }
            return result.build();
        }
    }

    @Value.Immutable(singleton=false)
    public static interface Config {
        @Value.Default
        default public boolean isDecorrelationEnabled() {
            return true;
        }

        public Config withDecorrelationEnabled(boolean var1);

        @Value.Default
        default public boolean isTrimUnusedFields() {
            return false;
        }

        public Config withTrimUnusedFields(boolean var1);

        @Value.Default
        default public boolean isCreateValuesRel() {
            return true;
        }

        public Config withCreateValuesRel(boolean var1);

        @Value.Default
        default public boolean isExplain() {
            return false;
        }

        public Config withExplain(boolean var1);

        @Value.Default
        default public boolean isExpand() {
            return true;
        }

        public Config withExpand(boolean var1);

        @Value.Default
        default public int getInSubQueryThreshold() {
            return 20;
        }

        public Config withInSubQueryThreshold(int var1);

        @Value.Default
        default public boolean isRemoveSortInSubQuery() {
            return true;
        }

        public Config withRemoveSortInSubQuery(boolean var1);

        public RelBuilderFactory getRelBuilderFactory();

        public Config withRelBuilderFactory(RelBuilderFactory var1);

        public UnaryOperator<RelBuilder.Config> getRelBuilderConfigTransform();

        public Config withRelBuilderConfigTransform(UnaryOperator<RelBuilder.Config> var1);

        default public Config addRelBuilderConfigTransform(UnaryOperator<RelBuilder.Config> transform) {
            return this.withRelBuilderConfigTransform(this.getRelBuilderConfigTransform().andThen(transform)::apply);
        }

        public HintStrategyTable getHintStrategyTable();

        public Config withHintStrategyTable(HintStrategyTable var1);

        @Value.Default
        default public boolean isAddJsonTypeOperatorEnabled() {
            return true;
        }

        public Config withAddJsonTypeOperatorEnabled(boolean var1);
    }

    private static class CorrelationUse {
        private final CorrelationId id;
        private final ImmutableBitSet requiredColumns;
        private final RelNode r;

        CorrelationUse(CorrelationId id, ImmutableBitSet requiredColumns, RelNode r) {
            this.id = id;
            this.requiredColumns = requiredColumns;
            this.r = r;
        }
    }

    private static class AggregateFinder
    extends SqlBasicVisitor<Void> {
        final SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        final SqlNodeList filterList = new SqlNodeList(SqlParserPos.ZERO);
        final SqlNodeList distinctList = new SqlNodeList(SqlParserPos.ZERO);
        final SqlNodeList orderList = new SqlNodeList(SqlParserPos.ZERO);

        private AggregateFinder() {
        }

        @Override
        public Void visit(SqlCall call) {
            if (call.getOperator().getKind() == SqlKind.OVER) {
                return null;
            }
            if (call.getOperator().getKind() == SqlKind.FILTER) {
                SqlNode aggCall = call.getOperandList().get(0);
                SqlNode whereCall = call.getOperandList().get(1);
                this.list.add(aggCall);
                this.filterList.add(whereCall);
                return null;
            }
            if (call.getOperator().getKind() == SqlKind.WITHIN_DISTINCT) {
                SqlNode aggCall = call.getOperandList().get(0);
                SqlNodeList distinctList = (SqlNodeList)call.getOperandList().get(1);
                this.list.add(aggCall);
                distinctList.getList().forEach(this.distinctList::add);
                return null;
            }
            if (call.getOperator().getKind() == SqlKind.WITHIN_GROUP) {
                SqlNode aggCall = call.getOperandList().get(0);
                SqlNodeList orderList = (SqlNodeList)call.getOperandList().get(1);
                this.list.add(aggCall);
                this.orderList.addAll(orderList);
                return null;
            }
            if (call.getOperator().isAggregator()) {
                this.list.add(call);
                return null;
            }
            if (call instanceof SqlSelect) {
                return null;
            }
            return call.getOperator().acceptCall(this, call);
        }
    }

    public static class SqlIdentifierFinder
    implements SqlVisitor<Boolean> {
        @Override
        public Boolean visit(SqlCall sqlCall) {
            return sqlCall.getOperandList().stream().anyMatch(sqlNode -> sqlNode.accept(this));
        }

        @Override
        public Boolean visit(SqlNodeList nodeList) {
            return nodeList.stream().anyMatch(sqlNode -> sqlNode.accept(this));
        }

        @Override
        public Boolean visit(SqlIdentifier identifier) {
            return true;
        }

        @Override
        public Boolean visit(SqlLiteral literal) {
            return false;
        }

        @Override
        public Boolean visit(SqlDataTypeSpec type) {
            return false;
        }

        @Override
        public Boolean visit(SqlDynamicParam param) {
            return false;
        }

        @Override
        public Boolean visit(SqlIntervalQualifier intervalQualifier) {
            return false;
        }
    }

    private static class SubQuery {
        final SqlNode node;
        final RelOptUtil.Logic logic;
        @Nullable RexNode expr;

        private SubQuery(SqlNode node, RelOptUtil.Logic logic) {
            this.node = node;
            this.logic = logic;
        }
    }

    private class HistogramShuttle
    extends RexShuttle {
        static final boolean ENABLE_HISTOGRAM_AGG = false;
        private final ImmutableList<RexNode> partitionKeys;
        private final ImmutableList<RexNode> orderKeys;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;
        private final boolean rows;
        private final boolean allowPartial;
        private final boolean distinct;
        private final boolean ignoreNulls;

        HistogramShuttle(ImmutableList<RexNode> partitionKeys, ImmutableList<RexNode> orderKeys, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound, boolean allowPartial, boolean distinct, boolean ignoreNulls) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.rows = rows;
            this.allowPartial = allowPartial;
            this.distinct = distinct;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            SqlOperator op = call.getOperator();
            if (!(op instanceof SqlAggFunction)) {
                return super.visitCall(call);
            }
            SqlAggFunction aggOp = (SqlAggFunction)op;
            RelDataType type = call.getType();
            List<RexNode> exprs = call.getOperands();
            SqlOperator histogramOp = null;
            if (histogramOp != null) {
                boolean reinterpretCast;
                RelDataType histogramType = this.computeHistogramType(type);
                boolean bl = reinterpretCast = type.getSqlTypeName() == SqlTypeName.DECIMAL;
                if (histogramType != type) {
                    exprs = new ArrayList<RexNode>(exprs);
                    exprs.set(0, reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(histogramType, exprs.get(0), SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(histogramType, exprs.get(0)));
                }
                RexNode over = SqlToRelConverter.this.relBuilder.aggregateCall(SqlStdOperatorTable.HISTOGRAM_AGG, exprs).distinct(this.distinct).ignoreNulls(this.ignoreNulls).over().partitionBy((Iterable<? extends RexNode>)this.partitionKeys).orderBy((Iterable<? extends RexNode>)this.orderKeys).let(c -> this.rows ? c.rowsBetween(this.lowerBound, this.upperBound) : c.rangeBetween(this.lowerBound, this.upperBound)).allowPartial(this.allowPartial).toRex();
                RexNode histogramCall = SqlToRelConverter.this.rexBuilder.makeCall(histogramType, histogramOp, (List<RexNode>)ImmutableList.of((Object)over));
                if (histogramType != type) {
                    histogramCall = reinterpretCast ? SqlToRelConverter.this.rexBuilder.makeReinterpretCast(type, histogramCall, SqlToRelConverter.this.rexBuilder.makeLiteral(false)) : SqlToRelConverter.this.rexBuilder.makeCast(type, histogramCall);
                }
                return histogramCall;
            }
            boolean needSum0 = aggOp == SqlStdOperatorTable.SUM && type.isNullable();
            SqlAggFunction aggOpToUse = needSum0 ? SqlStdOperatorTable.SUM0 : aggOp;
            return SqlToRelConverter.this.relBuilder.aggregateCall(aggOpToUse, exprs).distinct(this.distinct).ignoreNulls(this.ignoreNulls).over().partitionBy((Iterable<? extends RexNode>)this.partitionKeys).orderBy((Iterable<? extends RexNode>)this.orderKeys).let(c -> this.rows ? c.rowsBetween(this.lowerBound, this.upperBound) : c.rangeBetween(this.lowerBound, this.upperBound)).allowPartial(this.allowPartial).nullWhenCountZero(needSum0).toRex();
        }

        @Nullable SqlFunction getHistogramOp(SqlAggFunction aggFunction) {
            if (aggFunction == SqlStdOperatorTable.MIN) {
                return SqlStdOperatorTable.HISTOGRAM_MIN;
            }
            if (aggFunction == SqlStdOperatorTable.MAX) {
                return SqlStdOperatorTable.HISTOGRAM_MAX;
            }
            if (aggFunction == SqlStdOperatorTable.FIRST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_FIRST_VALUE;
            }
            if (aggFunction == SqlStdOperatorTable.LAST_VALUE) {
                return SqlStdOperatorTable.HISTOGRAM_LAST_VALUE;
            }
            return null;
        }

        private RelDataType computeHistogramType(RelDataType type) {
            if (SqlTypeUtil.isExactNumeric(type) && type.getSqlTypeName() != SqlTypeName.BIGINT) {
                return SqlToRelConverter.this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            if (SqlTypeUtil.isApproximateNumeric(type) && type.getSqlTypeName() != SqlTypeName.DOUBLE) {
                return SqlToRelConverter.this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            return type;
        }
    }

    private static class LookupContext {
        private final List<Pair<RelNode, Integer>> relOffsetList = new ArrayList<Pair<RelNode, Integer>>();

        LookupContext(Blackboard bb, List<RelNode> rels, int systemFieldCount) {
            bb.flatten(rels, systemFieldCount, new int[]{0}, this.relOffsetList);
        }

        Pair<RelNode, Integer> findRel(int offset) {
            return this.relOffsetList.get(offset);
        }
    }

    protected class AggConverter
    implements SqlVisitor<Void> {
        private final Blackboard bb;
        public final @Nullable AggregatingSelectScope aggregatingSelectScope;
        private final Map<String, String> nameMap = new HashMap<String, String>();
        private final SqlNodeList groupExprs = new SqlNodeList(SqlParserPos.ZERO);
        private final Map<SqlNode, Ord<AuxiliaryConverter>> auxiliaryGroupExprs = new HashMap<SqlNode, Ord<AuxiliaryConverter>>();
        private final List<Pair<RexNode, @Nullable String>> convertedInputExprs = new ArrayList<Pair<RexNode, String>>();
        private final List<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        private final Map<SqlNode, RexNode> aggMapping = new HashMap<SqlNode, RexNode>();
        private final Map<AggregateCall, RexNode> aggCallMapping = new HashMap<AggregateCall, RexNode>();
        private boolean inOver = false;

        AggConverter(@Nullable SqlToRelConverter.Blackboard bb, AggregatingSelectScope aggregatingSelectScope) {
            this.bb = bb;
            this.aggregatingSelectScope = aggregatingSelectScope;
        }

        public AggConverter(Blackboard bb, SqlSelect select) {
            this(bb, (AggregatingSelectScope)bb.getValidator().getSelectScope(select));
            SqlNodeList selectList = select.getSelectList();
            for (int i = 0; i < selectList.size(); ++i) {
                SqlNode selectItem = selectList.get(i);
                String name = null;
                if (SqlUtil.isCallTo(selectItem, SqlStdOperatorTable.AS)) {
                    SqlCall call = (SqlCall)selectItem;
                    selectItem = call.operand(0);
                    name = ((SqlNode)call.operand(1)).toString();
                }
                if (name == null) {
                    name = this$0.validator().deriveAlias(selectItem, i);
                    assert (name != null) : "alias must not be null for " + selectItem + ", i=" + i;
                }
                this.nameMap.put(selectItem.toString(), name);
            }
        }

        public int addGroupExpr(SqlNode expr) {
            int ref = this.lookupGroupExpr(expr);
            if (ref >= 0) {
                return ref;
            }
            int index = this.groupExprs.size();
            this.groupExprs.add(expr);
            String name = this.nameMap.get(expr.toString());
            RexNode convExpr = this.bb.convertExpression(expr);
            this.addExpr(convExpr, name);
            if (expr instanceof SqlCall) {
                SqlCall call = (SqlCall)expr;
                for (Pair<SqlNode, AuxiliaryConverter> p : SqlStdOperatorTable.convertGroupToAuxiliaryCalls(call)) {
                    this.addAuxiliaryGroupExpr((SqlNode)p.left, index, (AuxiliaryConverter)p.right);
                }
            }
            return index;
        }

        void addAuxiliaryGroupExpr(SqlNode node, int index, AuxiliaryConverter converter) {
            for (SqlNode node2 : this.auxiliaryGroupExprs.keySet()) {
                if (!node2.equalsDeep(node, Litmus.IGNORE)) continue;
                return;
            }
            this.auxiliaryGroupExprs.put(node, (Ord<AuxiliaryConverter>)Ord.of((int)index, (Object)converter));
        }

        private void addExpr(RexNode expr, @Nullable String name) {
            if (name == null && expr instanceof RexInputRef) {
                int i = ((RexInputRef)expr).getIndex();
                name = this.bb.root().getRowType().getFieldList().get(i).getName();
            }
            if (Pair.right(this.convertedInputExprs).contains(name)) {
                name = null;
            }
            this.convertedInputExprs.add(Pair.of(expr, name));
        }

        @Override
        public Void visit(SqlIdentifier id) {
            return null;
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeList.get(i).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(SqlLiteral lit) {
            return null;
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            return null;
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            return null;
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }

        @Override
        public Void visit(SqlCall call) {
            switch (call.getKind()) {
                case IGNORE_NULLS: 
                case RESPECT_NULLS: 
                case FILTER: 
                case WITHIN_DISTINCT: 
                case WITHIN_GROUP: {
                    this.translateAgg(call);
                    return null;
                }
                case SELECT: {
                    return null;
                }
            }
            boolean prevInOver = this.inOver;
            if (call.getOperator().getKind() == SqlKind.OVER) {
                List<SqlNode> operandList = call.getOperandList();
                assert (operandList.size() == 2);
                this.inOver = true;
                operandList.get(0).accept(this);
                this.inOver = false;
                operandList.get(1).accept(this);
                return null;
            }
            if (call.getOperator().isAggregator()) {
                if (this.inOver) {
                    this.inOver = false;
                } else {
                    this.translateAgg(call);
                    return null;
                }
            }
            for (SqlNode operand : call.getOperandList()) {
                if (operand == null) continue;
                operand.accept(this);
            }
            this.inOver = prevInOver;
            return null;
        }

        private void translateAgg(SqlCall call) {
            this.translateAgg(call, null, null, null, false, call);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void translateAgg(SqlCall call, @Nullable SqlNode filter, @Nullable SqlNodeList distinctList, @Nullable SqlNodeList orderList, boolean ignoreNulls, SqlCall outerCall) {
            RelCollation collation;
            ImmutableBitSet distinctKeys;
            assert (this.bb.agg == this);
            assert (outerCall != null);
            List<SqlNode> operands = call.getOperandList();
            SqlParserPos pos = call.getParserPosition();
            switch (call.getKind()) {
                case FILTER: {
                    assert (filter == null);
                    this.translateAgg((SqlCall)call.operand(0), (SqlNode)call.operand(1), distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
                case WITHIN_DISTINCT: {
                    assert (orderList == null);
                    this.translateAgg((SqlCall)call.operand(0), filter, (SqlNodeList)call.operand(1), orderList, ignoreNulls, outerCall);
                    return;
                }
                case WITHIN_GROUP: {
                    assert (orderList == null);
                    this.translateAgg((SqlCall)call.operand(0), filter, distinctList, (SqlNodeList)call.operand(1), ignoreNulls, outerCall);
                    return;
                }
                case IGNORE_NULLS: {
                    ignoreNulls = true;
                }
                case RESPECT_NULLS: {
                    this.translateAgg((SqlCall)call.operand(0), filter, distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
                case COUNTIF: {
                    SqlCall call2 = SqlStdOperatorTable.COUNT.createCall(pos, SqlIdentifier.star(pos));
                    SqlNode filter2 = SqlUtil.andExpressions(filter, call.operand(0));
                    this.translateAgg(call2, filter2, distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
                case STRING_AGG: {
                    List<SqlNode> operands2;
                    if (!operands.isEmpty() && Util.last(operands) instanceof SqlNodeList) {
                        orderList = (SqlNodeList)Util.last(operands);
                        operands2 = Util.skipLast(operands);
                    } else {
                        operands2 = operands;
                    }
                    SqlCall call2 = SqlStdOperatorTable.LISTAGG.createCall(call.getFunctionQuantifier(), pos, operands2);
                    this.translateAgg(call2, filter, distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
                case GROUP_CONCAT: {
                    Object separator;
                    ArrayList<SqlNode> operands2 = new ArrayList<SqlNode>(operands);
                    if (!operands2.isEmpty() && Util.last(operands2).getKind() == SqlKind.SEPARATOR) {
                        SqlCall sepCall = (SqlCall)operands2.remove(operands.size() - 1);
                        separator = sepCall.operand(0);
                    } else {
                        separator = null;
                    }
                    if (!operands2.isEmpty() && Util.last(operands2) instanceof SqlNodeList) {
                        orderList = (SqlNodeList)operands2.remove(operands2.size() - 1);
                    }
                    if (separator != null) {
                        operands2.add((SqlNode)separator);
                    }
                    SqlCall call2 = SqlStdOperatorTable.LISTAGG.createCall(call.getFunctionQuantifier(), pos, operands2);
                    this.translateAgg(call2, filter, distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
                case ARRAY_AGG: 
                case ARRAY_CONCAT_AGG: {
                    if (operands.isEmpty() || !(Util.last(operands) instanceof SqlNodeList)) break;
                    orderList = (SqlNodeList)Util.last(operands);
                    SqlCall call2 = call.getOperator().createCall(call.getFunctionQuantifier(), pos, Util.skipLast(operands));
                    this.translateAgg(call2, filter, distinctList, orderList, ignoreNulls, outerCall);
                    return;
                }
            }
            ArrayList<Integer> args = new ArrayList<Integer>();
            int filterArg = -1;
            try {
                this.bb.agg = null;
                for (SqlNode sqlNode : call.getOperandList()) {
                    SqlIdentifier id;
                    if (sqlNode instanceof SqlIdentifier && (id = (SqlIdentifier)sqlNode).isStar()) {
                        assert (call.operandCount() == 1);
                        assert (args.isEmpty());
                        break;
                    }
                    RexNode convertedExpr = this.bb.convertExpression(sqlNode);
                    args.add(this.lookupOrCreateGroupExpr(convertedExpr));
                }
                if (filter != null) {
                    RexNode convertedExpr = this.bb.convertExpression(filter);
                    if (convertedExpr.getType().isNullable()) {
                        convertedExpr = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, convertedExpr);
                    }
                    filterArg = this.lookupOrCreateGroupExpr(convertedExpr);
                }
                if (distinctList == null) {
                    distinctKeys = null;
                } else {
                    ImmutableBitSet.Builder distinctBuilder = ImmutableBitSet.builder();
                    for (SqlNode distinct : distinctList) {
                        RexNode e = this.bb.convertExpression(distinct);
                        assert (e != null);
                        distinctBuilder.set(this.lookupOrCreateGroupExpr(e));
                    }
                    distinctKeys = distinctBuilder.build();
                }
            }
            finally {
                this.bb.agg = this;
            }
            SqlAggFunction aggFunction = (SqlAggFunction)call.getOperator();
            RelDataType relDataType = SqlToRelConverter.this.validator().deriveType(this.bb.scope(), call);
            boolean distinct = false;
            SqlLiteral quantifier = call.getFunctionQuantifier();
            if (null != quantifier && quantifier.getValue() == SqlSelectKeyword.DISTINCT) {
                distinct = true;
            }
            boolean approximate = false;
            if (aggFunction == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) {
                aggFunction = SqlStdOperatorTable.COUNT;
                distinct = true;
                approximate = true;
            }
            if (orderList == null || orderList.size() == 0) {
                collation = RelCollations.EMPTY;
            } else {
                try {
                    this.bb.agg = null;
                    collation = RelCollations.of(orderList.stream().map(order -> this.bb.convertSortExpression((SqlNode)order, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED, this::sortToFieldCollation)).collect(Collectors.toList()));
                }
                finally {
                    this.bb.agg = this;
                }
            }
            AggregateCall aggCall = AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, args, filterArg, distinctKeys, collation, relDataType, this.nameMap.get(outerCall.toString()));
            RexNode rex = SqlToRelConverter.this.rexBuilder.addAggCall(aggCall, this.groupExprs.size(), this.aggCalls, this.aggCallMapping, i -> ((RexNode)this.convertedInputExprs.get((int)i).left).getType().isNullable());
            this.aggMapping.put(outerCall, rex);
        }

        private RelFieldCollation sortToFieldCollation(SqlNode expr, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
            RexNode node = this.bb.convertExpression(expr);
            int fieldIndex = this.lookupOrCreateGroupExpr(node);
            if (nullDirection == RelFieldCollation.NullDirection.UNSPECIFIED) {
                nullDirection = direction.defaultNullDirection();
            }
            return new RelFieldCollation(fieldIndex, direction, nullDirection);
        }

        private int lookupOrCreateGroupExpr(RexNode expr) {
            int index = 0;
            for (RexNode convertedInputExpr : Pair.left(this.convertedInputExprs)) {
                if (expr.equals(convertedInputExpr)) {
                    return index;
                }
                ++index;
            }
            this.addExpr(expr, null);
            return index;
        }

        public int lookupGroupExpr(SqlNode expr) {
            for (int i = 0; i < this.groupExprs.size(); ++i) {
                SqlNode groupExpr = this.groupExprs.get(i);
                if (!expr.equalsDeep(groupExpr, Litmus.IGNORE)) continue;
                return i;
            }
            return -1;
        }

        public @Nullable RexNode lookupAggregates(SqlCall call) {
            assert (this.bb.agg == this);
            for (Map.Entry<SqlNode, Ord<AuxiliaryConverter>> e : this.auxiliaryGroupExprs.entrySet()) {
                if (!call.equalsDeep(e.getKey(), Litmus.IGNORE)) continue;
                AuxiliaryConverter converter = (AuxiliaryConverter)e.getValue().e;
                int groupOrdinal = e.getValue().i;
                return converter.convert(SqlToRelConverter.this.rexBuilder, (RexNode)this.convertedInputExprs.get((int)groupOrdinal).left, SqlToRelConverter.this.rexBuilder.makeInputRef((RelNode)Nullness.castNonNull((Object)this.bb.root), groupOrdinal));
            }
            return this.aggMapping.get(call);
        }

        public List<Pair<RexNode, @Nullable String>> getPreExprs() {
            return this.convertedInputExprs;
        }

        public List<AggregateCall> getAggCalls() {
            return this.aggCalls;
        }

        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }
    }

    private static class NoOpSubQueryConverter
    implements SubQueryConverter {
        private NoOpSubQueryConverter() {
        }

        @Override
        public boolean canConvertSubQuery() {
            return false;
        }

        @Override
        public RexNode convertSubQuery(SqlCall subQuery, SqlToRelConverter parentConverter, boolean isExists, boolean isExplain) {
            throw new IllegalArgumentException();
        }
    }

    private static class DeferredLookup {
        Blackboard bb;
        String originalRelName;

        DeferredLookup(Blackboard bb, String originalRelName) {
            this.bb = bb;
            this.originalRelName = originalRelName;
        }

        public RexFieldAccess getFieldAccess(CorrelationId name) {
            return (RexFieldAccess)Objects.requireNonNull(this.bb.mapCorrelateToRex.get(name), () -> "Correlation " + name + " is not found");
        }

        public String getOriginalRelName() {
            return this.originalRelName;
        }
    }

    protected class Blackboard
    implements SqlRexContext,
    SqlVisitor<RexNode>,
    InitializerContext {
        public final @Nullable SqlValidatorScope scope;
        private final @Nullable Map<String, RexNode> nameToNodeMap;
        public @Nullable RelNode root;
        private @Nullable List<RelNode> inputs;
        private final Map<CorrelationId, RexFieldAccess> mapCorrelateToRex = new HashMap<CorrelationId, RexFieldAccess>();
        private List<RegisterArgs> registered = new ArrayList<RegisterArgs>();
        private boolean isPatternVarRef = false;
        final List<RelNode> cursors = new ArrayList<RelNode>();
        private final List<SubQuery> subQueryList = new ArrayList<SubQuery>();
        @Nullable AggConverter agg;
        @Nullable SqlWindow window;
        private final Map<RelNode, Map<Integer, Integer>> mapRootRelToFieldProjection = new HashMap<RelNode, Map<Integer, Integer>>();
        private final List<SqlMonotonicity> columnMonotonicities = new ArrayList<SqlMonotonicity>();
        private final List<RelDataTypeField> systemFieldList = new ArrayList<RelDataTypeField>();
        final boolean top;
        private final InitializerExpressionFactory initializerExpressionFactory = new NullInitializerExpressionFactory();

        protected Blackboard(@Nullable SqlValidatorScope scope, Map<String, RexNode> nameToNodeMap, boolean top) {
            this.scope = scope;
            this.nameToNodeMap = nameToNodeMap;
            this.top = top;
        }

        public RelNode root() {
            return Objects.requireNonNull(this.root, "root");
        }

        public SqlValidatorScope scope() {
            return Objects.requireNonNull(this.scope, "scope");
        }

        public void setPatternVarRef(boolean isVarRef) {
            this.isPatternVarRef = isVarRef;
        }

        public RexNode register(RelNode rel, JoinRelType joinType) {
            return this.register(rel, joinType, null);
        }

        public RexNode register(RelNode rel, JoinRelType joinType, @Nullable List<RexNode> leftKeys) {
            RexNode joinCond;
            Objects.requireNonNull(joinType, "joinType");
            this.registered.add(new RegisterArgs(rel, joinType, leftKeys));
            if (this.root == null) {
                assert (leftKeys == null) : "leftKeys must be null";
                this.setRoot(rel, false);
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(this.root().getRowType(), 0, false);
            }
            final int origLeftInputCount = this.root.getRowType().getFieldCount();
            if (leftKeys != null) {
                ArrayList<RexNode> newLeftInputExprs = new ArrayList<RexNode>();
                for (int i = 0; i < origLeftInputCount; ++i) {
                    newLeftInputExprs.add(SqlToRelConverter.this.rexBuilder.makeInputRef(this.root(), i));
                }
                ArrayList<Integer> leftJoinKeys = new ArrayList<Integer>();
                for (RexNode leftKey : leftKeys) {
                    int index = newLeftInputExprs.indexOf(leftKey);
                    if (index < 0 || joinType == JoinRelType.LEFT) {
                        index = newLeftInputExprs.size();
                        newLeftInputExprs.add(leftKey);
                    }
                    leftJoinKeys.add(index);
                }
                RelNode newLeftInput = SqlToRelConverter.this.relBuilder.push(this.root()).project(newLeftInputExprs).build();
                Map<Integer, Integer> currentProjection = this.mapRootRelToFieldProjection.get(this.root());
                if (currentProjection != null) {
                    this.mapRootRelToFieldProjection.put(newLeftInput, currentProjection);
                }
                this.setRoot(newLeftInput, SqlToRelConverter.this.leaves.remove(this.root()) != null);
                int rightOffset = this.root().getRowType().getFieldCount() - newLeftInput.getRowType().getFieldCount();
                List<Integer> rightKeys = Util.range(rightOffset, rightOffset + leftKeys.size());
                joinCond = RelOptUtil.createEquiJoinCondition(newLeftInput, leftJoinKeys, rel, rightKeys, SqlToRelConverter.this.rexBuilder);
            } else {
                joinCond = SqlToRelConverter.this.rexBuilder.makeLiteral(true);
            }
            int leftFieldCount = this.root().getRowType().getFieldCount();
            final RelNode join = SqlToRelConverter.this.createJoin(this, this.root(), rel, joinCond, joinType);
            this.setRoot(join, false);
            if (leftKeys != null && joinType == JoinRelType.LEFT) {
                int leftKeyCount = leftKeys.size();
                int rightFieldLength = rel.getRowType().getFieldCount();
                assert (leftKeyCount == rightFieldLength - 1);
                final int rexRangeRefLength = leftKeyCount + rightFieldLength;
                RelDataType returnType = SqlToRelConverter.this.typeFactory.createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return join.getRowType().getFieldList().get(origLeftInputCount + index);
                    }

                    @Override
                    public int size() {
                        return rexRangeRefLength;
                    }
                });
                return SqlToRelConverter.this.rexBuilder.makeRangeReference(returnType, origLeftInputCount, false);
            }
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(rel.getRowType(), leftFieldCount, joinType.generatesNullsOnRight());
        }

        public RelNode reRegister(RelNode root) {
            this.setRoot(root, false);
            List<RegisterArgs> registerCopy = this.registered;
            this.registered = new ArrayList<RegisterArgs>();
            for (RegisterArgs reg : registerCopy) {
                RelNode relNode = reg.rel;
                SqlToRelConverter.this.relBuilder.push(relNode);
                RelMetadataQuery mq = SqlToRelConverter.this.relBuilder.getCluster().getMetadataQuery();
                Boolean unique = mq.areColumnsUnique(SqlToRelConverter.this.relBuilder.peek(), ImmutableBitSet.of());
                if (unique == null || !unique.booleanValue()) {
                    SqlToRelConverter.this.relBuilder.aggregate(SqlToRelConverter.this.relBuilder.groupKey(), SqlToRelConverter.this.relBuilder.aggregateCall(SqlStdOperatorTable.SINGLE_VALUE, SqlToRelConverter.this.relBuilder.field(0)));
                }
                this.register(SqlToRelConverter.this.relBuilder.build(), reg.joinType, reg.leftKeys);
            }
            return Objects.requireNonNull(this.root, "root");
        }

        public void setRoot(RelNode root, boolean leaf) {
            this.setRoot(Collections.singletonList(root), root, root instanceof LogicalJoin);
            if (leaf) {
                SqlToRelConverter.this.leaves.put(root, root.getRowType().getFieldCount());
            }
            this.columnMonotonicities.clear();
        }

        private void setRoot(List<RelNode> inputs, @Nullable RelNode root, boolean hasSystemFields) {
            this.inputs = inputs;
            this.root = root;
            this.systemFieldList.clear();
            if (hasSystemFields) {
                this.systemFieldList.addAll(SqlToRelConverter.this.getSystemFields());
            }
        }

        public void setDataset(@Nullable String datasetName) {
        }

        void setRoot(List<RelNode> inputs) {
            this.setRoot(inputs, null, false);
        }

        Pair<RexNode, @Nullable BiFunction<RexNode, String, RexNode>> lookupExp(SqlQualified qualified) {
            boolean isParent;
            if (this.nameToNodeMap != null && qualified.prefixLength == 1) {
                RexNode node = this.nameToNodeMap.get(qualified.identifier.names.get(0));
                if (node == null) {
                    throw new AssertionError((Object)("Unknown identifier '" + qualified.identifier + "' encountered while expanding expression"));
                }
                return Pair.of(node, null);
            }
            SqlNameMatcher nameMatcher = this.scope().getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            this.scope().resolve(qualified.prefix(), nameMatcher, false, resolved);
            if (resolved.count() != 1) {
                throw new AssertionError((Object)("no unique expression found for " + qualified + "; count is " + resolved.count()));
            }
            SqlValidatorScope.Resolve resolve = resolved.only();
            RelDataType rowType = resolve.rowType();
            SqlValidatorScope ancestorScope = resolve.scope;
            boolean bl = isParent = ancestorScope != this.scope;
            if (this.inputs != null && !isParent) {
                LookupContext rels = new LookupContext(this, this.inputs, this.systemFieldList.size());
                RexNode node = this.lookup(resolve.path.steps().get((int)0).i, rels);
                assert (node != null);
                return Pair.of(node, (e, fieldName) -> {
                    RelDataTypeField field = Objects.requireNonNull(rowType.getField((String)fieldName, true, false), () -> "field " + fieldName);
                    return SqlToRelConverter.this.rexBuilder.makeFieldAccess((RexNode)e, field.getIndex());
                });
            }
            DeferredLookup lookup = new DeferredLookup(this, (String)qualified.identifier.names.get(0));
            CorrelationId correlId = SqlToRelConverter.this.cluster.createCorrel();
            SqlToRelConverter.this.mapCorrelToDeferred.put(correlId, lookup);
            if (resolve.path.steps().get((int)0).i < 0) {
                return Pair.of(SqlToRelConverter.this.rexBuilder.makeCorrel(rowType, correlId), null);
            }
            RelDataTypeFactory.FieldInfoBuilder builder = SqlToRelConverter.this.typeFactory.builder();
            ListScope ancestorScope1 = (ListScope)Objects.requireNonNull(resolve.scope, "resolve.scope");
            ImmutableMap.Builder fields = ImmutableMap.builder();
            int i = 0;
            int offset = 0;
            for (SqlValidatorNamespace c : ancestorScope1.getChildren()) {
                if (ancestorScope1.isChildNullable(i)) {
                    for (RelDataTypeField f : c.getRowType().getFieldList()) {
                        ((RelDataTypeFactory.Builder)builder).add(f.getName(), SqlToRelConverter.this.typeFactory.createTypeWithNullability(f.getType(), true));
                    }
                } else {
                    ((RelDataTypeFactory.Builder)builder).addAll(c.getRowType().getFieldList());
                }
                if (i == resolve.path.steps().get((int)0).i) {
                    for (RelDataTypeField field : c.getRowType().getFieldList()) {
                        fields.put((Object)field.getName(), (Object)(field.getIndex() + offset));
                    }
                }
                ++i;
                offset += c.getRowType().getFieldCount();
            }
            RexNode c = SqlToRelConverter.this.rexBuilder.makeCorrel(((RelDataTypeFactory.Builder)builder).uniquify().build(), correlId);
            ImmutableMap fieldMap = fields.build();
            return Pair.of(c, (e, fieldName) -> {
                int j = (Integer)Objects.requireNonNull(fieldMap.get(fieldName), "field " + fieldName);
                return SqlToRelConverter.this.rexBuilder.makeFieldAccess((RexNode)e, j);
            });
        }

        RexNode lookup(int offset, LookupContext lookupContext) {
            Pair<RelNode, Integer> pair = lookupContext.findRel(offset);
            return SqlToRelConverter.this.rexBuilder.makeRangeReference(((RelNode)pair.left).getRowType(), (Integer)pair.right, false);
        }

        @Nullable RelDataTypeField getRootField(RexInputRef inputRef) {
            List<RelNode> inputs = this.inputs;
            if (inputs == null) {
                return null;
            }
            int fieldOffset = inputRef.getIndex();
            for (RelNode input : inputs) {
                RelDataType rowType = input.getRowType();
                if (fieldOffset < rowType.getFieldCount()) {
                    return rowType.getFieldList().get(fieldOffset);
                }
                fieldOffset -= rowType.getFieldCount();
            }
            return null;
        }

        public void flatten(List<RelNode> rels, int systemFieldCount, int[] start, List<Pair<RelNode, Integer>> relOffsetList) {
            for (RelNode rel : rels) {
                if (SqlToRelConverter.this.leaves.containsKey(rel)) {
                    relOffsetList.add(Pair.of(rel, start[0]));
                    start[0] = start[0] + SqlToRelConverter.this.leaves.get(rel);
                    continue;
                }
                if (rel instanceof LogicalMatch) {
                    relOffsetList.add(Pair.of(rel, start[0]));
                    start[0] = start[0] + rel.getRowType().getFieldCount();
                    continue;
                }
                if (rel instanceof LogicalJoin || rel instanceof LogicalAggregate) {
                    start[0] = start[0] + systemFieldCount;
                }
                this.flatten(rel.getInputs(), systemFieldCount, start, relOffsetList);
            }
        }

        void registerSubQuery(SqlNode node, RelOptUtil.Logic logic) {
            for (SubQuery subQuery : this.subQueryList) {
                if (node != subQuery.node) continue;
                return;
            }
            this.subQueryList.add(new SubQuery(node, logic));
        }

        @Nullable SubQuery getSubQuery(SqlNode expr) {
            for (SubQuery subQuery : this.subQueryList) {
                if (expr != subQuery.node) continue;
                return subQuery;
            }
            return null;
        }

        ImmutableList<RelNode> retrieveCursors() {
            try {
                ImmutableList immutableList = ImmutableList.copyOf(this.cursors);
                return immutableList;
            }
            finally {
                this.cursors.clear();
            }
        }

        @Override
        public RexNode convertExpression(SqlNode expr) {
            RexNode rex;
            AggConverter agg = this.agg;
            if (agg != null) {
                RexNode rex2;
                SqlNode expandedGroupExpr = SqlToRelConverter.this.validator().expand(expr, this.scope());
                int ref = agg.lookupGroupExpr(expandedGroupExpr);
                if (ref >= 0) {
                    return SqlToRelConverter.this.rexBuilder.makeInputRef(this.root(), ref);
                }
                if (expr instanceof SqlCall && (rex2 = agg.lookupAggregates((SqlCall)expr)) != null) {
                    return rex2;
                }
            }
            if ((rex = SqlToRelConverter.this.convertExtendedExpression(expr, this)) != null) {
                return rex;
            }
            SqlKind kind = expr.getKind();
            if (!SqlToRelConverter.this.config.isExpand()) {
                switch (kind) {
                    case NOT_IN: 
                    case IN: 
                    case SOME: 
                    case ALL: {
                        Object nodes;
                        SqlCall call = (SqlCall)expr;
                        Object query = call.operand(1);
                        if (query instanceof SqlNodeList) break;
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive((SqlNode)query, false, null);
                        Object operand = call.operand(0);
                        switch (((SqlNode)operand).getKind()) {
                            case ROW: {
                                nodes = ((SqlCall)operand).getOperandList();
                                break;
                            }
                            default: {
                                nodes = ImmutableList.of(operand);
                            }
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Iterator iterator = nodes.iterator();
                        while (iterator.hasNext()) {
                            SqlNode node = (SqlNode)iterator.next();
                            builder.add((Object)this.convertExpression(node));
                        }
                        ImmutableList list = builder.build();
                        switch (kind) {
                            case IN: {
                                return RexSubQuery.in(root.rel, (ImmutableList<RexNode>)list);
                            }
                            case NOT_IN: {
                                return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, RexSubQuery.in(root.rel, (ImmutableList<RexNode>)list));
                            }
                            case SOME: {
                                return RexSubQuery.some(root.rel, (ImmutableList<RexNode>)list, (SqlQuantifyOperator)call.getOperator());
                            }
                            case ALL: {
                                return SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, RexSubQuery.some(root.rel, (ImmutableList<RexNode>)list, SqlToRelConverter.negate((SqlQuantifyOperator)call.getOperator())));
                            }
                        }
                        throw new AssertionError((Object)kind);
                    }
                    case EXISTS: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        RelNode rel = root.rel;
                        while (rel instanceof Project || rel instanceof Sort && ((Sort)rel).fetch == null && ((Sort)rel).offset == null) {
                            rel = ((SingleRel)rel).getInput();
                        }
                        return RexSubQuery.exists(rel);
                    }
                    case UNIQUE: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.unique(root.rel);
                    }
                    case SCALAR_QUERY: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.scalar(root.rel);
                    }
                    case ARRAY_QUERY_CONSTRUCTOR: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.array(root.rel);
                    }
                    case MAP_QUERY_CONSTRUCTOR: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.map(root.rel);
                    }
                    case MULTISET_QUERY_CONSTRUCTOR: {
                        SqlCall call = (SqlCall)expr;
                        SqlNode query = (SqlNode)Iterables.getOnlyElement(call.getOperandList());
                        RelRoot root = SqlToRelConverter.this.convertQueryRecursive(query, false, null);
                        return RexSubQuery.multiset(root.rel);
                    }
                }
            }
            switch (kind) {
                case SOME: 
                case ALL: 
                case UNIQUE: {
                    if (SqlToRelConverter.this.config.isExpand()) {
                        throw new RuntimeException((Object)((Object)kind) + " is only supported if expand = false");
                    }
                }
                case NOT_IN: 
                case IN: 
                case CURSOR: {
                    SubQuery subQuery = Objects.requireNonNull(this.getSubQuery(expr));
                    rex = Objects.requireNonNull(subQuery.expr);
                    return StandardConvertletTable.castToValidatedType(expr, rex, SqlToRelConverter.this.validator(), SqlToRelConverter.this.rexBuilder);
                }
                case SELECT: 
                case ARRAY_QUERY_CONSTRUCTOR: 
                case MAP_QUERY_CONSTRUCTOR: 
                case MULTISET_QUERY_CONSTRUCTOR: 
                case EXISTS: 
                case SCALAR_QUERY: {
                    SubQuery subQuery = this.getSubQuery(expr);
                    assert (subQuery != null);
                    rex = subQuery.expr;
                    assert (rex != null) : "rex != null";
                    if ((kind == SqlKind.SCALAR_QUERY || kind == SqlKind.EXISTS) && this.isConvertedSubq(rex)) {
                        return rex;
                    }
                    RexNode fieldAccess = SqlToRelConverter.this.rexBuilder.makeFieldAccess(rex, rex.getType().getFieldCount() - 1);
                    if (fieldAccess.getType().isNullable() && kind == SqlKind.EXISTS) {
                        fieldAccess = SqlToRelConverter.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, fieldAccess);
                    }
                    return fieldAccess;
                }
                case OVER: {
                    return SqlToRelConverter.this.convertOver(this, expr);
                }
            }
            rex = expr.accept(this);
            return Objects.requireNonNull(rex, "rex");
        }

        public RexFieldCollation convertSortExpression(SqlNode expr, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
            return this.convertSortExpression(expr, direction, nullDirection, this::sortToRexFieldCollation);
        }

        <R> R convertSortExpression(SqlNode expr, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, SortExpressionConverter<R> converter) {
            switch (expr.getKind()) {
                case DESCENDING: {
                    return this.convertSortExpression((SqlNode)((SqlCall)expr).operand(0), RelFieldCollation.Direction.DESCENDING, nullDirection, converter);
                }
                case NULLS_LAST: {
                    return this.convertSortExpression((SqlNode)((SqlCall)expr).operand(0), direction, RelFieldCollation.NullDirection.LAST, converter);
                }
                case NULLS_FIRST: {
                    return this.convertSortExpression((SqlNode)((SqlCall)expr).operand(0), direction, RelFieldCollation.NullDirection.FIRST, converter);
                }
            }
            return converter.convert(expr, direction, nullDirection);
        }

        private RexFieldCollation sortToRexFieldCollation(SqlNode expr, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
            EnumSet<SqlKind> flags = EnumSet.noneOf(SqlKind.class);
            if (direction == RelFieldCollation.Direction.DESCENDING) {
                flags.add(SqlKind.DESCENDING);
            }
            switch (nullDirection) {
                case UNSPECIFIED: {
                    RelFieldCollation.NullDirection nullDefaultDirection;
                    RelFieldCollation.NullDirection nullDirection2 = nullDefaultDirection = SqlToRelConverter.this.validator().config().defaultNullCollation().last(SqlToRelConverter.desc(direction)) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
                    if (nullDefaultDirection == direction.defaultNullDirection()) break;
                    SqlKind nullDirectionSqlKind = SqlToRelConverter.this.validator().config().defaultNullCollation().last(SqlToRelConverter.desc(direction)) ? SqlKind.NULLS_LAST : SqlKind.NULLS_FIRST;
                    flags.add(nullDirectionSqlKind);
                    break;
                }
                case FIRST: {
                    flags.add(SqlKind.NULLS_FIRST);
                    break;
                }
                case LAST: {
                    flags.add(SqlKind.NULLS_LAST);
                    break;
                }
            }
            return new RexFieldCollation(this.convertExpression(expr), (Set<SqlKind>)flags);
        }

        private RexNode sortToRex(SqlNode expr, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
            RexNode node = this.convertExpression(expr);
            if (direction == RelFieldCollation.Direction.DESCENDING) {
                node = SqlToRelConverter.this.relBuilder.desc(node);
            }
            if (nullDirection == RelFieldCollation.NullDirection.FIRST) {
                node = SqlToRelConverter.this.relBuilder.nullsFirst(node);
            }
            if (nullDirection == RelFieldCollation.NullDirection.LAST) {
                node = SqlToRelConverter.this.relBuilder.nullsLast(node);
            }
            return node;
        }

        private boolean isConvertedSubq(RexNode rex) {
            RexNode operand;
            RexCall call;
            if (rex instanceof RexLiteral || rex instanceof RexDynamicParam) {
                return true;
            }
            return rex instanceof RexCall && (call = (RexCall)rex).getOperator() == SqlStdOperatorTable.CAST && (operand = call.getOperands().get(0)) instanceof RexLiteral;
        }

        @Override
        public int getGroupCount() {
            if (this.agg != null) {
                return this.agg.groupExprs.size();
            }
            if (this.window != null) {
                return this.window.isAlwaysNonEmpty() ? 1 : 0;
            }
            return -1;
        }

        @Override
        public RexBuilder getRexBuilder() {
            return SqlToRelConverter.this.rexBuilder;
        }

        @Override
        public SqlNode validateExpression(RelDataType rowType, SqlNode expr) {
            return (SqlNode)SqlValidatorUtil.validateExprWithRowType((boolean)SqlToRelConverter.this.catalogReader.nameMatcher().isCaseSensitive(), (SqlOperatorTable)((SqlToRelConverter)SqlToRelConverter.this).opTab, (RelDataTypeFactory)SqlToRelConverter.this.typeFactory, (RelDataType)rowType, (SqlNode)expr).left;
        }

        @Override
        public RexRangeRef getSubQueryExpr(SqlCall call) {
            SubQuery subQuery = this.getSubQuery(call);
            assert (subQuery != null);
            return (RexRangeRef)Objects.requireNonNull(subQuery.expr, () -> "subQuery.expr for " + call);
        }

        @Override
        public RelDataTypeFactory getTypeFactory() {
            return SqlToRelConverter.this.typeFactory;
        }

        @Override
        public InitializerExpressionFactory getInitializerExpressionFactory() {
            return this.initializerExpressionFactory;
        }

        @Override
        public SqlValidator getValidator() {
            return SqlToRelConverter.this.validator();
        }

        @Override
        public RexNode convertLiteral(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        public RexNode convertInterval(SqlIntervalQualifier intervalQualifier) {
            return SqlToRelConverter.this.exprConverter.convertInterval(this, intervalQualifier);
        }

        @Override
        public RexNode visit(SqlLiteral literal) {
            return SqlToRelConverter.this.exprConverter.convertLiteral(this, literal);
        }

        @Override
        public RexNode visit(SqlCall call) {
            if (this.agg != null) {
                SqlOperator op = call.getOperator();
                if (this.window == null && (op.isAggregator() || op.getKind() == SqlKind.FILTER || op.getKind() == SqlKind.WITHIN_DISTINCT || op.getKind() == SqlKind.WITHIN_GROUP)) {
                    return Objects.requireNonNull(this.agg.lookupAggregates(call), () -> "agg.lookupAggregates for call " + call);
                }
            }
            return SqlToRelConverter.this.exprConverter.convertCall(this, new SqlCallBinding(SqlToRelConverter.this.validator(), this.scope, call).permutedCall());
        }

        @Override
        public RexNode visit(SqlNodeList nodeList) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlIdentifier id) {
            return SqlToRelConverter.this.convertIdentifier(this, id);
        }

        @Override
        public RexNode visit(SqlDataTypeSpec type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RexNode visit(SqlDynamicParam param) {
            return SqlToRelConverter.this.convertDynamicParam(param);
        }

        @Override
        public RexNode visit(SqlIntervalQualifier intervalQualifier) {
            return this.convertInterval(intervalQualifier);
        }

        public List<SqlMonotonicity> getColumnMonotonicities() {
            return this.columnMonotonicities;
        }
    }

    @FunctionalInterface
    static interface SortExpressionConverter<R> {
        public R convert(SqlNode var1, RelFieldCollation.Direction var2, RelFieldCollation.NullDirection var3);
    }

    private static class RegisterArgs {
        final RelNode rel;
        final JoinRelType joinType;
        final @Nullable List<RexNode> leftKeys;

        RegisterArgs(RelNode rel, JoinRelType joinType, @Nullable List<RexNode> leftKeys) {
            this.rel = rel;
            this.joinType = joinType;
            this.leftKeys = leftKeys;
        }
    }

    private static class RexAccessShuttle
    extends RexShuttle {
        private final RexBuilder builder;
        private final RexCorrelVariable rexCorrel;
        private final BitSet varCols = new BitSet();

        RexAccessShuttle(RexBuilder builder, RexCorrelVariable rexCorrel) {
            this.builder = builder;
            this.rexCorrel = rexCorrel;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int i = input.getIndex() - this.rexCorrel.getType().getFieldCount();
            if (i < 0) {
                this.varCols.set(input.getIndex());
                return this.builder.makeFieldAccess(this.rexCorrel, input.getIndex());
            }
            return this.builder.makeInputRef(input.getType(), i);
        }
    }
}

