/*
 * Decompiled with CFR 0.152.
 */
package tr.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import tr.swing.StyledString;

public class StyledStringRenderer
implements TableCellRenderer {
    private StyledLabel sl;
    private StyledString ss;

    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(object instanceof StyledString)) {
            return null;
        }
        this.ss = (StyledString)object;
        this.sl = new StyledLabel();
        if (isSelected) {
            this.sl.setForeground(table.getSelectionForeground());
            this.sl.setBackground(table.getSelectionBackground());
        } else {
            this.sl.setForeground(this.ss.getForeground());
            this.sl.setBackground(this.ss.getBackground());
        }
        this.sl.strike = this.ss.isStrike();
        this.sl.setText(this.ss.getString());
        return this.sl;
    }

    private static class StyledLabel
    extends JLabel {
        private static final Font df = new JTextField().getFont();
        public boolean strike;

        public StyledLabel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(true);
        }

        public String getText() {
            String text = super.getText();
            if (text == null || text.trim().length() == 0) {
                return "";
            }
            if (this.strike) {
                return "<html><strike>" + text + "</strike></html>";
            }
            return text;
        }
    }
}

