/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.tree;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import java.io.PrintStream;

public class AssemblyParseToken
extends AssemblyParseTreeNode {
    protected final AssemblyTerminal term;
    protected final String str;

    public AssemblyParseToken(AssemblyGrammar grammar, AssemblyTerminal term, String str) {
        super(grammar);
        this.term = term;
        this.str = str;
    }

    public int hashCode() {
        int result = this.term.hashCode();
        result *= 31;
        return result += this.str.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssemblyParseToken that = (AssemblyParseToken)obj;
        if (!this.term.equals(that.term)) {
            return false;
        }
        return this.str.equals(that.str);
    }

    public String getString() {
        return this.str;
    }

    @Override
    public AssemblyTerminal getSym() {
        return this.term;
    }

    @Override
    protected void print(PrintStream out, String indent) {
        out.println(indent + this.term + " := " + this.toString());
    }

    public String toString() {
        return "'" + this.str + "'";
    }

    @Override
    public String generateString() {
        return this.str;
    }
}

