/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.DecisionNode;
import ghidra.pcodeCPort.slghsymbol.DecisionProperties;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class SubtableSymbol
extends TripleSymbol {
    private TokenPattern pattern;
    private boolean beingbuilt;
    private boolean errors;
    private VectorSTL<Constructor> construct = new VectorSTL();
    private DecisionNode decisiontree;

    public SubtableSymbol(Location location) {
        super(location);
        this.pattern = null;
        this.decisiontree = null;
    }

    public boolean isBeingBuilt() {
        return this.beingbuilt;
    }

    public boolean isError() {
        return this.errors;
    }

    public void addConstructor(Constructor ct) {
        ct.setId(this.construct.size());
        this.construct.push_back((Object)ct);
    }

    @Override
    public Constructor resolve(ParserWalker pos) {
        return this.decisiontree.resolve(pos);
    }

    public TokenPattern getPattern() {
        return this.pattern;
    }

    public int getNumConstructors() {
        return this.construct.size();
    }

    public Constructor getConstructor(int id) {
        return (Constructor)this.construct.get(id);
    }

    @Override
    public PatternExpression getPatternExpression() {
        throw new SleighError("Cannot use subtable in expression", null);
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker pos) {
        throw new SleighError("Cannot use subtable in expression", null);
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        throw new SleighError("Cannot use subtable in expression", null);
    }

    @Override
    public void collectLocalValues(ArrayList<Long> results) {
        for (Constructor curConstruct : this.construct) {
            curConstruct.collectLocalExports(results);
        }
    }

    @Override
    public symbol_type getType() {
        return symbol_type.subtable_symbol;
    }

    public SubtableSymbol(Location location, String nm) {
        super(location, nm);
        this.beingbuilt = false;
        this.pattern = null;
        this.decisiontree = null;
    }

    @Override
    public void dispose() {
        if (this.pattern != null) {
            this.pattern.dispose();
        }
        if (this.decisiontree != null) {
            this.decisiontree.dispose();
        }
        IteratorSTL iter = this.construct.begin();
        while (!iter.isEnd()) {
            ((Constructor)iter.get()).dispose();
            iter.increment();
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        if (this.decisiontree == null) {
            return;
        }
        s.append("<subtable_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(" numct=\"").print(this.construct.size());
        s.append("\">\n");
        for (int i = 0; i < this.construct.size(); ++i) {
            ((Constructor)this.construct.get(i)).saveXml(s);
        }
        this.decisiontree.saveXml(s);
        s.append("</subtable_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<subtable_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        int numct = XmlUtils.decodeUnknownInt(el.getAttributeValue("numct"));
        this.construct.reserve(numct);
        List children = el.getChildren();
        for (Element child : children) {
            if (child.getName().equals("constructor")) {
                Constructor ct = new Constructor(null);
                this.addConstructor(ct);
                ct.restoreXml(child, trans);
                continue;
            }
            if (!child.getName().equals("decision")) continue;
            this.decisiontree = new DecisionNode();
            this.decisiontree.restoreXml(child, null, this);
        }
        this.pattern = null;
        this.beingbuilt = false;
        this.errors = false;
    }

    public void buildDecisionTree(DecisionProperties props) {
        if (this.pattern == null) {
            return;
        }
        this.decisiontree = new DecisionNode(null);
        for (int i = 0; i < this.construct.size(); ++i) {
            Constructor constructor = (Constructor)this.construct.get(i);
            TokenPattern tpat = constructor.getPattern();
            Pattern pat = tpat.getPattern();
            if (pat.numDisjoint() == 0) {
                this.decisiontree.addConstructorPair((DisjointPattern)pat, (Constructor)this.construct.get(i));
                continue;
            }
            for (int j = 0; j < pat.numDisjoint(); ++j) {
                this.decisiontree.addConstructorPair(pat.getDisjoint(j), (Constructor)this.construct.get(i));
            }
        }
        this.decisiontree.split(props);
    }

    public TokenPattern buildPattern(PrintStream s) {
        if (this.pattern != null) {
            return this.pattern;
        }
        this.errors = false;
        this.beingbuilt = true;
        this.pattern = new TokenPattern(Location.INTERNALLY_DEFINED);
        if (this.construct.empty()) {
            s.append("Error: There are no constructors in table: " + this.getName()).append("\n");
            this.errors = true;
            return this.pattern;
        }
        try {
            ((Constructor)this.construct.front()).buildPattern(s);
        }
        catch (SleighError err) {
            s.append("Error: ").append(err.getMessage()).append(": for ");
            ((Constructor)this.construct.front()).printInfo(s);
            s.println();
            this.errors = true;
        }
        this.pattern = ((Constructor)this.construct.front()).getPattern();
        for (int i = 1; i < this.construct.size(); ++i) {
            try {
                Constructor constructor = (Constructor)this.construct.get(i);
                constructor.buildPattern(s);
            }
            catch (SleighError err) {
                s.append("Error: ").append(err.getMessage()).append(": for ");
                ((Constructor)this.construct.get(i)).printInfo(s);
                s.println();
                this.errors = true;
            }
            this.pattern = ((Constructor)this.construct.get(i)).getPattern().commonSubPattern(this.pattern);
            this.pattern.simplifyPattern();
        }
        this.beingbuilt = false;
        return this.pattern;
    }
}

