/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Undefined2DataType;
import ghidra.program.model.data.Undefined3DataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.Undefined5DataType;
import ghidra.program.model.data.Undefined6DataType;
import ghidra.program.model.data.Undefined7DataType;
import ghidra.program.model.data.Undefined8DataType;

public abstract class Undefined
extends BuiltIn {
    private static final long serialVersionUID = 1L;
    private static Undefined[] undefinedTypes;

    protected Undefined(String name, DataTypeManager dtm) {
        super(CategoryPath.ROOT, name, dtm);
    }

    private static synchronized Undefined[] getUndefinedTypes() {
        if (undefinedTypes == null) {
            undefinedTypes = new Undefined[]{Undefined1DataType.dataType, Undefined2DataType.dataType, Undefined3DataType.dataType, Undefined4DataType.dataType, Undefined5DataType.dataType, Undefined6DataType.dataType, Undefined7DataType.dataType, Undefined8DataType.dataType};
        }
        return undefinedTypes;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    public static DataType getUndefinedDataType(int size) {
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size > 8) {
            return new ArrayDataType(Undefined1DataType.dataType, size, 1);
        }
        return Undefined.getUndefinedTypes()[size - 1];
    }

    public static Undefined[] getUndefinedDataTypes() {
        return (Undefined[])Undefined.getUndefinedTypes().clone();
    }

    public static boolean isUndefined(DataType dataType) {
        if (dataType instanceof DefaultDataType) {
            return true;
        }
        if (dataType instanceof Undefined) {
            return true;
        }
        return Undefined.isUndefinedArray(dataType);
    }

    public static boolean isUndefinedArray(DataType dataType) {
        if (!(dataType instanceof Array)) {
            return false;
        }
        DataType baseType = ((Array)dataType).getDataType();
        return baseType instanceof Undefined || baseType instanceof DefaultDataType;
    }
}

