/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;

public abstract class HighVariable {
    private String name;
    private DataType type;
    private Varnode represent;
    private Varnode[] instances;
    private HighFunction function;

    protected HighVariable(String nm, DataType tp, Varnode rep, Varnode[] inst, HighFunction func) {
        this.name = nm;
        this.type = tp;
        this.function = func;
        this.attachInstances(inst, rep);
    }

    protected void setHighOnInstances() {
        for (int i = 0; i < this.instances.length; ++i) {
            if (!(this.instances[i] instanceof VarnodeAST)) continue;
            ((VarnodeAST)this.instances[i]).setHigh(this);
        }
    }

    public HighFunction getHighFunction() {
        return this.function;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.represent.getSize();
    }

    public DataType getDataType() {
        return this.type;
    }

    public Varnode getRepresentative() {
        return this.represent;
    }

    public Varnode[] getInstances() {
        return this.instances;
    }

    public void attachInstances(Varnode[] inst, Varnode rep) {
        this.represent = rep;
        if (inst == null) {
            this.instances = new Varnode[1];
            this.instances[0] = rep;
        } else {
            this.instances = inst;
        }
    }

    public VariableStorage getStorage() {
        Program program = this.getHighFunction().getFunction().getProgram();
        try {
            if (this.represent != null && (this.represent.isAddress() || this.represent.isRegister())) {
                return new VariableStorage(program, this.represent);
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Failed to define variable storage: " + this), (Throwable)e);
        }
        return VariableStorage.UNASSIGNED_STORAGE;
    }
}

