/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

public enum SourceType {
    ANALYSIS("Analysis", 2),
    USER_DEFINED("User Defined", 4),
    DEFAULT("Default", 1),
    IMPORTED("Imported", 3);

    private final String displayString;
    private final int priority;

    private SourceType(String displayString, int priority) {
        this.displayString = displayString;
        this.priority = priority;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public boolean isHigherPriorityThan(SourceType source) {
        return this.priority > source.priority;
    }

    public boolean isLowerPriorityThan(SourceType source) {
        return this.priority < source.priority;
    }
}

