/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.db;

import db.DBHandle;
import db.Database;
import db.buffers.BufferFile;
import db.buffers.BufferFileManager;
import db.buffers.LocalBufferFile;
import db.buffers.LocalManagedBufferFile;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.framework.store.db.VersionedDBListener;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionedDatabase
extends Database {
    static final Logger log = LogManager.getLogger(VersionedDatabase.class);
    public final int LATEST_VERSION = -1;
    public static final long DEFAULT_CHECKOUT_ID = -1L;
    protected VersionedDBListener verDBListener;

    private VersionedDatabase(File dbDir, VersionedDBListener verDBListener, boolean create) throws IOException {
        super(dbDir, true, create);
        this.verDBListener = verDBListener;
        this.bfMgr = new VerDBBufferFileManager();
        this.scanFiles(true);
        if (create && this.currentVersion != 0) {
            throw new IOException("Database already exists");
        }
        if (!create && this.currentVersion == 0) {
            throw new FileNotFoundException("Database files not found");
        }
    }

    public VersionedDatabase(File dbDir, VersionedDBListener verDBListener) throws IOException {
        this(dbDir, verDBListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedDatabase(File dbDir, BufferFile srcFile, VersionedDBListener verDBListener, long checkoutId, String comment, TaskMonitor monitor) throws IOException, CancelledException {
        this(dbDir, verDBListener, true);
        boolean success = false;
        LocalManagedBufferFile newFile = null;
        try {
            if (verDBListener.getCheckoutVersion(checkoutId) != 0) {
                throw new IOException("Expected checkout version of 0");
            }
            newFile = new LocalManagedBufferFile(srcFile.getBufferSize(), this.bfMgr, checkoutId);
            newFile.setVersionComment(comment);
            LocalBufferFile.copyFile((BufferFile)srcFile, (BufferFile)newFile, null, (TaskMonitor)monitor);
            newFile.close();
            success = true;
        }
        finally {
            if (!success) {
                if (newFile != null) {
                    newFile.delete();
                }
                if (this.dbDirCreated) {
                    VersionedDatabase.deleteDir((File)dbDir);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedDatabase(File dbDir, File packedFile, VersionedDBListener verDBListener, long checkoutId, String comment, TaskMonitor monitor) throws IOException, CancelledException {
        this(dbDir, verDBListener, true);
        boolean success = false;
        try {
            if (verDBListener.getCheckoutVersion(checkoutId) != 0) {
                throw new IOException("Expected checkout version of 0");
            }
            PackedDatabase.unpackDatabase(this.bfMgr, checkoutId, packedFile, monitor);
            success = true;
        }
        finally {
            if (!success && this.dbDirCreated) {
                VersionedDatabase.deleteDir((File)dbDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalManagedBufferFile createVersionedDatabase(File dbDir, int bufferSize, VersionedDBListener verDBListener, long checkoutId) throws IOException {
        VersionedDatabase db = new VersionedDatabase(dbDir, verDBListener, true);
        boolean success = false;
        try {
            LocalManagedBufferFile bfile = new LocalManagedBufferFile(bufferSize, db.bfMgr, checkoutId);
            success = true;
            LocalManagedBufferFile localManagedBufferFile = bfile;
            return localManagedBufferFile;
        }
        finally {
            if (!success && db.dbDirCreated) {
                VersionedDatabase.deleteDir((File)dbDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumVersion() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.minVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentVersion() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMinimumVersion() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.minVersion == this.currentVersion) {
                throw new IOException("Unable to delete last remaining version");
            }
            File versionFile = this.bfMgr.getVersionFile(this.minVersion);
            File changeFile = this.bfMgr.getChangeDataFile(this.minVersion);
            File delVersionFile = new File(versionFile.getParentFile(), versionFile.getName() + ".delete");
            File delChangeFile = new File(changeFile.getParentFile(), changeFile.getName() + ".delete");
            delVersionFile.delete();
            delChangeFile.delete();
            if (!versionFile.renameTo(delVersionFile)) {
                throw new FileInUseException("Version " + this.minVersion + " is in use");
            }
            if (!changeFile.renameTo(delChangeFile)) {
                delVersionFile.renameTo(versionFile);
                throw new FileInUseException("Version " + this.minVersion + " is in use");
            }
            delVersionFile.delete();
            delChangeFile.delete();
            int deletedVersion = this.minVersion++;
            this.verDBListener.versionDeleted(deletedVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrentVersion() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.minVersion == this.currentVersion) {
                throw new IOException("Unable to delete last remaining version");
            }
            int prevVer = this.currentVersion - 1;
            File prevBFile = this.bfMgr.getBufferFile(prevVer);
            if (!prevBFile.exists()) {
                LocalManagedBufferFile srcBf = this.openBufferFile(prevVer, -1);
                try {
                    srcBf.clone(prevBFile, null);
                }
                catch (CancelledException e) {
                    throw new AssertException();
                }
                finally {
                    try {
                        srcBf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            File versionFile = this.bfMgr.getVersionFile(prevVer);
            File changeFile = this.bfMgr.getChangeDataFile(prevVer);
            File delVersionFile = new File(versionFile.getParentFile(), versionFile.getName() + ".delete");
            File delChangeFile = new File(changeFile.getParentFile(), changeFile.getName() + ".delete");
            delVersionFile.delete();
            delChangeFile.delete();
            if (!versionFile.renameTo(delVersionFile)) {
                throw new FileInUseException("Version " + prevVer + " is in use");
            }
            if (!changeFile.renameTo(delChangeFile)) {
                delVersionFile.renameTo(versionFile);
                throw new FileInUseException("Version " + prevVer + " is in use");
            }
            if (!this.bfMgr.getBufferFile(this.currentVersion).delete()) {
                prevBFile.delete();
                delVersionFile.renameTo(versionFile);
                delChangeFile.renameTo(changeFile);
                throw new FileInUseException("Version " + this.currentVersion + " is in use");
            }
            delVersionFile.delete();
            delChangeFile.delete();
            int deletedVersion = this.currentVersion--;
            this.verDBListener.versionDeleted(deletedVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openBufferFile(int version, int minChangeDataVer) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (version != -1 && (version > this.currentVersion || version < this.minVersion)) {
                throw new FileNotFoundException("Version " + version + " not available for " + this.dbDir);
            }
            if (version == this.currentVersion || version == -1) {
                return new LocalManagedBufferFile(this.bfMgr, false, minChangeDataVer, -1L);
            }
            return new LocalManagedBufferFile(this.bfMgr, version, minChangeDataVer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBHandle open(int version, int minChangeDataVer, TaskMonitor monitor) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return new DBHandle((BufferFile)this.openBufferFile(version, minChangeDataVer));
        }
    }

    public DBHandle openForUpdate(TaskMonitor monitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openBufferFileForUpdate(long checkoutId) throws IOException {
        if (!this.updateAllowed) {
            throw new IOException("Update use not permitted");
        }
        Object object = this.syncObject;
        synchronized (object) {
            int minChangeDataVer = this.verDBListener.getCheckoutVersion(checkoutId);
            if (minChangeDataVer < 0) {
                throw new IOException("Checkout not found");
            }
            return new LocalManagedBufferFile(this.bfMgr, true, minChangeDataVer, checkoutId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dbMoved(File dbDir) throws FileNotFoundException {
        Object object = this.syncObject;
        synchronized (object) {
            this.dbDir = dbDir;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanFiles(boolean repair) throws FileNotFoundException {
        Object object = this.syncObject;
        synchronized (object) {
            super.scanFiles(repair);
            if (this.currentVersion != 0 && repair) {
                this.verDBListener.versionsChanged(this.minVersion, this.currentVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(int version, File outputFile, String name, int filetype, String contentType, TaskMonitor monitor) throws IOException, CancelledException {
        Object object = this.syncObject;
        synchronized (object) {
            if (outputFile.exists()) {
                throw new DuplicateFileException(outputFile.getName() + " already exists");
            }
            if (version == -1 || version == this.currentVersion) {
                File file = this.bfMgr.getBufferFile(this.currentVersion);
                BufferedInputStream itemIn = new BufferedInputStream(new FileInputStream(file));
                boolean success = false;
                try {
                    ItemSerializer.outputItem(name, contentType, filetype, file.length(), itemIn, outputFile, monitor);
                    success = true;
                }
                finally {
                    try {
                        ((InputStream)itemIn).close();
                    }
                    catch (IOException iOException) {}
                    if (!success) {
                        outputFile.delete();
                    }
                }
            }
            try (LocalManagedBufferFile bf = this.openBufferFile(version, -1);){
                File tmpFile = File.createTempFile("ghidra", ".tmp");
                tmpFile.delete();
                LocalBufferFile tmpBf = new LocalBufferFile(tmpFile, bf.getBufferSize());
                boolean success = false;
                try {
                    LocalBufferFile.copyFile((BufferFile)bf, (BufferFile)tmpBf, null, (TaskMonitor)monitor);
                    tmpBf.close();
                    FileInputStream itemIn = new FileInputStream(tmpFile);
                    try {
                        ItemSerializer.outputItem(name, contentType, filetype, tmpFile.length(), itemIn, outputFile, monitor);
                    }
                    finally {
                        try {
                            ((InputStream)itemIn).close();
                        }
                        catch (IOException iOException) {}
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        outputFile.delete();
                    }
                    tmpBf.close();
                    tmpFile.delete();
                }
            }
        }
    }

    private class VerDBBufferFileManager
    implements BufferFileManager {
        private VerDBBufferFileManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCurrentVersion() {
            Object object = VersionedDatabase.this.syncObject;
            synchronized (object) {
                return VersionedDatabase.this.currentVersion;
            }
        }

        public File getBufferFile(int version) {
            return new File(VersionedDatabase.this.dbDir, "db." + version + ".gbf");
        }

        public File getVersionFile(int version) {
            return new File(VersionedDatabase.this.dbDir, "ver." + version + ".gbf");
        }

        public File getChangeDataFile(int version) {
            return new File(VersionedDatabase.this.dbDir, "change." + version + ".gbf");
        }

        public File getChangeMapFile() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void versionCreated(int version, String comment, long checkinId) throws FileNotFoundException {
            Object object = VersionedDatabase.this.syncObject;
            synchronized (object) {
                File bfile = this.getBufferFile(version);
                long createTime = bfile.lastModified();
                if (createTime == 0L) {
                    log.error(VersionedDatabase.this.dbDir + ": new version not found (" + version + ")");
                    return;
                }
                if (VersionedDatabase.this.currentVersion != version - 1) {
                    log.error(VersionedDatabase.this.dbDir + ": unexpected version created (" + version + "), expected version " + (VersionedDatabase.this.currentVersion + 1));
                    if (version > VersionedDatabase.this.currentVersion || version < VersionedDatabase.this.minVersion) {
                        bfile.delete();
                    }
                    return;
                }
                if (!VersionedDatabase.this.verDBListener.versionCreated(VersionedDatabase.this, version, createTime, comment, checkinId)) {
                    bfile.delete();
                    if (!bfile.exists()) {
                        log.info(VersionedDatabase.this.dbDir + ": version " + version + " removed");
                        version = VersionedDatabase.this.currentVersion;
                    }
                }
                VersionedDatabase.this.scanFiles(true);
                if (VersionedDatabase.this.currentVersion == 0) {
                    throw new FileNotFoundException("Database files not found");
                }
                if (version != VersionedDatabase.this.currentVersion) {
                    log.error(VersionedDatabase.this.dbDir + ": Unexpected version found (" + VersionedDatabase.this.currentVersion + "), expected " + version);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateEnded(long checkinId) {
            Object object = VersionedDatabase.this.syncObject;
            synchronized (object) {
                VersionedDatabase.this.verDBListener.checkinCompleted(checkinId);
            }
        }
    }
}

