/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressHasher;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.VertexInfo;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Element;

class GroupedVertexInfo
extends VertexInfo {
    static final String GROUPED_VERTEX_INFO_ELEMENT_NAME = "GROUPED_VERTEX_INFO";
    private static final String USER_TEXT_ATTRIBUTE = "USER_TEXT";
    private static final String BACKGROUND_COLOR_ATTRIBUTE = "BACKGROUND_COLOR";
    private Set<VertexInfo> vertexInfos = new HashSet<VertexInfo>();
    private String userText;
    private Color backgroundColor;

    GroupedVertexInfo(GroupedFunctionGraphVertex vertex, FunctionGraph functionGraph) {
        super(vertex, functionGraph);
        Set<FGVertex> vertices = vertex.getVertices();
        for (FGVertex childVertex : vertices) {
            if (childVertex instanceof GroupedFunctionGraphVertex) {
                this.vertexInfos.add(new GroupedVertexInfo((GroupedFunctionGraphVertex)childVertex, functionGraph));
                continue;
            }
            this.vertexInfos.add(new VertexInfo(childVertex, functionGraph));
        }
        this.userText = vertex.getUserText();
        this.backgroundColor = vertex.getBackgroundColor();
    }

    GroupedVertexInfo(Element element) {
        super(element);
        List children = element.getChildren("VERTEX_INFO");
        for (Element vertexInfoElement : children) {
            this.vertexInfos.add(new VertexInfo(vertexInfoElement));
        }
        children = element.getChildren(GROUPED_VERTEX_INFO_ELEMENT_NAME);
        for (Element groupedVertexInfoElement : children) {
            this.vertexInfos.add(new GroupedVertexInfo(groupedVertexInfoElement));
        }
        if (this.vertexInfos.isEmpty()) {
            throw new IllegalArgumentException("Saved GroupedVertexInfo XML does not have child vertices");
        }
        this.userText = XmlUtilities.unEscapeElementEntities((String)element.getAttributeValue(USER_TEXT_ATTRIBUTE));
        this.backgroundColor = this.decodeColor(element.getAttributeValue(BACKGROUND_COLOR_ATTRIBUTE));
    }

    private Color decodeColor(String colorString) {
        if (colorString == null) {
            return FunctionGraphOptions.DEFAULT_GROUP_BACKGROUND_COLOR;
        }
        StringTokenizer tokenizer = new StringTokenizer(colorString, ",");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount != 4) {
            return FunctionGraphOptions.DEFAULT_GROUP_BACKGROUND_COLOR;
        }
        String redString = tokenizer.nextToken();
        String greenString = tokenizer.nextToken();
        String blueString = tokenizer.nextToken();
        String alphaString = tokenizer.nextToken();
        try {
            int red = Integer.parseInt(redString);
            int green = Integer.parseInt(greenString);
            int blue = Integer.parseInt(blueString);
            int alpha = Integer.parseInt(alphaString);
            return new Color(red, green, blue, alpha);
        }
        catch (NumberFormatException e) {
            Msg.error((Object)this, (Object)"Unexpected exception parsing number", (Throwable)e);
            return FunctionGraphOptions.DEFAULT_GROUP_BACKGROUND_COLOR;
        }
    }

    private String encodeColor(Color color) {
        if (color == null) {
            return this.encodeColor(FunctionGraphOptions.DEFAULT_GROUP_BACKGROUND_COLOR);
        }
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha();
    }

    @Override
    Element toXML() {
        Element element = super.toXML();
        for (VertexInfo info : this.vertexInfos) {
            Element vertexElement = info.toXML();
            element.addContent((Content)vertexElement);
        }
        String escapedText = XmlUtilities.escapeElementEntities((String)this.userText);
        element.setAttribute(USER_TEXT_ATTRIBUTE, escapedText);
        element.setAttribute(BACKGROUND_COLOR_ATTRIBUTE, this.encodeColor(this.backgroundColor));
        return element;
    }

    FGVertex locateVertex(FGController controller, Map<AddressHasher, FGVertex> vertexMap) {
        return super.getVertex(controller, vertexMap);
    }

    @Override
    FGVertex getVertex(FGController controller, Map<AddressHasher, FGVertex> vertexMap) {
        Set<GroupedVertexInfo> groupInfos = this.getGroupVertexInfos(this.vertexInfos);
        HashSet<FGVertex> vertices = new HashSet<FGVertex>();
        HashSet<FGEdge> edges = new HashSet<FGEdge>();
        this.createVertexAndEdges(controller, vertexMap, groupInfos, vertices, edges);
        HashSet<VertexInfo> nonGroupInfos = new HashSet<VertexInfo>(this.vertexInfos);
        nonGroupInfos.removeAll(groupInfos);
        this.createVertexAndEdges(controller, vertexMap, nonGroupInfos, vertices, edges);
        if (vertices.isEmpty()) {
            return null;
        }
        GroupedFunctionGraphVertex vertex = new GroupedFunctionGraphVertex(controller, this.userText, vertices, edges);
        Color defaultBackgroundColor = vertex.getDefaultBackgroundColor();
        if (!defaultBackgroundColor.equals(this.backgroundColor)) {
            vertex.setBackgroundColor(this.backgroundColor);
        }
        return vertex;
    }

    private void createVertexAndEdges(FGController controller, Map<AddressHasher, FGVertex> vertexMap, Set<? extends VertexInfo> infos, Set<FGVertex> vertices, Set<FGEdge> edges) {
        for (VertexInfo vertexInfo : infos) {
            Set<FGEdge> restoredOutEdges;
            Set<FGEdge> restoredInEdges;
            FGVertex vertex = vertexInfo.getVertex(controller, vertexMap);
            if (vertex == null || (vertex = this.checkForGroupVertex(controller, vertex, vertexInfo.getVertexLocation())) == null || (restoredInEdges = vertexInfo.getInEdges(controller, vertex)) == null || (restoredOutEdges = vertexInfo.getOutEdges(controller, vertex)) == null) continue;
            vertices.add(vertex);
            edges.addAll(restoredInEdges);
            edges.addAll(restoredOutEdges);
        }
    }

    private Set<GroupedVertexInfo> getGroupVertexInfos(Set<VertexInfo> allInfos) {
        HashSet<GroupedVertexInfo> groupInfos = new HashSet<GroupedVertexInfo>();
        for (VertexInfo info : allInfos) {
            if (!(info instanceof GroupedVertexInfo)) continue;
            groupInfos.add((GroupedVertexInfo)info);
        }
        return groupInfos;
    }

    private FGVertex checkForGroupVertex(FGController controller, FGVertex vertex, Point2D location) {
        if (!(vertex instanceof GroupedFunctionGraphVertex)) {
            return vertex;
        }
        boolean installed = controller.installGroupVertex((GroupedFunctionGraphVertex)vertex, location);
        return installed ? vertex : null;
    }

    @Override
    protected String getVertexInfoElementName() {
        return GROUPED_VERTEX_INFO_ELEMENT_NAME;
    }

    @Override
    public String toString() {
        String superString = super.toString();
        StringBuffer buffy = new StringBuffer(superString);
        buffy.append('\n');
        for (VertexInfo info : this.vertexInfos) {
            buffy.append('\t').append(info.toString()).append('\n');
        }
        return buffy.toString();
    }
}

