/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.GhidraFolder;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class GhidraFile
implements DomainFile {
    protected ProjectFileManager fileManager;
    private LocalFileSystem fileSystem;
    private DomainFolderChangeListener listener;
    private GhidraFolder parent;
    private String name;

    GhidraFile(GhidraFolder parent, String name) {
        this.parent = parent;
        this.name = name;
        this.fileManager = parent.getProjectFileManager();
        this.fileSystem = parent.getLocalFileSystem();
        this.listener = parent.getChangeListener();
    }

    public LocalFileSystem getUserFileSystem() {
        return this.fileManager.getUserFileSystem();
    }

    private GhidraFileData getFileData() throws IOException {
        return this.parent.getFileData(this.name);
    }

    private void fileError(IOException e) {
    }

    @Override
    public boolean exists() {
        try {
            this.getFileData();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getFileID() {
        try {
            return this.getFileData().getFileID();
        }
        catch (IOException e) {
            this.fileError(e);
            return null;
        }
    }

    void resetFileID() throws IOException {
        this.getFileData().resetFileID();
    }

    void clearDomainObj() {
        String path = this.getPathname();
        DomainObjectAdapter doa = this.fileManager.getOpenedDomainObject(path);
        if (doa != null && this.fileManager.clearDomainObject(this.getPathname())) {
            this.listener.domainFileObjectClosed(this, doa);
        }
    }

    @Override
    public GhidraFile setName(String newName) throws InvalidNameException, IOException {
        return this.getFileData().setName(newName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathname() {
        return this.parent.getPathname(this.name);
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.fileManager.getProjectLocator();
    }

    @Override
    public String getContentType() {
        try {
            return this.getFileData().getContentType();
        }
        catch (IOException e) {
            this.fileError(e);
            return "Unknown-File";
        }
    }

    @Override
    public Class<? extends DomainObject> getDomainObjectClass() {
        try {
            return this.getFileData().getDomainObjectClass();
        }
        catch (IOException e) {
            this.fileError(e);
            return DomainObject.class;
        }
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(DomainFile df) {
        return this.name.compareToIgnoreCase(df.getName());
    }

    @Override
    public ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException {
        return this.getFileData().getChangesByOthersSinceCheckout();
    }

    @Override
    public DomainObject getOpenedDomainObject(Object consumer) {
        DomainObjectAdapter domainObj = this.fileManager.getOpenedDomainObject(this.getPathname());
        if (domainObj != null && !domainObj.addConsumer(consumer)) {
            this.fileManager.clearDomainObject(this.getPathname());
            throw new IllegalStateException("Domain Object is closed: " + domainObj.getName());
        }
        return domainObj;
    }

    @Override
    public DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getFileData().getDomainObject(consumer, okToUpgrade, okToRecover, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public DomainObject getReadOnlyDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getFileData().getReadOnlyDomainObject(consumer, version, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public DomainObject getImmutableDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getFileData().getImmutableDomainObject(consumer, version, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public void save(TaskMonitor monitor) throws IOException, CancelledException {
        DomainObjectAdapter dobj = this.fileManager.getOpenedDomainObject(this.getPathname());
        if (dobj == null) {
            throw new AssertException("Cannot save, domainObj not open");
        }
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException("Cannot save to read-only project");
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Cannot save to read-only file");
        }
        dobj.save(null, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public boolean canSave() {
        DomainObjectAdapter dobj = this.fileManager.getOpenedDomainObject(this.getPathname());
        if (dobj == null) {
            return false;
        }
        return dobj.canSave();
    }

    @Override
    public boolean canRecover() {
        try {
            return this.getFileData().canRecover();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean takeRecoverySnapshot() throws IOException {
        return this.getFileData().takeRecoverySnapshot();
    }

    @Override
    public boolean isInWritableProject() {
        return !this.fileSystem.isReadOnly();
    }

    @Override
    public long getLastModifiedTime() {
        try {
            return this.getFileData().getLastModifiedTime();
        }
        catch (IOException e) {
            this.fileError(e);
            return 0L;
        }
    }

    @Override
    public Icon getIcon(boolean disabled) {
        try {
            return this.getFileData().getIcon(disabled);
        }
        catch (IOException e) {
            this.fileError(e);
            return GhidraFileData.UNSUPPORTED_FILE_ICON;
        }
    }

    @Override
    public boolean isCheckedOut() {
        try {
            return this.getFileData().isCheckedOut();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean isCheckedOutExclusive() {
        try {
            return this.getFileData().isCheckedOutExclusive();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean modifiedSinceCheckout() {
        try {
            return this.getFileData().modifiedSinceCheckout();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean canCheckout() {
        try {
            return this.getFileData().canCheckout();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean canCheckin() {
        try {
            return this.getFileData().canCheckin();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean canMerge() {
        try {
            return this.getFileData().canMerge();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean canAddToRepository() {
        try {
            return this.getFileData().canAddToRepository();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public void setReadOnly(boolean state) throws IOException {
        this.getFileData().setReadOnly(state);
    }

    @Override
    public boolean isReadOnly() {
        try {
            return this.getFileData().isReadOnly();
        }
        catch (IOException e) {
            this.fileError(e);
            return true;
        }
    }

    @Override
    public boolean isVersionControlSupported() {
        try {
            return this.getFileData().isVersionControlSupported();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean isVersioned() {
        try {
            return this.getFileData().isVersioned();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public boolean isHijacked() {
        try {
            return this.getFileData().isHijacked();
        }
        catch (IOException e) {
            this.fileError(e);
            return false;
        }
    }

    @Override
    public int getLatestVersion() {
        try {
            return this.getFileData().getLatestVersion();
        }
        catch (IOException e) {
            this.fileError(e);
            return 0;
        }
    }

    @Override
    public boolean isLatestVersion() {
        return true;
    }

    @Override
    public int getVersion() {
        try {
            return this.getFileData().getVersion();
        }
        catch (IOException e) {
            this.fileError(e);
            return -1;
        }
    }

    @Override
    public Version[] getVersionHistory() throws IOException {
        return this.getFileData().getVersionHistory();
    }

    @Override
    public void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        this.getFileData().addToVersionControl(comment, keepCheckedOut, monitor);
    }

    @Override
    public boolean checkout(boolean exclusive, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getFileData().checkout(exclusive, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public void checkin(CheckinHandler checkinHandler, boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getFileData().checkin(checkinHandler, okToUpgrade, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public void merge(boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getFileData().merge(okToUpgrade, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public void undoCheckout(boolean keep) throws IOException {
        this.getFileData().undoCheckout(keep, false);
    }

    @Override
    public void terminateCheckout(long checkoutId) throws IOException {
        this.getFileData().terminateCheckout(checkoutId);
    }

    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        return this.getFileData().getCheckouts();
    }

    @Override
    public ItemCheckoutStatus getCheckoutStatus() throws IOException {
        return this.getFileData().getCheckoutStatus();
    }

    @Override
    public void delete() throws IOException {
        this.getFileData().delete();
    }

    @Override
    public void delete(int version) throws IOException {
        this.getFileData().delete(version);
    }

    @Override
    public GhidraFile moveTo(DomainFolder newParent) throws IOException {
        GhidraFolder newGhidraParent = (GhidraFolder)newParent;
        return this.getFileData().moveTo(newGhidraParent.getFolderData());
    }

    @Override
    public DomainFile copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        GhidraFolder newGhidraParent = (GhidraFolder)newParent;
        return this.getFileData().copyTo(newGhidraParent.getFolderData(), monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public DomainFile copyVersionTo(int version, DomainFolder destFolder, TaskMonitor monitor) throws IOException, CancelledException {
        GhidraFolder destGhidraFolder = (GhidraFolder)destFolder;
        return this.getFileData().copyVersionTo(version, destGhidraFolder.getFolderData(), monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    void convertToPrivateFile(TaskMonitor monitor) throws IOException, CancelledException {
        this.getFileData().convertToPrivateFile(monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public ArrayList<?> getConsumers() {
        DomainObjectAdapter dobj = this.fileManager.getOpenedDomainObject(this.getPathname());
        if (dobj == null) {
            return new ArrayList();
        }
        return dobj.getConsumerList();
    }

    @Override
    public boolean isChanged() {
        DomainObjectAdapter dobj = this.fileManager.getOpenedDomainObject(this.getPathname());
        return dobj != null && dobj.isChanged();
    }

    @Override
    public boolean isOpen() {
        return this.fileManager.getOpenedDomainObject(this.getPathname()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return this.getFileData().isBusy();
            }
            catch (IOException e) {
                this.fileError(e);
            }
        }
        return false;
    }

    @Override
    public void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        this.getFileData().packFile(file, monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR);
    }

    @Override
    public Map<String, String> getMetadata() {
        try {
            return this.getFileData().getMetadata();
        }
        catch (IOException e) {
            this.fileError(e);
            return new HashMap<String, String>();
        }
    }

    void fileChanged() {
        try {
            this.getFileData().getParent().fileChanged(this.name);
        }
        catch (IOException e) {
            this.fileError(e);
        }
    }

    @Override
    public long length() throws IOException {
        return this.getFileData().length();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GhidraFile)) {
            return false;
        }
        GhidraFile other = (GhidraFile)obj;
        if (this.fileManager != other.fileManager) {
            return false;
        }
        return this.getPathname().equals(other.getPathname());
    }

    public int hashCode() {
        return this.getPathname().hashCode();
    }

    public String toString() {
        return this.fileManager.getProjectLocator().getName() + ":" + this.getPathname();
    }
}

