/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.VersionHistoryPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.store.FileSystem;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

public class VersionHistoryDialog
extends DialogComponentProvider
implements ProjectListener {
    private VersionHistoryPanel versionPanel;
    private MyFolderListener listener = new MyFolderListener();
    private List<DockingActionIf> popupActions = Collections.emptyList();

    public VersionHistoryDialog(DomainFile domainFile) {
        super("Version History", false);
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        this.setHelpLocation(new HelpLocation("VersionControl", "Show_History"));
        this.versionPanel = new VersionHistoryPanel(frontEndTool, domainFile, true);
        this.addWorkPanel(this.versionPanel);
        this.addDismissButton();
        this.setDomainFile(domainFile);
        this.popupActions = this.versionPanel.createPopupActions();
    }

    private void setDomainFile(DomainFile df) {
        this.versionPanel.setDomainFile(df);
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        frontEndTool.addProjectListener(this);
        Project project = frontEndTool.getProject();
        if (project != null && df != null) {
            this.setTitle("Version History for " + df.getName());
            project.getProjectData().addDomainFolderChangeListener(this.listener);
        }
    }

    protected void dialogShown() {
        super.dialogShown();
        for (DockingActionIf action : this.popupActions) {
            this.addAction(action);
        }
    }

    protected void dialogClosed() {
        super.dialogClosed();
        for (DockingActionIf action : this.popupActions) {
            this.removeAction(action);
        }
    }

    @Override
    public void projectClosed(Project project) {
        this.dismissCallback();
    }

    @Override
    public void projectOpened(Project project) {
    }

    public ActionContext getActionContext(MouseEvent event) {
        ActionContext actionContext = new ActionContext(null, (Object)this, (Component)this.versionPanel.getTable());
        actionContext.setMouseEvent(event);
        return actionContext;
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        @Override
        public void stateChanged(String affectedNewPath, String affectedOldPath, boolean isFolder) {
            String path = VersionHistoryDialog.this.versionPanel.getDomainFilePath();
            if (path == null || affectedOldPath == null) {
                return;
            }
            if (isFolder) {
                if (path.startsWith((String)(affectedOldPath = (String)affectedOldPath + FileSystem.SEPARATOR)) && !VersionHistoryDialog.this.versionPanel.getDomainFile().exists()) {
                    VersionHistoryDialog.this.dismissCallback();
                }
            } else if (((String)affectedOldPath).equals(path)) {
                if (affectedNewPath == null) {
                    VersionHistoryDialog.this.dismissCallback();
                } else {
                    VersionHistoryDialog.this.versionPanel.refresh();
                }
            }
        }

        @Override
        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            if (file.equals(VersionHistoryDialog.this.versionPanel.getDomainFile())) {
                VersionHistoryDialog.this.versionPanel.refresh();
            }
        }

        @Override
        public void domainFileRemoved(DomainFolder parentFolder, String name, String fileID) {
            DomainFile domainFile = VersionHistoryDialog.this.versionPanel.getDomainFile();
            if (parentFolder.equals(domainFile.getParent()) && domainFile.getName().equals(name)) {
                SwingUtilities.invokeLater(() -> VersionHistoryDialog.this.dismissCallback());
            }
        }
    }
}

