/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.dnd.GenericDataFlavor;
import ghidra.framework.main.datatree.VersionInfo;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class VersionInfoTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localVersionInfoFlavor = VersionInfoTransferable.createLocalVersionInfoFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localVersionInfoFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private VersionInfo versionInfo;

    private static DataFlavor createLocalVersionInfoFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=\"" + VersionInfo.class.getName() + "\"", "Local DomainFile Version object");
        }
        catch (Exception e) {
            Msg.showError(VersionInfoTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    VersionInfoTransferable(String domainFilePath, int version) {
        this.versionInfo = new VersionInfo(domainFilePath, version);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(localVersionInfoFlavor)) {
            return this.versionInfo;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public String toString() {
        return "VersionInfoTransferable";
    }
}

