/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.DropDownMultiSelectionChoiceListener;
import docking.widgets.DropDownSelectionChoiceListener;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;

public class DropDownMultiSelectionTextField<T>
extends DropDownSelectionTextField<T> {
    private JList<String> previewList;
    private List<T> selectedValues = new ArrayList<T>();
    private WeakSet<DropDownMultiSelectionChoiceListener<T>> choiceListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public DropDownMultiSelectionTextField(DropDownTextFieldDataModel<T> dataModel) {
        super(dataModel);
    }

    @Override
    public void addDropDownSelectionChoiceListener(DropDownMultiSelectionChoiceListener<T> listener) {
        this.choiceListeners.add(listener);
    }

    @Override
    public void addDropDownSelectionChoiceListener(DropDownSelectionChoiceListener<T> listener) {
        throw new UnsupportedOperationException("Please use the flavor of this method that takes a DropDownMultiSelectionChoiceListener instance.");
    }

    public List<T> getSelectedValues() {
        return this.selectedValues;
    }

    @Override
    protected ListSelectionModel createListSelectionModel() {
        DefaultListSelectionModel model = new DefaultListSelectionModel();
        model.setSelectionMode(2);
        return model;
    }

    @Override
    protected void setPreviewPaneAttributes() {
        if (this.previewList == null) {
            this.previewList = new JList();
        }
        this.previewList.setOpaque(true);
        this.previewList.setBackground(TOOLTIP_WINDOW_BGCOLOR);
        this.previewList.setFocusable(false);
        this.previewList.setModel(new DefaultListModel());
    }

    @Override
    protected boolean hasPreview() {
        return this.previewList.getModel().getSize() > 0;
    }

    @Override
    protected ListSelectionListener getPreviewListener() {
        return new PreviewListener();
    }

    @Override
    protected JComponent getPreviewPaneComponent() {
        return this.previewList;
    }

    @Override
    protected void setTextFromList() {
        List selectedItems = this.list.getSelectedValuesList();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            this.storeSelectedValues(selectedItems);
            String allValues = this.getSelectionText();
            this.setText(allValues);
            this.hideMatchingWindow();
            this.fireUserChoiceMade(selectedItems);
        }
    }

    @Override
    public void setSelectedValue(T value) {
        ArrayList<T> values = new ArrayList<T>();
        values.add(value);
        this.storeSelectedValues(values);
        if (value != null) {
            this.setText(this.dataModel.getDisplayText(value));
            this.setToolTipText(this.dataModel.getDescription(value));
        } else {
            this.setText("");
            this.setToolTipText("");
        }
    }

    @Override
    protected void setTextFromSelectedListItemAndKeepMatchingWindowOpen() {
        List selectedItems = this.list.getSelectedValuesList();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            this.internallyDrivenUpdate = true;
            this.storeSelectedValues(selectedItems);
            String allValues = this.getSelectedText();
            this.setTextWithoutClosingCompletionWindow(allValues);
            this.fireUserChoiceMade(selectedItems);
        }
    }

    private String getSelectionText() {
        ArrayList<String> values = new ArrayList<String>();
        for (T t : this.selectedValues) {
            values.add(this.dataModel.getDisplayText(t));
        }
        return StringUtils.join(values.iterator(), (String)",");
    }

    private void fireUserChoiceMade(List<T> selectedItems) {
        for (DropDownMultiSelectionChoiceListener listener : this.choiceListeners) {
            listener.selectionChanged(selectedItems);
        }
    }

    private void storeSelectedValues(List<T> newValues) {
        this.selectedValues.clear();
        this.selectedValues.addAll(newValues);
    }

    private class PreviewListener
    implements ListSelectionListener {
        private PreviewListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                DefaultListModel model = (DefaultListModel)DropDownMultiSelectionTextField.this.previewList.getModel();
                model.clear();
                List values = DropDownMultiSelectionTextField.this.list.getSelectedValuesList();
                for (Object value : values) {
                    model.addElement(DropDownMultiSelectionTextField.this.dataModel.getDescription(value));
                }
            }
        }
    }
}

