/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.RangeColumnConstraint;
import docking.widgets.table.constraint.provider.DateColumnConstraintProvider;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DateSpinner;
import docking.widgets.table.constrainteditor.DateValueConstraintEditor;
import docking.widgets.table.constrainteditor.LocalDateSpinnerModel;
import docking.widgets.textfield.LocalDateTextField;
import ghidra.util.layout.VerticalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DateRangeConstraintEditor
extends AbstractColumnConstraintEditor<LocalDate> {
    private DateSpinner lowerSpinner;
    private LocalDateSpinnerModel lowerSpinnerModel;
    private DateSpinner upperSpinner;
    private LocalDateSpinnerModel upperSpinnerModel;
    private JLabel infoLabel;
    private String errorMessage;
    private static final DateTimeFormatter LOCAL_DATE_FORMAT = DateValueConstraintEditor.LOCAL_DATE_FORMAT;
    private final ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
    private final LocalDate oneYearAgo = LocalDate.now().minusYears(1L);
    private final LocalDate minDate = LocalDate.of(this.now.getYear(), 1, 1).minusYears(30L);
    private final LocalDate maxDate = LocalDate.of(this.now.getYear(), 12, 31).plusYears(30L);

    public DateRangeConstraintEditor(ColumnConstraint<LocalDate> constraint) {
        super(constraint);
        if (!DateRangeConstraintEditor.isValidDate(this.getConstraint().getMinValue())) {
            this.reset();
        }
    }

    private void initLowerSpinner(LocalDate value, LocalDate rangeMin, LocalDate rangeMax) {
        this.lowerSpinnerModel = new LocalDateSpinnerModel(value, rangeMin, rangeMax, 5);
        this.lowerSpinner = new DateSpinner(this.lowerSpinnerModel, "MM/dd/yyyy");
        this.lowerSpinner.getSpinner().setName("lower.date.spinner");
        this.lowerSpinner.addChangeListener(e -> this.valueChanged());
    }

    private void initUpperSpinner(LocalDate value, LocalDate rangeMin, LocalDate rangeMax) {
        this.upperSpinnerModel = new LocalDateSpinnerModel(value, rangeMin, rangeMax, 5);
        this.upperSpinner = new DateSpinner(this.upperSpinnerModel, "MM/dd/yyyy");
        this.upperSpinner.getSpinner().setName("upper.date.spinner");
        this.upperSpinner.addChangeListener(e -> this.valueChanged());
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(2));
        LocalDate minValue = this.getConstraint().getMinValue();
        LocalDate maxValue = this.getConstraint().getMaxValue();
        this.initLowerSpinner(minValue, this.minDate, this.maxDate);
        this.initUpperSpinner(maxValue, this.minDate, this.maxDate);
        JPanel controlPanel = new JPanel(new GridLayout(1, 2));
        controlPanel.add(this.lowerSpinner.getSpinner());
        controlPanel.add(this.upperSpinner.getSpinner());
        panel.add(controlPanel);
        this.infoLabel = new GDHtmlLabel();
        this.infoLabel.setForeground(Color.GRAY);
        this.infoLabel.setHorizontalAlignment(0);
        panel.add(this.infoLabel);
        return panel;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        if (isValid) {
            LocalDate start = this.lowerSpinnerModel.getDate();
            LocalDate end = this.upperSpinnerModel.getDate();
            long days = ChronoUnit.DAYS.between(start, end) + 1L;
            this.infoLabel.setText(DateRangeConstraintEditor.formatStatus(String.format("Range Size: %,d days", days), false));
        } else {
            this.infoLabel.setText(DateRangeConstraintEditor.formatStatus(this.getErrorMessage(), true));
        }
    }

    private static boolean isValidDate(LocalDate date) {
        if (date == null) {
            return false;
        }
        if (date == DateColumnConstraintProvider.DEFAULT_DATE) {
            return false;
        }
        return date.toEpochDay() != DateColumnConstraintProvider.DEFAULT_DATE.toEpochDay();
    }

    @Override
    protected ColumnConstraint<LocalDate> getValueFromComponent() {
        LocalDate modelMin = this.lowerSpinnerModel.getDate();
        LocalDate modelMax = this.upperSpinnerModel.getDate();
        return this.getConstraint().copy(modelMin, modelMax);
    }

    @Override
    protected void updateEditorComponent() {
        LocalDate minValue = this.getConstraint().getMinValue();
        this.lowerSpinnerModel.setValue(minValue);
        LocalDate maxValue = this.getConstraint().getMaxValue();
        this.upperSpinnerModel.setValue(maxValue);
        this.valueChanged();
    }

    @Override
    public void reset() {
        LocalDate minVal = this.oneYearAgo;
        LocalDate maxVal = LocalDate.now();
        this.setValue(this.getConstraint().copy(minVal, maxVal));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        LocalDate uVal;
        boolean isValidLower = DateRangeConstraintEditor.hasValidValue(this.lowerSpinner);
        boolean isValidUpper = DateRangeConstraintEditor.hasValidValue(this.upperSpinner);
        DateRangeConstraintEditor.markSpinnerAsValid(this.lowerSpinner, isValidLower);
        DateRangeConstraintEditor.markSpinnerAsValid(this.upperSpinner, isValidUpper);
        this.errorMessage = "";
        if (!isValidLower && !isValidUpper) {
            this.errorMessage = "Invalid lower and upper bounds!";
            return false;
        }
        if (!isValidLower) {
            this.errorMessage = "Invalid lower bounds!";
            return false;
        }
        if (!isValidUpper) {
            this.errorMessage = "Invalid upper bounds!";
            return false;
        }
        LocalDate lVal = (LocalDate)this.lowerSpinnerModel.getValue();
        if (lVal.compareTo(uVal = (LocalDate)this.upperSpinnerModel.getValue()) > 0) {
            this.errorMessage = "Upper bounds value must be greater than lower bounds!";
            return false;
        }
        return true;
    }

    private static boolean hasValidValue(DateSpinner spinner) {
        LocalDateTextField textField = spinner.getDateField();
        String text = textField.getTextField().getText();
        LocalDate value = (LocalDate)spinner.getSpinner().getValue();
        String valueString = value.format(LOCAL_DATE_FORMAT);
        return valueString.equals(text);
    }

    private static void markSpinnerAsValid(DateSpinner spinner, boolean valid) {
        spinner.getDateField().getTextField().setBackground(valid ? VALID_INPUT_COLOR : INVALID_INPUT_COLOR);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private RangeColumnConstraint<LocalDate> getConstraint() {
        return (RangeColumnConstraint)this.currentConstraint;
    }
}

