/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class DepthFirstIterator
implements Iterator<GTreeNode> {
    private GTreeNode root;
    private GTreeNode next;
    private GTreeNode lastNode;
    private final GTree tree;
    private final long mod;

    public DepthFirstIterator(GTree tree, GTreeNode node) {
        this.tree = tree;
        this.root = node;
        this.next = node;
        this.mod = tree.getModificationID();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public GTreeNode next() {
        this.checkForConcurrentModification();
        this.lastNode = this.next;
        this.next = this.findNext(this.next);
        return this.lastNode;
    }

    private void checkForConcurrentModification() {
        if (this.tree.getModificationID() != this.mod) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        this.checkForConcurrentModification();
        GTreeNode parent = this.lastNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Can't delete root node!");
        }
        parent.removeNode(this.lastNode);
    }

    private GTreeNode findNext(GTreeNode node) {
        if (node.getChildCount() > 0) {
            return node.getChild(0);
        }
        while (node != this.root) {
            GTreeNode parent = node.getParent();
            int nextIndexInParent = node.getIndexInParent() + 1;
            if (nextIndexInParent < parent.getChildCount()) {
                return parent.getChild(nextIndexInParent);
            }
            node = parent;
        }
        return null;
    }
}

