/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeFilter;
import docking.widgets.tree.tasks.GTreeClearTreeFilterTask;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import docking.widgets.tree.tasks.GTreeRestoreTreeStateTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class GTreeFilterTask
extends GTreeTask {
    private final GTreeNode node;
    private final GTreeFilter filter;
    private final GTreeState defaultRestoreState;
    private boolean cancelledProgramatically;

    public GTreeFilterTask(GTree tree, GTreeNode node, GTreeFilter filter) {
        super(tree);
        this.node = node;
        this.filter = filter;
        this.defaultRestoreState = tree.getTreeState();
    }

    public void run(TaskMonitor monitor) {
        block4: {
            if (this.filter == null) {
                this.node.clearFilter();
                this.restoreInSameTask(monitor);
                return;
            }
            monitor.setMessage("Filtering...");
            monitor.initialize(1000000000L);
            try {
                this.node.filter(this.filter, monitor, 0, 1000000000);
                if (this.filter.showFilterMatches()) {
                    this.expandInSameTask(monitor);
                    this.restoreInSameTask(monitor);
                }
            }
            catch (CancelledException e) {
                if (this.cancelledProgramatically) break block4;
                this.tree.runTask(new GTreeClearTreeFilterTask(this.tree));
            }
        }
    }

    private void expandInSameTask(TaskMonitor monitor) {
        GTreeExpandAllTask expandTask = new GTreeExpandAllTask(this.tree, this.node);
        expandTask.run(monitor);
    }

    private void restoreInSameTask(TaskMonitor monitor) {
        GTreeState existingState = this.tree.getRestoreTreeState();
        GTreeState state = existingState == null ? this.defaultRestoreState : existingState;
        GTreeRestoreTreeStateTask restoreTask = new GTreeRestoreTreeStateTask(this.tree, state);
        restoreTask.run(monitor);
    }

    public void cancel() {
        this.cancelledProgramatically = true;
        super.cancel();
    }
}

