/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class BeginningOfLineAction
extends TextAction {
    public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(36, 0);
    private static final String ACTION_NAME = "caret-begin-line";

    public BeginningOfLineAction() {
        super(ACTION_NAME);
    }

    private void error(Component component) {
        UIManager.getLookAndFeel().provideErrorFeedback(component);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent component = this.getTextComponent(e);
        if (component == null) {
            return;
        }
        try {
            int dot = component.getCaretPosition();
            int startPosition = Utilities.getRowStart(component, dot);
            component.setCaretPosition(startPosition);
        }
        catch (BadLocationException bl) {
            this.error(component);
        }
    }
}

