/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.ChompingBitsAnimationPanel;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import ghidra.util.timer.GTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TaskDialog
extends DialogComponentProvider
implements TaskMonitor {
    private static final int SLEEPY_TIME = 10;
    private static final int MAX_DELAY = 200000;
    public static final int DEFAULT_WIDTH = 275;
    private Timer showTimer;
    private AtomicInteger taskID = new AtomicInteger();
    private Runnable closeDialog;
    private Component centerOnComp;
    private Runnable shouldCancelRunnable;
    private boolean taskDone;
    private JPanel mainPanel;
    private JPanel activityPanel;
    private TaskMonitorComponent monitorComponent;
    private AtomicReference<String> newMessage = new AtomicReference();
    private SwingUpdateManager messageUpdater = new SwingUpdateManager(100, 250, () -> this.setStatusText(this.newMessage.getAndSet(null)));

    public TaskDialog(Component centerOnComp, Task task) {
        this(centerOnComp, task.getTaskTitle(), task.isModal(), task.canCancel(), task.hasProgress());
    }

    public TaskDialog(Task task) {
        this(task.getTaskTitle(), task.canCancel(), task.isModal(), task.hasProgress());
    }

    public TaskDialog(String title, boolean canCancel, boolean isModal, boolean hasProgress) {
        this(null, title, isModal, canCancel, hasProgress);
    }

    private TaskDialog(Component centerOnComp, String title, boolean isModal, boolean canCancel, boolean hasProgress) {
        super(title, isModal, true, canCancel, true);
        this.centerOnComp = centerOnComp;
        this.setup(canCancel, hasProgress);
    }

    private void setup(boolean canCancel, boolean hasProgress) {
        this.monitorComponent = new TaskMonitorComponent(false, false);
        this.activityPanel = new ChompingBitsAnimationPanel();
        this.setCancelEnabled(canCancel);
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.setTransient(true);
        this.closeDialog = () -> {
            this.close();
            this.dispose();
        };
        this.shouldCancelRunnable = () -> {
            int currentTaskID = this.taskID.get();
            boolean doCancel = this.promptToVerifyCancel();
            if (doCancel && currentTaskID == this.taskID.get()) {
                this.cancel();
            }
        };
        this.mainPanel = new JPanel(new BorderLayout());
        this.addWorkPanel(this.mainPanel);
        if (hasProgress) {
            this.installProgressMonitor();
        } else {
            this.installActivityDisplay();
        }
        if (canCancel) {
            this.addCancelButton();
        }
        this.setHelpLocation(new HelpLocation("Tool", "TaskDialog"));
    }

    private boolean promptToVerifyCancel() {
        boolean userSaysYes = OptionDialog.showYesNoDialog(this.getComponent(), "Cancel?", "Do you really want to cancel \"" + this.getTitle() + "\"?") == 1;
        return userSaysYes;
    }

    private void installProgressMonitor() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            this.mainPanel.removeAll();
            this.mainPanel.add((Component)this.monitorComponent, "Center");
            this.repack();
        });
    }

    private void installActivityDisplay() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            this.mainPanel.removeAll();
            this.mainPanel.add((Component)this.activityPanel, "Center");
            this.repack();
        });
    }

    @Override
    protected void dialogShown() {
        if (this.isCompleted()) {
            this.close();
        }
    }

    @Override
    protected void dialogClosed() {
        this.close();
    }

    @Override
    protected void cancelCallback() {
        SwingUtilities.invokeLater(this.shouldCancelRunnable);
    }

    @Override
    public void setCancelEnabled(boolean enable) {
        this.monitorComponent.setCancelEnabled(enable);
        Swing.runLater(() -> super.setCancelEnabled(enable));
    }

    @Override
    public boolean isCancelEnabled() {
        return this.monitorComponent.isCancelEnabled();
    }

    public synchronized void taskProcessed() {
        this.taskDone = true;
        this.monitorComponent.notifyChangeListeners();
        SwingUtilities.invokeLater(this.closeDialog);
    }

    public synchronized void reset() {
        this.taskDone = false;
        this.taskID.incrementAndGet();
    }

    public synchronized boolean isCompleted() {
        return this.taskDone;
    }

    public void show(int delay) {
        if (this.isModal()) {
            this.doShowModal(delay);
        } else {
            this.doShowNonModal(delay);
        }
    }

    private void doShowModal(int delay) {
        this.giveTheTaskThreadAChanceToComplete(delay);
        if (this.isCompleted()) {
            return;
        }
        this.doShow();
    }

    private void doShowNonModal(int delay) {
        GTimer.scheduleRunnable((long)delay, () -> {
            if (this.isCompleted()) {
                return;
            }
            this.doShow();
        });
    }

    protected void doShow() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> DockingWindowManager.showDialog(this.centerOnComp, this));
    }

    private void giveTheTaskThreadAChanceToComplete(int delay) {
        delay = Math.min(delay, 200000);
        for (int elapsedTime = 0; !this.isCompleted() && elapsedTime < delay; elapsedTime += 10) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        Runnable disposeTask = () -> {
            if (this.showTimer != null) {
                this.showTimer.stop();
                this.showTimer = null;
            }
        };
        SystemUtilities.runSwingNow((Runnable)disposeTask);
    }

    public void setMessage(String str) {
        this.newMessage.set(str);
        this.messageUpdater.update();
    }

    public String getMessage() {
        return this.getStatusText();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.monitorComponent.setShowProgressValue(showProgressValue);
    }

    public void setProgress(long progress) {
        this.monitorComponent.setProgress(progress);
    }

    public void initialize(long max) {
        if (this.monitorComponent.isIndeterminate()) {
            return;
        }
        if (!this.monitorComponent.isShowing()) {
            this.installProgressMonitor();
        }
        this.monitorComponent.initialize(max);
    }

    public void setMaximum(long max) {
        this.monitorComponent.setMaximum(max);
    }

    public long getMaximum() {
        return this.monitorComponent.getMaximum();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.monitorComponent.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.monitorComponent.isIndeterminate();
    }

    public boolean isCancelled() {
        return this.monitorComponent.isCancelled();
    }

    public synchronized void cancel() {
        if (this.monitorComponent.isCancelled()) {
            return;
        }
        this.monitorComponent.cancel();
    }

    public synchronized void clearCanceled() {
        this.monitorComponent.clearCanceled();
    }

    public void checkCanceled() throws CancelledException {
        this.monitorComponent.checkCanceled();
    }

    public void incrementProgress(long incrementAmount) {
        this.monitorComponent.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.monitorComponent.getProgress();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.monitorComponent.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.monitorComponent.removeCancelledListener(listener);
    }
}

