/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.HashMap;
import java.util.Map;

class PerQueryCache {
    private final Map map = new HashMap();
    private static final ThreadLocal CACHE = new ThreadLocal();

    private PerQueryCache() {
    }

    static PerQueryCache getInstance() {
        PerQueryCache cache = (PerQueryCache)CACHE.get();
        if (cache == null) {
            cache = new PerQueryCache();
            CACHE.set(cache);
        }
        return cache;
    }

    Object get(Class type, Object key) {
        return this.map.get(new Key(type, key));
    }

    Object put(Class type, Object key, Object value) {
        return this.map.put(new Key(type, key), value);
    }

    void dispose() {
        CACHE.set(null);
    }

    private static final class Key {
        private final Class type;
        private final Object key;

        private Key(Class type, Object key) {
            this.type = type;
            this.key = key;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.type == other.type && this.key.equals(other.key);
            }
            return false;
        }
    }
}

