/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PropContainer
implements XmlSerializable,
DavConstants {
    private static Logger log = LoggerFactory.getLogger((Class)PropContainer.class);

    public abstract boolean addContent(Object var1);

    public abstract boolean isEmpty();

    public abstract int getContentSize();

    public abstract Collection getContent();

    public abstract boolean contains(DavPropertyName var1);

    public Element toXml(Document document) {
        Element prop = DomUtil.createElement(document, "prop", NAMESPACE);
        Iterator it = this.getContent().iterator();
        while (it.hasNext()) {
            Object content = it.next();
            if (content instanceof XmlSerializable) {
                prop.appendChild(((XmlSerializable)content).toXml(document));
                continue;
            }
            log.debug("Unexpected content in PropContainer: should be XmlSerializable.");
        }
        return prop;
    }
}

