/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;

public class CreateFolderCommand
implements Command {
    private String name;
    private String statusMsg;
    private String parentName;
    private String treeName;

    public CreateFolderCommand(String treeName, String name, String parentName) {
        this.treeName = treeName;
        this.name = name;
        this.parentName = parentName;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        Listing listing = program.getListing();
        ProgramModule m = listing.getModule(this.treeName, this.parentName);
        if (m == null) {
            this.statusMsg = "Folder named " + this.parentName + " does not exist";
            return false;
        }
        try {
            m.createModule(this.name);
            return true;
        }
        catch (DuplicateNameException e) {
            this.statusMsg = this.name + " already exists";
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Create Folder";
    }
}

