/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HTMLUtilities;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;

public class DataTypeCellRenderer
extends GTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private DataTypeManager originalDTM;

    public DataTypeCellRenderer(DataTypeManager originalDataTypeManager) {
        this.originalDTM = originalDataTypeManager;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        String dtString = "";
        String tooltipText = null;
        boolean useRed = false;
        DataType dt = null;
        if (value instanceof DataTypeInstance) {
            dt = ((DataTypeInstance)value).getDataType();
            tooltipText = this.getDataTypeToolTip(dt);
            dtString = dt.getDisplayName();
            if (dt.isNotYetDefined()) {
                useRed = true;
            }
        }
        GTableCellRenderingData renderData = data.copyWithNewValue((Object)dtString);
        JLabel c = (JLabel)super.getTableCellRendererComponent(renderData);
        c.setToolTipText(tooltipText);
        if (useRed) {
            c.setForeground(Color.RED);
        }
        return c;
    }

    private String getDataTypeToolTip(DataType dataType) {
        boolean localSource;
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        boolean bl = localSource = sourceArchive == null || dataTypeManager != null && SystemUtilities.isEqual((Object)dataTypeManager.getUniversalID(), (Object)sourceArchive.getSourceArchiveID());
        if (localSource) {
            sourceArchive = this.originalDTM.getSourceArchive(this.originalDTM.getUniversalID());
        }
        DataType foundDataType = this.originalDTM.getDataType(dataType.getDataTypePath());
        Object displayName = "";
        if (foundDataType != null && dataTypeManager != null) {
            displayName = dataTypeManager.getName();
        }
        displayName = (String)displayName + dataType.getPathName();
        if (!localSource) {
            displayName = (String)displayName + "  (" + sourceArchive.getName() + ")";
        }
        displayName = HTMLUtilities.friendlyEncodeHTML((String)displayName);
        String toolTipText = ToolTipUtils.getToolTipText(dataType);
        String headerText = "<HTML><b>" + (String)displayName + "</b><BR>";
        toolTipText = toolTipText.replace("<HTML>", headerText);
        return toolTipText;
    }
}

