/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.SignedDWordDataType;
import ghidra.program.model.data.SignedQWordDataType;
import ghidra.program.model.data.SignedWordDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import utilities.util.ArrayUtilities;

public abstract class AbstractScalarOperandHover
extends AbstractConfigurableHover {
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF;
    private static final Settings[] INTEGER_SETTINGS = new Settings[]{AbstractScalarOperandHover.getSettingsForRadix("hex"), AbstractScalarOperandHover.getSettingsForRadix("decimal")};
    private static final AbstractIntegerDataType[] INTEGER_DISPLAY_TYPES = new AbstractIntegerDataType[]{new ByteDataType(), new WordDataType(), new SignedWordDataType(), new DWordDataType(), new SignedDWordDataType(), new QWordDataType(), new SignedQWordDataType()};

    private static Settings getSettingsForRadix(String radix) {
        SettingsImpl s = new SettingsImpl();
        FORMAT.setDisplayChoice((Settings)s, radix);
        return s;
    }

    public AbstractScalarOperandHover(PluginTool tool, int priority) {
        super(tool, priority);
    }

    private void formatIntegerTypes(Program program, Address addr, Scalar scalar, StringBuilder htmlText) {
        ByteMemBufferImpl memBuffer = this.getScalarOperandAsMemBuffer(addr, scalar, 1, Endian.BIG);
        StringBuilder sb = new StringBuilder();
        for (AbstractIntegerDataType abstractIntegerDataType : INTEGER_DISPLAY_TYPES) {
            if (abstractIntegerDataType.getLength() != memBuffer.getLength()) continue;
            ArrayList<String> reprs = new ArrayList<String>();
            for (Settings setting : INTEGER_SETTINGS) {
                String repr = abstractIntegerDataType.getRepresentation((MemBuffer)memBuffer, setting, abstractIntegerDataType.getLength());
                if (repr.equals("??")) {
                    repr = HTMLUtilities.HTML_SPACE;
                }
                reprs.add(repr);
            }
            AbstractScalarOperandHover.addReprRow(sb, abstractIntegerDataType.getDisplayName(), reprs);
        }
        if (sb.length() > 0) {
            htmlText.append("<table><tr><th nowrap>&nbsp;</th>");
            for (AbstractIntegerDataType abstractIntegerDataType : INTEGER_SETTINGS) {
                Object radixName = FORMAT.getDisplayChoice((Settings)abstractIntegerDataType);
                radixName = Character.toTitleCase(((String)radixName).charAt(0)) + ((String)radixName).substring(1);
                htmlText.append("<th nowrap>").append((String)radixName).append("</th>");
            }
            htmlText.append("</tr>");
            htmlText.append((CharSequence)sb);
            htmlText.append("</table>");
        }
    }

    private void formatCharTypes(Program program, Address addr, Scalar scalar, StringBuilder htmlText) {
        List<DataType> charDataTypes = Arrays.asList(new CharDataType(program.getDataTypeManager()), new WideChar16DataType(program.getDataTypeManager()), new WideChar32DataType(program.getDataTypeManager()));
        String prevCharVal = "";
        StringBuilder localHTMLText = new StringBuilder();
        Endian progEndian = program.getMemory().isBigEndian() ? Endian.BIG : Endian.LITTLE;
        for (DataType charDt : charDataTypes) {
            ByteMemBufferImpl charMemBuffer = this.getScalarOperandAsMemBuffer(addr, scalar, charDt.getLength(), progEndian);
            prevCharVal = this.appendCharDataTypeFormattedHTML(prevCharVal, charDt, charMemBuffer, localHTMLText);
        }
        if (localHTMLText.length() > 0) {
            htmlText.append("<hr>");
            htmlText.append("<table width=\"100%\">").append((CharSequence)localHTMLText).append("</table>");
        }
    }

    private String appendCharDataTypeFormattedHTML(String prevCharVal, DataType charDt, ByteMemBufferImpl charMemBuffer, StringBuilder htmlText) {
        if (charMemBuffer.getLength() >= charDt.getLength()) {
            boolean shouldSkip;
            String charRep;
            StringDataInstance sdi = StringDataInstance.getStringDataInstance((DataType)charDt, (MemBuffer)charMemBuffer, (Settings)SettingsImpl.NO_SETTINGS, (int)charMemBuffer.getLength());
            boolean isArray = charMemBuffer.getLength() >= charDt.getLength() * 2;
            String charVal = sdi.getStringValue();
            String string = charRep = isArray ? sdi.getStringRepresentation() : sdi.getCharRepresentation();
            boolean bl = prevCharVal.equals(charVal) || !charRep.contains(isArray ? "\"" : "'") || this.hasEncodingError(charVal) ? true : (shouldSkip = false);
            if (!shouldSkip) {
                htmlText.append("<tr><td>").append(charDt.getName()).append(isArray ? "[]" : "");
                if (charMemBuffer.getLength() > 1) {
                    htmlText.append(" <b>" + (charMemBuffer.isBigEndian() ? Endian.BIG : Endian.LITTLE).toShortString() + "</b>");
                }
                htmlText.append("</td><td>").append(HTMLUtilities.friendlyEncodeHTML((String)charRep)).append("</td></tr>");
                prevCharVal = charVal;
            }
        }
        return prevCharVal;
    }

    private void formatAsAddressVal(Program program, Address addr, Scalar scalar, StringBuilder htmlText) {
        Address asAddress;
        long scalarLong = scalar.getValue();
        AddressFactory factory = program.getAddressFactory();
        AddressSpace space = factory.getDefaultAddressSpace();
        try {
            asAddress = factory.getAddress(space.getBaseSpaceID(), scalarLong);
        }
        catch (AddressOutOfBoundsException ex) {
            asAddress = null;
        }
        Memory memory = program.getMemory();
        if (asAddress != null && memory.contains(asAddress)) {
            Symbol primary;
            htmlText.append("<hr>");
            htmlText.append("<table>");
            AbstractScalarOperandHover.addReprRow(htmlText, "Address", asAddress.toString());
            Data data = program.getListing().getDataContaining(asAddress);
            if (data != null && (primary = data.getPrimarySymbol()) != null) {
                AbstractScalarOperandHover.addReprRow(htmlText, "Symbol", HTMLUtilities.italic((String)HTMLUtilities.friendlyEncodeHTML((String)primary.getName())));
            }
            htmlText.append("</table>");
        }
    }

    protected String formatScalar(Program program, Address addr, Scalar scalar) {
        StringBuilder sb = new StringBuilder("<HTML>");
        this.formatIntegerTypes(program, addr, scalar, sb);
        this.formatCharTypes(program, addr, scalar, sb);
        this.formatAsAddressVal(program, addr, scalar, sb);
        return sb.toString();
    }

    private boolean hasEncodingError(String s) {
        return s.codePoints().anyMatch(codePoint -> StringUtilities.isUnicodeReplacementCodePoint((int)codePoint));
    }

    private ByteMemBufferImpl getScalarOperandAsMemBuffer(Address addr, Scalar scalar, int minTrimLen, Endian endian) {
        byte[] operandBytes = scalar.byteArrayValue();
        if (minTrimLen > 0) {
            operandBytes = AbstractScalarOperandHover.trimLeadingZeros(operandBytes, minTrimLen);
        }
        if (endian == Endian.LITTLE) {
            operandBytes = ArrayUtilities.reverse((byte[])operandBytes);
        }
        return new ByteMemBufferImpl(addr, operandBytes, endian == Endian.BIG);
    }

    private static byte[] trimLeadingZeros(byte[] bytes, int minTrimLen) {
        int firstUsedByteIndex;
        for (firstUsedByteIndex = 0; firstUsedByteIndex < bytes.length && bytes[firstUsedByteIndex] == 0; ++firstUsedByteIndex) {
        }
        int bytesToCopy = bytes.length - firstUsedByteIndex;
        int newLen = Math.max(bytesToCopy, minTrimLen);
        if (newLen > 1) {
            newLen += newLen % 2;
        }
        byte[] newBytes = new byte[newLen];
        System.arraycopy(bytes, firstUsedByteIndex, newBytes, newLen - bytesToCopy, bytesToCopy);
        return newBytes;
    }

    private static void addReprRow(StringBuilder sb, String typeName, String repr) {
        AbstractScalarOperandHover.addReprRow(sb, typeName, Arrays.asList(repr));
    }

    private static void addReprRow(StringBuilder sb, String typeName, Iterable<String> reprs) {
        sb.append("<tr><td nowrap style=\"text-align: left;\">").append(typeName).append("</td>");
        for (String repr : reprs) {
            sb.append("<td nowrap style=\"text-align: right;\">").append(repr).append("</td>");
        }
        sb.append("</tr>");
    }

    @Override
    protected boolean isValidTooltipContent(String content) {
        return content != null && content.length() >= "<HTML>".length();
    }
}

