/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.util;

import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.SelectionModeWidget;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstructionSearchUtils {
    public static String toBinaryString(byte byteval) {
        StringBuilder sb = new StringBuilder("00000000");
        for (int bit = 0; bit < 8; ++bit) {
            if ((byteval >> bit & 1) <= 0) continue;
            sb.setCharAt(7 - bit, '1');
        }
        return sb.toString();
    }

    public static boolean isBinary(String input) {
        input = input.replaceAll("\\s", "");
        return input.matches("[01]+");
    }

    public static String toBinary(String hex) {
        hex = hex.replaceAll("\\s", "");
        String[] byteStrs = hex.split("(?<=\\G.{2})");
        Object retString = "";
        for (String byteStr : byteStrs) {
            int bint = Integer.parseInt(byteStr, 16);
            String bin = Integer.toBinaryString(bint);
            bin = InstructionSearchUtils.padZeros(bin);
            retString = (String)retString + bin;
        }
        return retString;
    }

    public static boolean isHex(String input) {
        input = input.replaceAll("\\s", "");
        return input.matches("[0-9a-fA-F]+");
    }

    public static boolean isFullHexByte(String input) {
        String text = input.replaceAll("\\s", "");
        return text.length() % 2 == 0;
    }

    public static boolean isFullBinaryByte(String input) {
        String text = input.replaceAll("\\s", "");
        return text.length() % 8 == 0;
    }

    public static boolean containsOnBit(byte[] bytearray) {
        for (byte element : bytearray) {
            int value = element & 0xFF;
            if (value == 0) continue;
            return true;
        }
        return false;
    }

    public static String toBinaryStr(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            String s1 = String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
            sb.append(s1);
        }
        return sb.toString();
    }

    public static String formatSearchString(String searchStr, String mask) throws InvalidInputException {
        Object retStr = "";
        if (searchStr.length() != mask.length()) {
            throw new InvalidInputException("mask and search string not the same length.");
        }
        for (int i = 0; i < searchStr.length(); ++i) {
            char valChar = searchStr.charAt(i);
            char maskChar = mask.charAt(i);
            retStr = valChar == '1' ? (String)retStr + "1" : (valChar == '0' && maskChar == '1' ? (String)retStr + "0" : (valChar == '0' && maskChar == '0' ? (String)retStr + "." : (String)retStr + "0"));
        }
        return retStr;
    }

    public static byte[] byteArrayOr(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length];
        if (arr1.length != arr2.length) {
            return null;
        }
        for (int x = 0; x < arr1.length; ++x) {
            result[x] = (byte)(arr1[x] | arr2[x]);
        }
        return result;
    }

    public static byte[] byteArrayAnd(byte[] mask, byte[] bytes) {
        byte[] result = new byte[bytes.length];
        if (mask.length != bytes.length) {
            throw new IllegalArgumentException("inappropriate mask");
        }
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)(mask[i] & bytes[i]);
        }
        return result;
    }

    public static String toHex(String binaryStr, boolean zeroFill) {
        String[] instrBytes;
        StringBuilder sb = new StringBuilder();
        binaryStr = binaryStr.replaceAll("\\s", "");
        binaryStr = InstructionSearchUtils.addSpaceOnByteBoundary(binaryStr, SelectionModeWidget.InputMode.BINARY);
        for (String binary : instrBytes = binaryStr.split("\\s")) {
            if (binary.contains(".")) {
                sb.append("[").append(binary).append("]").append(" ");
                continue;
            }
            int decimal = Integer.parseInt(binary, 2);
            Object hex = Integer.toString(decimal, 16);
            if (zeroFill && ((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex).append(" ");
        }
        return sb.toString();
    }

    public static StringBuilder toHexNibblesOnly(String instr) {
        String[] instrBytes;
        StringBuilder sb = new StringBuilder();
        instr = InstructionSearchUtils.addSpaceOnByteBoundary(instr, SelectionModeWidget.InputMode.BINARY);
        for (String binary : instrBytes = instr.split(" ")) {
            if (binary.contains(".")) {
                int decimal;
                String nibble1 = binary.substring(0, 4);
                String nibble2 = binary.substring(4, 8);
                if (nibble1.contains(".")) {
                    nibble1 = ".";
                } else {
                    decimal = Integer.parseInt(nibble1, 2);
                    nibble1 = Integer.toString(decimal, 16);
                }
                if (nibble2.contains(".")) {
                    nibble2 = ".";
                } else {
                    decimal = Integer.parseInt(nibble2, 2);
                    nibble2 = Integer.toString(decimal, 16);
                }
                sb.append(nibble1).append(nibble2).append(" ");
                continue;
            }
            int decimal = Integer.parseInt(binary, 2);
            Object hex = Integer.toString(decimal, 16);
            if (((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex).append(" ");
        }
        return sb;
    }

    public static List<Integer> getGroupSizes(String source, SelectionModeWidget.InputMode mode) throws Exception {
        String[] groups;
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int modeSize = mode == SelectionModeWidget.InputMode.BINARY ? 8 : 2;
        for (String group : groups = source.trim().split("\\s+")) {
            if (group.length() < modeSize || group.length() % modeSize != 0) {
                throw new Exception("input is not a full byte(s)");
            }
            sizes.add(group.length() / modeSize);
        }
        return sizes;
    }

    public static List<String> getWhitespace(String source) {
        ArrayList<String> spaces = new ArrayList<String>();
        Pattern whitespace = Pattern.compile("\\s+");
        Matcher matcher = whitespace.matcher(source);
        while (matcher.find()) {
            spaces.add(matcher.group());
        }
        return spaces;
    }

    public static List<Byte> toByteArray(String byteStr) {
        String[] byteStrs = byteStr.split("(?<=\\G.{8})");
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (String byteStr2 : byteStrs) {
            int bint = Integer.parseInt(byteStr2, 2);
            byte newbyte = (byte)bint;
            bytes.add(new Byte(newbyte));
        }
        return bytes;
    }

    public static byte[] toPrimitive(Byte[] bytes) {
        byte[] retList = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            retList[i] = bytes[i];
        }
        return retList;
    }

    public static String addSpaceOnByteBoundary(String str, SelectionModeWidget.InputMode mode) {
        StringBuilder sb = new StringBuilder();
        str = str.replaceAll("\\s", "");
        int byteLength = 0;
        if (mode == SelectionModeWidget.InputMode.HEX) {
            byteLength = 2;
        }
        if (mode == SelectionModeWidget.InputMode.BINARY) {
            byteLength = 8;
        }
        for (int i = 0; i < str.length(); ++i) {
            sb.append(str.charAt(i));
            if ((i + 1) % byteLength != 0) continue;
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public static List<Address> toAddressList(List<InstructionMetadata> searchResults) {
        ArrayList<Address> results = new ArrayList<Address>();
        for (InstructionMetadata meta : searchResults) {
            results.add(meta.getAddr());
        }
        return results;
    }

    public static InstructionSearchPlugin getInstructionSearchPlugin(PluginTool tool) {
        List plugins = tool.getManagedPlugins();
        for (Plugin plugin : plugins) {
            if (!(plugin instanceof InstructionSearchPlugin)) continue;
            return (InstructionSearchPlugin)plugin;
        }
        return null;
    }

    private static String padZeros(String binStr) {
        String retString = binStr;
        if (binStr.length() < 8) {
            int diff = 8 - binStr.length();
            for (int i = 0; i < diff; ++i) {
                retString = "0".concat(retString);
            }
        }
        return retString;
    }
}

