/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.dnd.GClipboard;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeActionManager;
import ghidra.app.plugin.core.programtree.TreeTransferable;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class PasteManager {
    private ProgramTreeActionManager actionMgr;
    private ProgramDnDTree tree;
    private DefaultTreeModel treeModel;
    private Clipboard cutClipboard;
    private String lastGroupPasted;

    PasteManager(ProgramTreeActionManager actionMgr) {
        this.actionMgr = actionMgr;
        this.cutClipboard = actionMgr.getCutClipboard();
    }

    boolean isPasteAllowed(ProgramNode destNode, ProgramNode pasteNode, boolean isCutOperation) {
        if (destNode.getProgram() != pasteNode.getProgram() || destNode.getRoot() != pasteNode.getRoot()) {
            return false;
        }
        try {
            if (destNode.getName().equals(pasteNode.getName())) {
                return false;
            }
            if (destNode.isNodeAncestor(pasteNode)) {
                return false;
            }
            if (destNode.isFragment() && pasteNode.isModule()) {
                return isCutOperation && !pasteNode.getModule().isDescendant(destNode.getFragment());
            }
            if (destNode.isFragment() && pasteNode.isFragment()) {
                return isCutOperation;
            }
            if (destNode.isModule()) {
                ProgramModule destModule = destNode.getModule();
                if (pasteNode.isModule()) {
                    if (pasteNode.getModule().isDescendant(destModule)) {
                        return false;
                    }
                    if (!isCutOperation && destModule.contains(pasteNode.getModule())) {
                        return false;
                    }
                } else if (!isCutOperation && destModule.contains(pasteNode.getFragment())) {
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paste(ProgramNode destNode) {
        int transactionID = this.tree.startTransaction("Paste");
        if (transactionID < 0) {
            return;
        }
        TreePath path = destNode.getTreePath();
        Clipboard systemClipboard = GClipboard.getSystemClipboard();
        Transferable t = systemClipboard.getContents(this.tree);
        try {
            if (t == null || !t.isDataFlavorSupported(TreeTransferable.localTreeNodeFlavor)) {
                return;
            }
            this.tree.setBusyCursor(true);
            this.lastGroupPasted = null;
            ArrayList list = (ArrayList)t.getTransferData(TreeTransferable.localTreeNodeFlavor);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                ProgramNode tnode = (ProgramNode)list.get(i);
                if (destNode.getRoot() != tnode.getRoot()) {
                    this.lastGroupPasted = null;
                    break;
                }
                if (destNode.getName().equals(tnode.getName()) || !this.pasteGroup(destNode, tnode) || destNode.isFragment() && tnode.isModule()) continue;
                this.lastGroupPasted = tnode.getName();
            }
            if (this.lastGroupPasted == null) {
                this.tree.setBusyCursor(false);
            }
            this.actionMgr.checkClipboard(true);
            this.actionMgr.clearSystemClipboard();
            this.actionMgr.enablePasteAction(false);
            this.tree.removeSelectionPath(path);
            this.tree.addSelectionPath(path);
        }
        catch (UnsupportedFlavorException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)"Data flavor in clipboard is not supported.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, null, null, (Throwable)e);
        }
        finally {
            this.tree.endTransaction(transactionID, true);
        }
    }

    String getLastGroupPasted() {
        return this.lastGroupPasted;
    }

    void setProgramTreeView(ProgramDnDTree tree) {
        this.tree = tree;
        this.treeModel = (DefaultTreeModel)tree.getModel();
    }

    private boolean pasteGroup(ProgramNode destNode, ProgramNode nodeToPaste) {
        if (destNode.isFragment()) {
            try {
                this.tree.mergeGroup(nodeToPaste.getGroup(), destNode.getFragment());
                this.actionMgr.removeFromClipboard(this.cutClipboard, nodeToPaste);
                return true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, null, (Object)"Error Merging Fragments", (Throwable)e);
            }
            return false;
        }
        ProgramModule targetModule = destNode.getModule();
        if (targetModule == null) {
            nodeToPaste.setDeleted(false);
            this.treeModel.reload(nodeToPaste);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)("Paste of " + nodeToPaste + " at\n" + destNode.getName() + " is not allowed."));
            return false;
        }
        return this.pasteNode(destNode, nodeToPaste);
    }

    private boolean pasteNode(ProgramNode destNode, ProgramNode nodeToPaste) {
        ProgramModule targetModule = destNode.getModule();
        ProgramModule module = nodeToPaste.getModule();
        ProgramFragment fragment = nodeToPaste.getFragment();
        if (module == null && fragment == null) {
            nodeToPaste.setDeleted(false);
            this.treeModel.reload(nodeToPaste);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)("Could not paste " + nodeToPaste + " at " + targetModule.getName()));
            return false;
        }
        boolean pasteOK = false;
        try {
            ProgramNode newnode;
            pasteOK = module != null ? this.pasteModule(destNode, nodeToPaste, targetModule, module) : this.pasteFragment(nodeToPaste, targetModule, fragment);
            if (this.tree.isExpanded(destNode.getTreePath()) && (newnode = this.tree.getChild(destNode, nodeToPaste.getName())) != null) {
                this.tree.matchExpansionState(nodeToPaste, newnode);
            }
            return pasteOK;
        }
        catch (CircularDependencyException e) {
            this.removeFromClipboard(nodeToPaste);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)e.getMessage());
        }
        catch (DuplicateGroupException e) {
            nodeToPaste.setDeleted(false);
            this.tree.reloadNode(nodeToPaste);
        }
        catch (NotFoundException e) {
            this.removeFromClipboard(nodeToPaste);
            nodeToPaste.setDeleted(false);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)e.getMessage());
        }
        return false;
    }

    private boolean pasteFragment(ProgramNode nodeToPaste, ProgramModule targetModule, ProgramFragment fragment) throws NotFoundException, DuplicateGroupException {
        boolean pasteOK = false;
        if (targetModule.contains(fragment)) {
            if (targetModule.equals(nodeToPaste.getParentModule())) {
                this.removeFromClipboard(nodeToPaste);
            }
        } else if (this.actionMgr.clipboardContains(nodeToPaste)) {
            targetModule.reparent(nodeToPaste.getName(), nodeToPaste.getParentModule());
            this.removeFromClipboard(nodeToPaste);
            pasteOK = true;
        } else {
            targetModule.add(fragment);
            pasteOK = true;
        }
        return pasteOK;
    }

    private boolean pasteModule(ProgramNode destNode, ProgramNode nodeToPaste, ProgramModule targetModule, ProgramModule module) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        boolean pasteOK = false;
        if (!destNode.wasVisited()) {
            this.tree.visitNode(destNode);
        }
        if (targetModule.contains(module)) {
            if (targetModule.equals(nodeToPaste.getParentModule())) {
                this.removeFromClipboard(nodeToPaste);
            }
        } else if (this.actionMgr.clipboardContains(nodeToPaste)) {
            targetModule.reparent(nodeToPaste.getName(), nodeToPaste.getParentModule());
            this.removeFromClipboard(nodeToPaste);
            pasteOK = true;
        } else {
            targetModule.add(module);
            pasteOK = true;
        }
        if (pasteOK && this.tree.isExpanded(destNode.getTreePath())) {
            this.tree.groupAdded((Group)module);
        }
        return pasteOK;
    }

    private void removeFromClipboard(ProgramNode node) {
        this.actionMgr.removeFromClipboard(this.cutClipboard, node);
        node.setDeleted(false);
        this.tree.reloadNode(node);
    }
}

