/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTablePropertyMap
extends CliAbstractTable {
    public CliTablePropertyMap(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliPropertyMapRow(this.readTableIndex(reader, CliTypeTable.TypeDef), this.readTableIndex(reader, CliTypeTable.Property)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "PropertyMap Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "Parent", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Property), "options", "Index into Property table. Points to contiguous run of Properties until next ref from PropertyMap or end of table.");
        return rowDt;
    }

    public class CliPropertyMapRow
    extends CliAbstractTableRow {
        public int parentIndex;
        public int propertyListIndex;

        public CliPropertyMapRow(int parentIndex, int propertyListIndex) {
            this.parentIndex = parentIndex;
            this.propertyListIndex = propertyListIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Parent %s Properties %x", CliTablePropertyMap.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.parentIndex), this.propertyListIndex);
        }
    }
}

