/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import docking.options.editor.ButtonPanelFactory;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeDropDownSelectionDataModel;
import ghidra.app.util.datatype.NavigationDirection;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.CancelledException;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;

public class DataTypeSelectionEditor
extends AbstractCellEditor {
    private JPanel editorPanel;
    private DropDownSelectionTextField<DataType> selectionField;
    private JButton browseButton;
    private DataTypeManagerService dataTypeManagerService;
    private int maxSize = -1;
    private DataTypeManager dataTypeManager;
    private DataTypeParser.AllowedDataTypes allowedDataTypes;
    private KeyAdapter keyListener;
    private NavigationDirection navigationDirection;
    private TreePath initiallySelectedTreePath;

    public DataTypeSelectionEditor(ServiceProvider serviceProvider, int maxSize, DataTypeParser.AllowedDataTypes allowedDataTypes) {
        this((DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class), maxSize, allowedDataTypes);
    }

    public DataTypeSelectionEditor(DataTypeManagerService service, int maxSize, DataTypeParser.AllowedDataTypes allowedDataTypes) {
        if (service == null) {
            throw new NullPointerException("DataTypeManagerService cannot be null");
        }
        this.dataTypeManagerService = service;
        this.maxSize = maxSize;
        this.allowedDataTypes = allowedDataTypes;
        this.init();
    }

    public void setPreferredDataTypeManager(DataTypeManager dataTypeManager) {
        this.dataTypeManager = dataTypeManager;
    }

    public void setConsumeEnterKeyPress(boolean consume) {
        this.selectionField.setConsumeEnterKeyPress(consume);
    }

    private void init() {
        this.selectionField = new DropDownSelectionTextField((DropDownTextFieldDataModel)new DataTypeDropDownSelectionDataModel(this.dataTypeManagerService));
        this.selectionField.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                DataTypeSelectionEditor.this.fireEditingCanceled();
                DataTypeSelectionEditor.this.navigationDirection = null;
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                DataTypeSelectionEditor.this.fireEditingStopped();
                DataTypeSelectionEditor.this.navigationDirection = null;
            }
        });
        this.selectionField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.browseButton = ButtonPanelFactory.createButton((int)2);
        this.browseButton.setToolTipText("Browse the Data Manager");
        this.browseButton.addActionListener(e -> this.showDataTypeBrowser());
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 0));
        this.editorPanel.add((Component)this.selectionField);
        this.editorPanel.add(Box.createHorizontalStrut(5));
        this.editorPanel.add(this.browseButton);
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 9) {
                    DataTypeSelectionEditor.this.navigationDirection = e.isShiftDown() ? NavigationDirection.BACKWARD : NavigationDirection.FORWARD;
                    DataTypeSelectionEditor.this.fireEditingStopped();
                    e.consume();
                }
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        return this.selectionField.getSelectedValue();
    }

    public DataType getCellEditorValueAsDataType() {
        try {
            if (this.validateUserSelection()) {
                return (DataType)this.selectionField.getSelectedValue();
            }
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            // empty catch block
        }
        return null;
    }

    public String getCellEditorValueAsText() {
        return this.selectionField.getText();
    }

    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    public DropDownSelectionTextField<DataType> getDropDownTextField() {
        return this.selectionField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public void setDefaultSelectedTreePath(TreePath path) {
        this.initiallySelectedTreePath = path;
    }

    public void requestFocus() {
        this.selectionField.requestFocus();
    }

    void selectCellEditorValue() {
        this.selectionField.selectAll();
    }

    public void setCellEditorValue(DataType dataType) {
        this.selectionField.setSelectedValue((Object)dataType);
        this.navigationDirection = null;
    }

    public void setCellEditorValueAsText(String text) {
        this.selectionField.setText(text);
        this.navigationDirection = null;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().removeDocumentListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.selectionField.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.selectionField.removeFocusListener(listener);
    }

    public void setTabCommitsEdit(boolean doesCommit) {
        this.selectionField.setFocusTraversalKeysEnabled(!doesCommit);
        this.removeKeyListener(this.keyListener);
        if (doesCommit) {
            this.addKeyListener(this.keyListener);
        }
    }

    public NavigationDirection getNavigationDirection() {
        return this.navigationDirection;
    }

    private void addKeyListener(KeyListener listener) {
        this.selectionField.addKeyListener(listener);
    }

    private void removeKeyListener(KeyListener listener) {
        this.selectionField.removeKeyListener(listener);
    }

    public boolean validateUserSelection() throws InvalidDataTypeException {
        if (!this.isValidDataType()) {
            return this.parseDataTypeTextEntry();
        }
        return true;
    }

    public boolean containsValidDataType() {
        try {
            return this.isValidDataType();
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
    }

    private boolean isValidDataType() throws InvalidDataTypeException {
        DataType selectedDataType = (DataType)this.selectionField.getSelectedValue();
        if (selectedDataType != null && this.selectionField.getText().equals(selectedDataType.getName())) {
            DataTypeParser.ensureIsAllowableType(selectedDataType, this.allowedDataTypes);
            return true;
        }
        return false;
    }

    private DataType getDataTypeRootForCurrentText() {
        DataType selectedBaseDataType;
        String currentText;
        DataType dataType = (DataType)this.selectionField.getSelectedValue();
        if (dataType != null && (currentText = this.selectionField.getText()).startsWith((selectedBaseDataType = DataTypeUtils.getNamedBaseDataType(dataType)).getName())) {
            return selectedBaseDataType;
        }
        return null;
    }

    private boolean parseDataTypeTextEntry() throws InvalidDataTypeException {
        if (this.selectionField.getText().trim().length() == 0) {
            return false;
        }
        DataType newDataType = null;
        DataTypeParser parser = new DataTypeParser(this.dataTypeManager, this.dataTypeManager, this.dataTypeManagerService, this.allowedDataTypes);
        try {
            newDataType = parser.parse(this.selectionField.getText(), this.getDataTypeRootForCurrentText());
        }
        catch (CancelledException e) {
            return false;
        }
        if (newDataType != null) {
            if (this.maxSize >= 0 && newDataType.getLength() > newDataType.getLength()) {
                throw new InvalidDataTypeException("data-type larger than " + this.maxSize + " bytes");
            }
            this.selectionField.setSelectedValue((Object)newDataType);
            return true;
        }
        return false;
    }

    private void showDataTypeBrowser() {
        DataType dataType = this.dataTypeManagerService.getDataType(this.initiallySelectedTreePath);
        if (dataType != null) {
            this.setCellEditorValue(dataType);
            this.selectionField.requestFocus();
        }
    }
}

