/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.coff.AoutHeader;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffMachineType;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandlerFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CoffLoader
extends AbstractLibrarySupportLoader {
    public static final String COFF_NAME = "Common Object File Format (COFF)";
    public static final String FAKE_LINK_OPTION_NAME = "Attempt to link sections located at 0x0";
    static final boolean FAKE_LINK_OPTION_DEFAULT = true;
    private static final int COFF_NULL_SANITY_CHECK_LEN = 64;
    private static final int EMPTY_START_OFFSET = 8192;
    private static final long MIN_BYTE_LENGTH = 22L;
    private static final int ALIGNMENT = 256;

    public boolean isMicrosoftFormat() {
        return false;
    }

    private boolean isVisualStudio(CoffFileHeader header) {
        List<CoffSectionHeader> sections = header.getSections();
        for (CoffSectionHeader section : sections) {
            String name = section.getName();
            if (!name.startsWith(".drectve") && !name.startsWith(".debug$S")) continue;
            return true;
        }
        return false;
    }

    private boolean isCLI(CoffFileHeader header) {
        return header.getSections().stream().anyMatch(s -> s.getName().startsWith(".cormeta"));
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 22L) {
            return loadSpecs;
        }
        CoffFileHeader header = new CoffFileHeader(provider);
        if (header.getMagic() == 0 && provider.length() > 64L) {
            byte[] headerBytes = provider.readBytes(0L, 64L);
            boolean allZeros = true;
            for (byte b : headerBytes) {
                boolean bl = allZeros = b == 0;
                if (!allZeros) break;
            }
            if (allZeros) {
                return loadSpecs;
            }
        }
        if (CoffMachineType.isMachineTypeDefined(header.getMagic())) {
            header.parseSectionHeaders(provider);
            if (this.isVisualStudio(header) != this.isMicrosoftFormat()) {
                return loadSpecs;
            }
            String secondary = this.isCLI(header) ? "cli" : null;
            List<QueryResult> results = QueryOpinionService.query(this.getName(), header.getMachineName(), secondary);
            Object object = results.iterator();
            while (object.hasNext()) {
                QueryResult result = (QueryResult)object.next();
                loadSpecs.add(new LoadSpec((Loader)this, header.getImageBase(true), result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, header.getImageBase(false), true));
            }
        }
        return loadSpecs;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(FAKE_LINK_OPTION_NAME, true));
        }
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(FAKE_LINK_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    private boolean performFakeLinking(List<Option> options) {
        boolean performFakeLinking = true;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(FAKE_LINK_OPTION_NAME)) continue;
                performFakeLinking = (Boolean)option.getValue();
            }
        }
        return performFakeLinking;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        boolean performFakeLinking = this.performFakeLinking(options);
        CoffFileHeader header = new CoffFileHeader(provider);
        header.parse(provider, monitor);
        HashMap<CoffSectionHeader, Address> sectionsMap = new HashMap<CoffSectionHeader, Address>();
        HashMap<CoffSymbol, Symbol> symbolsMap = new HashMap<CoffSymbol, Symbol>();
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
        int id = program.startTransaction("loading program from COFF");
        boolean success = false;
        try {
            this.processSectionHeaders(provider, header, program, fileBytes, monitor, log, sectionsMap, performFakeLinking);
            this.processSymbols(header, program, monitor, log, sectionsMap, symbolsMap);
            this.processEntryPoint(header, program, monitor, log);
            this.processRelocations(header, program, sectionsMap, symbolsMap, log, monitor);
            success = true;
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
        finally {
            program.endTransaction(id, success);
        }
    }

    private void processEntryPoint(CoffFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        AoutHeader optionalHeader = header.getOptionalHeader();
        if (optionalHeader != null) {
            int lentry = optionalHeader.getEntry();
            try {
                Address entry = CoffSectionHeader.getAddress(program.getLanguage(), (long)lentry, program.getLanguage().getDefaultSpace());
                program.getSymbolTable().addExternalEntryPoint(entry);
                program.getSymbolTable().createLabel(entry, "entry", SourceType.IMPORTED);
            }
            catch (Exception e) {
                log.appendMsg("Unable to create entry point symbol at " + Integer.toHexString(lentry));
                log.appendMsg("\t" + e.getMessage());
            }
        }
    }

    private void processSymbols(CoffFileHeader header, Program program, TaskMonitor monitor, MessageLog log, Map<CoffSectionHeader, Address> sectionsMap, Map<CoffSymbol, Symbol> symbolsMap) {
        Address externalAddress = this.findFreeAddress(program);
        if (externalAddress == null) {
            log.appendMsg("Serious problem, there is no memory at all for symbols!");
            return;
        }
        Address externalAddressStart = externalAddress;
        SymbolTable symbolTable = program.getSymbolTable();
        List<CoffSymbol> symbols = header.getSymbols();
        monitor.setMessage("Creating Symbols");
        block9: for (CoffSymbol symbol : symbols) {
            if (monitor.isCancelled()) break;
            if (symbol.isSection()) continue;
            Address address = null;
            try {
                short sectionNum = symbol.getSectionNumber();
                if (sectionNum == 0) {
                    address = externalAddress;
                    String name = symbol.getName();
                    Symbol sym = symbolTable.getGlobalSymbol(name, address);
                    if (sym == null) {
                        sym = symbolTable.createLabel(externalAddress, name, SourceType.IMPORTED);
                    }
                    symbolsMap.put(symbol, sym);
                    externalAddress = externalAddress.add((long)this.getPointerSizeAligned(externalAddress.getAddressSpace()));
                    continue;
                }
                if (sectionNum <= -2) {
                    log.appendMsg("Strange symbol " + symbol + " : " + symbol.getBasicType() + " - from section " + sectionNum);
                    continue;
                }
                CoffSectionHeader section = null;
                if (sectionNum == -1) {
                    address = CoffSectionHeader.getAddress(program.getLanguage(), symbol.getValue(), program.getLanguage().getDefaultDataSpace());
                } else {
                    section = header.getSections().get(sectionNum - 1);
                    Address sectionStartAddr = sectionsMap.get(section);
                    if (sectionStartAddr == null) {
                        log.appendMsg("Unable to process symbol " + symbol.getName() + " : " + symbol.getBasicType() + " - could not locate related section.");
                        continue;
                    }
                    address = CoffSectionHeader.getAddress(program.getLanguage(), symbol.getValue(), section);
                }
                Object symName = symbol.getName();
                switch (symbol.getStorageClass()) {
                    case 100: {
                        symName = "BLOCK_" + (String)symName;
                        break;
                    }
                    case 101: {
                        continue block9;
                    }
                    case 102: {
                        symName = "EOS_" + (String)symName;
                        break;
                    }
                    case 103: {
                        symName = "FILE_" + (String)symName;
                        break;
                    }
                    case 104: {
                        symName = "LINE_" + (String)symName;
                        break;
                    }
                }
                Symbol existingSym = symbolTable.getPrimarySymbol(address);
                String name = symbol.getName();
                Symbol sym = symbolTable.getGlobalSymbol(name, address);
                if (sym == null) {
                    sym = symbolTable.createLabel(address, name, SourceType.IMPORTED);
                }
                if (existingSym == null || !existingSym.isPrimary() || symbol.getStorageClass() == 2) {
                    sym.setPrimary();
                }
                if (symbol.getDerivedType(1) == 2 && symbol.getStorageClass() != 3) {
                    symbolTable.addExternalEntryPoint(address);
                    this.createOneByteFunction(program, sym.getName(), address);
                }
                symbolsMap.put(symbol, sym);
            }
            catch (Exception e) {
                log.appendMsg("Unable to create symbol " + symbol.getName() + " at 0x" + Long.toHexString(symbol.getValue()));
            }
        }
        this.createExternalBlock(program, monitor, log, externalAddress, externalAddressStart);
    }

    private void createExternalBlock(Program program, TaskMonitor monitor, MessageLog log, Address externalAddress, Address externalAddressStart) {
        if (!externalAddressStart.equals((Object)externalAddress)) {
            long size = externalAddress.subtract(externalAddressStart);
            try {
                MemoryBlock block = program.getMemory().createUninitializedBlock("EXTERNAL", externalAddressStart, size, false);
                block.setWrite(true);
                Address current = externalAddressStart;
                while (current.compareTo((Object)externalAddress) < 0) {
                    this.createUndefined(program.getListing(), program.getMemory(), current, externalAddress.getAddressSpace().getPointerSize());
                    current = current.add((long)externalAddress.getAddressSpace().getPointerSize());
                }
            }
            catch (Exception e) {
                log.appendMsg("Error creating external memory block:  - " + e.getMessage());
            }
        }
    }

    private Data createUndefined(Listing listing, Memory memory, Address addr, int size) throws CodeUnitInsertionException, DataTypeConflictException {
        MemoryBlock block = memory.getBlock(addr);
        if (block == null || !block.isInitialized()) {
            return null;
        }
        DataType undefined = Undefined.getUndefinedDataType((int)size);
        return listing.createData(addr, undefined);
    }

    private Address findFreeAddress(Program program) {
        MemoryBlock[] blocks;
        Memory memory = program.getMemory();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address maxAddr = memory.getMinAddress();
        if (maxAddr == null) {
            return null;
        }
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            Address blockEnd = block.getEnd().getPhysicalAddress();
            if (blockEnd.compareTo((Object)maxAddr) <= 0) continue;
            maxAddr = blockEnd;
        }
        Address externAddress = null;
        long newOffset = maxAddr.getOffset() % (long)this.getPointerSizeAligned(space);
        newOffset = (long)this.getPointerSizeAligned(space) - newOffset;
        maxAddr = maxAddr.getPhysicalAddress();
        externAddress = maxAddr.add(newOffset += 4096L);
        return externAddress;
    }

    private int getPointerSizeAligned(AddressSpace space) {
        int pointerSizeUnaligned = space.getPointerSize();
        if (pointerSizeUnaligned <= 8) {
            return 8;
        }
        if (pointerSizeUnaligned <= 16) {
            return 16;
        }
        if (pointerSizeUnaligned <= 32) {
            return 32;
        }
        if (pointerSizeUnaligned <= 64) {
            return 64;
        }
        return pointerSizeUnaligned;
    }

    private void processSectionHeaders(ByteProvider provider, CoffFileHeader header, Program program, FileBytes fileBytes, TaskMonitor monitor, MessageLog log, Map<CoffSectionHeader, Address> map, boolean performFakeLinking) throws AddressOverflowException, IOException {
        monitor.setMessage("Process sections...");
        Language language = program.getLanguage();
        List<CoffSectionHeader> sections = header.getSections();
        if (performFakeLinking) {
            this.possiblyRelocateSections(program, header, map);
        }
        int sectionNumber = 0;
        for (CoffSectionHeader section : sections) {
            ++sectionNumber;
            if (monitor.isCancelled()) break;
            MemoryBlock block = null;
            int sectionSize = section.getSize(language);
            Address sectionAddr = section.getPhysicalAddress(language);
            if (sectionSize == 0 || section.getFlags() == 0) {
                log.appendMsg("Empty Section, Created Symbol: " + section.getName());
                block = program.getMemory().getBlock(sectionAddr);
                try {
                    program.getSymbolTable().createLabel(sectionAddr, section.getName(), SourceType.IMPORTED);
                }
                catch (InvalidInputException invalidInputException) {}
            } else if (!section.isAllocated()) {
                block = this.createInitializedBlock(provider, program, fileBytes, monitor, log, language, sectionNumber, section, sectionSize, sectionAddr, true);
                if (block != null) {
                    log.appendMsg("Created Overlay Block: " + section + " @ " + sectionAddr);
                }
            } else if (section.isUninitializedData()) {
                block = MemoryBlockUtils.createUninitializedBlock(program, false, section.getName(), sectionAddr, sectionSize, "PhysAddr:0x" + Integer.toHexString(section.getPhysicalAddress()) + " Size:0x" + Integer.toHexString(sectionSize) + " Flags:0x" + Integer.toHexString(section.getFlags()), null, section.isReadable(), section.isWritable(), section.isExecutable(), log);
                if (block != null) {
                    log.appendMsg("Created Uninitialized Block: " + section + " @ " + sectionAddr);
                }
            } else {
                block = this.createInitializedBlock(provider, program, fileBytes, monitor, log, language, sectionNumber, section, sectionSize, sectionAddr, false);
                if (block != null) {
                    log.appendMsg("Created Initialized Block: " + section + " @ " + sectionAddr);
                }
            }
            if (block != null) {
                sectionAddr = block.getStart();
            }
            map.put(section, sectionAddr);
        }
    }

    private MemoryBlock createInitializedBlock(ByteProvider provider, Program program, FileBytes fileBytes, TaskMonitor monitor, MessageLog log, Language language, int sectionNumber, CoffSectionHeader section, int sectionSize, Address sectionAddr, boolean isOverlay) throws AddressOverflowException, IOException {
        MemoryBlock block;
        block10: {
            Object name = section.getName();
            if (isOverlay) {
                name = (String)name + "-" + sectionNumber;
            }
            block = null;
            try {
                if (section.isProcessedBytes(language)) {
                    try (InputStream dataStream = section.getRawDataStream(provider, language);){
                        block = MemoryBlockUtils.createInitializedBlock(program, isOverlay, (String)name, sectionAddr, dataStream, (long)sectionSize, "PhysAddr:0x" + Integer.toHexString(section.getPhysicalAddress()) + " Size:0x" + Integer.toHexString(sectionSize) + " Flags:0x" + Integer.toHexString(section.getFlags()), null, section.isReadable(), section.isWritable(), section.isExecutable(), log, monitor);
                        break block10;
                    }
                }
                block = MemoryBlockUtils.createInitializedBlock(program, isOverlay, (String)name, sectionAddr, fileBytes, (long)section.getPointerToRawData(), sectionSize, "PhysAddr:0x" + Integer.toHexString(section.getPhysicalAddress()) + " Size:0x" + Integer.toHexString(sectionSize) + " Flags:0x" + Integer.toHexString(section.getFlags()), null, section.isReadable(), section.isWritable(), section.isExecutable(), log);
            }
            catch (RuntimeException e) {
                log.appendMsg("Unable to create non-loaded block " + section + ". No memory block was created.");
                log.appendException((Throwable)e);
            }
        }
        return block;
    }

    private void possiblyRelocateSections(Program program, CoffFileHeader header, Map<CoffSectionHeader, Address> map) {
        Language language = program.getLanguage();
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
        AddressSet nonZeroSet = new AddressSet();
        int totalSize = 0;
        TreeMap<String, Integer> zeroSectionSizes = new TreeMap<String, Integer>();
        TreeMap<String, Integer> zeroSectionOffsets = new TreeMap<String, Integer>();
        List<CoffSectionHeader> sections = header.getSections();
        for (CoffSectionHeader section : sections) {
            Object end;
            int physicalAddress = section.getPhysicalAddress();
            int size = section.getSize(language);
            if (physicalAddress == 0) {
                String name = section.getName();
                Integer s = (Integer)zeroSectionSizes.get(name);
                if (s == null) {
                    zeroSectionSizes.put(name, size);
                } else {
                    zeroSectionSizes.put(name, s + size);
                }
                totalSize += size;
                continue;
            }
            if (size <= 0) continue;
            Address start = defaultAddressSpace.getAddress((long)physicalAddress);
            if (nonZeroSet.contains(start, (Address)(end = defaultAddressSpace.getAddress((long)(physicalAddress + size - 1))))) {
                Msg.warn((Object)this, (Object)("Section " + section.getName() + " overlaps another non-zero section (hope it's going in an overlay!)"));
            }
            nonZeroSet.addRange(start, (Address)end);
        }
        Address maxAddress = nonZeroSet.getMaxAddress();
        int offset = maxAddress == null ? 8191 : (int)(maxAddress.getOffset() & 0xFFFFFFFFFFFFFFFFL);
        long sum = offset;
        if ((sum += (long)totalSize) <= 0x100000000L) {
            int start = this.align(offset + 1);
            for (Map.Entry entry : zeroSectionSizes.entrySet()) {
                zeroSectionOffsets.put((String)entry.getKey(), start);
                start = this.align(start + (Integer)entry.getValue());
            }
            int sectionNumber = 1;
            for (CoffSectionHeader section : sections) {
                int physicalAddress = section.getPhysicalAddress();
                if (physicalAddress == 0) {
                    String name = section.getName();
                    start = (Integer)zeroSectionOffsets.get(name);
                    this.relocateSection(header, section, sectionNumber, start);
                    zeroSectionOffsets.put(name, start + section.getSize(language));
                }
                ++sectionNumber;
            }
        }
    }

    private int align(int i) {
        return (i + 256 - 1) / 256 * 256;
    }

    private void relocateSection(CoffFileHeader header, CoffSectionHeader section, int sectionNumber, int offset) {
        section.move(offset);
        List<CoffSymbol> symbols = header.getSymbols();
        for (CoffSymbol coffSymbol : symbols) {
            if (coffSymbol.isSection() || coffSymbol.getSectionNumber() != sectionNumber) continue;
            coffSymbol.move(offset);
        }
    }

    private void processRelocations(CoffFileHeader header, Program program, Map<CoffSectionHeader, Address> sectionsMap, Map<CoffSymbol, Symbol> symbolsMap, MessageLog log, TaskMonitor monitor) {
        CoffRelocationHandler handler = CoffRelocationHandlerFactory.getHandler(header);
        block4: for (CoffSectionHeader section : header.getSections()) {
            if (monitor.isCancelled()) break;
            Address sectionStartAddr = sectionsMap.get(section);
            if (sectionStartAddr == null) {
                if (section.getRelocationCount() <= 0) continue;
                log.appendMsg("Unable to process relocations for " + section.getName() + ". No memory block was created.");
                continue;
            }
            for (CoffRelocation relocation : section.getRelocations()) {
                if (monitor.isCancelled()) continue block4;
                Address address = sectionStartAddr.add(relocation.getAddress());
                byte[] origBytes = new byte[]{};
                Symbol symbol = symbolsMap.get(header.getSymbolAtIndex(relocation.getSymbolIndex()));
                if (handler == null) {
                    this.handleRelocationError(program, log, address, String.format("No relocation handler for machine type 0x%x to process relocation at %s with type 0x%x", header.getMachine(), address, relocation.getType()));
                } else if (symbol == null) {
                    this.handleRelocationError(program, log, address, String.format("No symbol to process relocation at %s with type 0x%x", address, relocation.getType()));
                } else {
                    try {
                        origBytes = new byte[4];
                        program.getMemory().getBytes(address, origBytes);
                        handler.relocate(program, address, symbol, relocation);
                    }
                    catch (MemoryAccessException e) {
                        this.handleRelocationError(program, log, address, String.format("Error accessing memory at address %s.  Relocation failed.", address));
                    }
                    catch (NotFoundException e) {
                        this.handleRelocationError(program, log, address, String.format("Relocation type 0x%x at address %s is not supported.", relocation.getType(), address));
                    }
                    catch (AddressOutOfBoundsException e) {
                        this.handleRelocationError(program, log, address, String.format("Error computing relocation at address %s.", address));
                    }
                }
                program.getRelocationTable().add(address, (int)relocation.getType(), new long[]{relocation.getSymbolIndex()}, origBytes, symbol != null ? symbol.getName() : "<null>");
            }
        }
    }

    private void handleRelocationError(Program program, MessageLog log, Address address, String message) {
        program.getBookmarkManager().setBookmark(address, "Error", "Relocations", message);
        log.appendMsg(message);
    }

    private void createOneByteFunction(Program program, String name, Address address) {
        FunctionManager functionMgr = program.getFunctionManager();
        if (functionMgr.getFunctionAt(address) != null) {
            return;
        }
        try {
            functionMgr.createFunction(name, address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return COFF_NAME;
    }

    class CoffPair {
        public long offset;
        public long size;

        CoffPair(long offset, long size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

