/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.services.GoToService;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.UniversalIdGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

class DualListingNavigator
implements Navigatable {
    private final ListingPanel listingPanel;
    private List<NavigatableRemovalListener> listeners = new ArrayList<NavigatableRemovalListener>();
    private long id;
    private GoToService goToService;

    DualListingNavigator(ListingCodeComparisonPanel dualListingPanel, boolean isLeftSide) {
        this.listingPanel = isLeftSide ? dualListingPanel.getLeftPanel() : dualListingPanel.getRightPanel();
        this.goToService = dualListingPanel.getGoToService(isLeftSide);
        this.id = UniversalIdGenerator.nextID().getValue();
    }

    @Override
    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public ProgramSelection getHighlight() {
        return this.listingPanel.getProgramHighlight();
    }

    @Override
    public long getInstanceID() {
        return this.id;
    }

    @Override
    public ProgramLocation getLocation() {
        return this.listingPanel.getProgramLocation();
    }

    @Override
    public LocationMemento getMemento() {
        return new LocationMemento(this.getProgram(), this.getLocation());
    }

    @Override
    public Icon getNavigatableIcon() {
        return null;
    }

    @Override
    public Program getProgram() {
        return this.listingPanel.getProgram();
    }

    @Override
    public ProgramSelection getSelection() {
        return this.listingPanel.getProgramSelection();
    }

    @Override
    public boolean goTo(Program program, ProgramLocation location) {
        if (program != this.listingPanel.getProgram()) {
            return false;
        }
        return this.goToService.goTo(location, program);
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public boolean supportsMarkers() {
        return false;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void requestFocus() {
        this.listingPanel.requestFocus();
    }

    @Override
    public void setHighlight(ProgramSelection highlight) {
        this.listingPanel.setHighlight(highlight);
    }

    @Override
    public void setMemento(LocationMemento memento) {
    }

    @Override
    public void setSelection(ProgramSelection selection) {
        this.listingPanel.setSelection(selection);
    }

    @Override
    public boolean supportsHighlight() {
        return false;
    }

    @Override
    public void removeHighlightProvider(HighlightProvider highlightProvider, Program program) {
    }

    @Override
    public void setHighlightProvider(HighlightProvider highlightProvider, Program program) {
    }
}

