/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;

public class InteriorSelection {
    private ProgramLocation from;
    private ProgramLocation to;
    private Address start;
    private Address end;

    public InteriorSelection(ProgramLocation from, ProgramLocation to, Address start, Address end) {
        this.from = from;
        this.to = to;
        this.start = start;
        this.end = end;
    }

    public ProgramLocation getFrom() {
        return this.from;
    }

    public ProgramLocation getTo() {
        return this.to;
    }

    public Address getStartAddress() {
        return this.start;
    }

    public Address getEndAddress() {
        return this.end;
    }

    public int getByteLength() {
        long diff = this.end.subtract(this.start);
        return (int)(diff + 1L);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InteriorSelection is = (InteriorSelection)obj;
        return this.from.equals((Object)is.from) && this.to.equals((Object)is.to);
    }

    public String toString() {
        return "From = " + this.from.getAddress() + ", To = " + this.to.getAddress();
    }
}

