/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class ReferenceFromLabelTableColumn
extends ProgramLocationTableColumnExtensionPoint<ReferenceAddressPair, String> {
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Label";
    }

    public String getValue(ReferenceAddressPair rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Symbol s = this.getSymbol(rowObject, program);
        if (s != null) {
            return s.getName(true);
        }
        return null;
    }

    private Symbol getSymbol(ReferenceAddressPair rowObject, Program program) {
        Address fromAddress = rowObject.getSource();
        SymbolTable symbolTable = program.getSymbolTable();
        return symbolTable.getPrimarySymbol(fromAddress);
    }

    @Override
    public ProgramLocation getProgramLocation(ReferenceAddressPair rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Symbol symbol = this.getSymbol(rowObject, program);
        if (symbol != null) {
            return symbol.getProgramLocation();
        }
        return null;
    }
}

