/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.framework.options.SaveState;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Point;

public class GraphPerspectiveInfo<V extends VisualVertex, E extends VisualEdge<V>> {
    private static final String LAYOUT_TRANSLATE_X = "LAYOUT_TRANSLATE_X";
    private static final String LAYOUT_TRANSLATE_Y = "LAYOUT_TRANSLATE_Y";
    private static final String VIEW_TRANSLATE_X = "VIEW_TRANSLATE_X";
    private static final String VIEW_TRANSLATE_Y = "VIEW_TRANSLATE_Y";
    private static final String VIEW_ZOOM = "VIEW_ZOOM";
    private static final Point INVALID_POINT = null;
    private static final double INVALID_ZOOM = -1.0;
    private final Point layoutTranslateCoordinates;
    private final Point viewTranslateCoordinates;
    private final double zoom;
    private boolean restoreZoom;

    public static <V extends VisualVertex, E extends VisualEdge<V>> GraphPerspectiveInfo<V, E> createInvalidGraphPerspectiveInfo() {
        return new GraphPerspectiveInfo<V, E>();
    }

    private GraphPerspectiveInfo() {
        this.zoom = -1.0;
        this.restoreZoom = false;
        this.layoutTranslateCoordinates = null;
        this.viewTranslateCoordinates = null;
    }

    public GraphPerspectiveInfo(RenderContext<V, E> renderContext, double zoom) {
        this.zoom = zoom;
        this.restoreZoom = true;
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        double tx = transformer.getTransformer(Layer.LAYOUT).getTranslateX();
        double ty = transformer.getTransformer(Layer.LAYOUT).getTranslateY();
        this.layoutTranslateCoordinates = new Point((int)tx, (int)ty);
        tx = transformer.getTransformer(Layer.VIEW).getTranslateX();
        ty = transformer.getTransformer(Layer.VIEW).getTranslateY();
        this.viewTranslateCoordinates = new Point((int)tx, (int)ty);
    }

    public GraphPerspectiveInfo(SaveState saveState) {
        double savedZoom = saveState.getDouble(VIEW_ZOOM, -1.0);
        int layoutTranslateX = saveState.getInt(LAYOUT_TRANSLATE_X, Integer.MAX_VALUE);
        int layoutTranslateY = saveState.getInt(LAYOUT_TRANSLATE_Y, Integer.MAX_VALUE);
        if (layoutTranslateX == Integer.MAX_VALUE || layoutTranslateY == Integer.MAX_VALUE) {
            this.layoutTranslateCoordinates = INVALID_POINT;
            this.viewTranslateCoordinates = INVALID_POINT;
            this.zoom = -1.0;
            return;
        }
        int viewTranslateX = saveState.getInt(VIEW_TRANSLATE_X, Integer.MAX_VALUE);
        int viewTranslateY = saveState.getInt(VIEW_TRANSLATE_Y, Integer.MAX_VALUE);
        if (viewTranslateX == Integer.MAX_VALUE || viewTranslateY == Integer.MAX_VALUE) {
            this.layoutTranslateCoordinates = INVALID_POINT;
            this.viewTranslateCoordinates = INVALID_POINT;
            this.zoom = -1.0;
            return;
        }
        this.layoutTranslateCoordinates = new Point(layoutTranslateX, layoutTranslateY);
        this.viewTranslateCoordinates = new Point(viewTranslateX, viewTranslateY);
        this.zoom = savedZoom;
        this.restoreZoom = true;
    }

    public void saveState(SaveState saveState) {
        if (this.isInvalid()) {
            return;
        }
        saveState.putDouble(VIEW_ZOOM, this.zoom);
        saveState.putInt(LAYOUT_TRANSLATE_X, this.layoutTranslateCoordinates.x);
        saveState.putInt(LAYOUT_TRANSLATE_Y, this.layoutTranslateCoordinates.y);
    }

    public boolean isInvalid() {
        return this.layoutTranslateCoordinates == INVALID_POINT || this.viewTranslateCoordinates == INVALID_POINT;
    }

    public Point getLayoutTranslateCoordinates() {
        return this.layoutTranslateCoordinates;
    }

    public Point getViewTranslateCoordinates() {
        return this.viewTranslateCoordinates;
    }

    public boolean isRestoreZoom() {
        return this.restoreZoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    public String toString() {
        return "{\n\tisRestoreZoom: " + this.restoreZoom + ",\n\tlayoutTranslateCoordinates: " + this.layoutTranslateCoordinates + ",\n\tviewTranslateCoordinates: " + this.viewTranslateCoordinates + ",\n\tzoom=" + this.zoom + "\n}";
    }
}

