/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphCursorRestoringGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphEdgeSelectionGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphEventForwardingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphPickingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphScalingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphScrollWheelPanningPlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphTranslatingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphZoomingPickingGraphMousePlugin;
import ghidra.util.Msg;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class VisualGraphPluggableGraphMouse<V extends VisualVertex, E extends VisualEdge<V>>
implements VisualizationViewer.GraphMouse {
    protected CopyOnWriteArrayList<GraphMousePlugin> mousePlugins = new CopyOnWriteArrayList();

    public VisualGraphPluggableGraphMouse() {
        this.addPlugins();
    }

    protected void addPlugins() {
        this.add((GraphMousePlugin)new VisualGraphEventForwardingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphEdgeSelectionGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphZoomingPickingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphScalingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphScrollWheelPanningPlugin());
        this.add((GraphMousePlugin)new VisualGraphTranslatingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphPickingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphCursorRestoringGraphMousePlugin());
    }

    public void prepend(GraphMousePlugin p) {
        if (this.mousePlugins.contains(p)) {
            this.mousePlugins.remove(p);
        }
        this.mousePlugins.add(0, p);
    }

    public void add(GraphMousePlugin p) {
        if (this.mousePlugins.contains(p)) {
            this.mousePlugins.remove(p);
        }
        this.mousePlugins.add(p);
    }

    public void remove(GraphMousePlugin p) {
        this.mousePlugins.remove(p);
    }

    public void dispose() {
        for (GraphMousePlugin mp : this.mousePlugins) {
            if (!(mp instanceof VisualGraphMousePlugin)) continue;
            ((VisualGraphMousePlugin)mp).dispose();
        }
        this.mousePlugins.clear();
    }

    private void trace(String s) {
        Msg.trace((Object)this, (Object)s);
    }

    private void trace(String s, MouseEvent e) {
        Msg.trace((Object)this, (Object)("click count = " + e.getClickCount() + " - " + s));
    }

    public void mouseClicked(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseClicked() on " + p, e);
            ((MouseListener)p).mouseClicked(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mousePressed(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mousePressed() on " + p, e);
            ((MouseListener)p).mousePressed(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseReleased() on " + p, e);
            ((MouseListener)p).mouseReleased(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseEntered(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseEntered() on " + p, e);
            ((MouseListener)p).mouseEntered(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseExited(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseExited() on " + p, e);
            ((MouseListener)p).mouseExited(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseMotionListener)) continue;
            this.trace("mouseDragged() on " + p, e);
            ((MouseMotionListener)p).mouseDragged(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseMotionListener)) continue;
            this.trace("mouseMoved() on " + p, e);
            ((MouseMotionListener)p).mouseMoved(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseWheelListener)) continue;
            this.trace("mouseWheelMoved() on " + p, e);
            ((MouseWheelListener)p).mouseWheelMoved(e);
            if (!e.isConsumed()) continue;
            this.trace("\tconsumed");
            return;
        }
    }
}

