/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.jmx.remote.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.rzo.netty.ahessian.application.jmx.remote.client.RPCClientMixinPipelineFactory;
import org.rzo.netty.ahessian.application.jmx.remote.client.RPCClientSessionPipelineFactory;
import org.rzo.netty.ahessian.application.jmx.remote.service.AsyncMBeanServerConnection;
import org.rzo.netty.ahessian.application.jmx.remote.service.MBeanServerConnectionAsyncAdapter;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;

public class Client {
    static boolean stop = false;
    static MBeanServerConnection server;

    public static void main(String[] args) throws Exception {
        final ExecutorService executor = Executors.newCachedThreadPool();
        Bootstrap bootstrap = new Bootstrap();
        OioEventLoopGroup workerGroup = new OioEventLoopGroup();
        bootstrap.group((EventLoopGroup)workerGroup);
        bootstrap.channel(OioSocketChannel.class);
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress("localhost", 15009));
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        final HessianProxyFactory factory = new HessianProxyFactory(executor, "localhost:15009");
        bootstrap.handler((ChannelHandler)new RPCClientSessionPipelineFactory(new RPCClientMixinPipelineFactory(executor, factory, (EventLoopGroup)workerGroup), bootstrap));
        factory.setDisconnectedListener(new Runnable(){

            @Override
            public void run() {
            }
        });
        factory.setNewSessionListener(new Runnable(){

            @Override
            public void run() {
                stop = false;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("started work thread");
                        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
                        options.put("sync", Boolean.valueOf(true));
                        options.put("timeout", Long.valueOf(10000L));
                        AsyncMBeanServerConnection service = (AsyncMBeanServerConnection)factory.create(AsyncMBeanServerConnection.class, Client.class.getClassLoader(), options);
                        server = new MBeanServerConnectionAsyncAdapter(service);
                        while (!stop) {
                            try {
                                ObjectName on = new ObjectName("java.lang:type=ClassLoading");
                                Object x = server.getAttribute(on, "LoadedClassCount");
                                System.out.println(x);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                System.out.println(ex);
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        System.out.println("stopped work thread");
                    }
                });
            }
        });
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress("localhost", 15009));
        Channel channel = future.awaitUninterruptibly().channel();
        if (future.isSuccess()) {
            System.out.println("connected");
        }
    }
}

