/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import com.caucho.hessian4.services.server.AbstractSkeleton;
import io.netty.channel.Channel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFuture;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

public class AsyncHessianProxy
implements InvocationHandler,
Constants {
    private WeakHashMap<Method, String> _mangleMap = new WeakHashMap();
    private HessianProxyFactory _factory;
    private Class _api;
    private boolean _valid = true;
    Map _options;
    private Map<String, Integer> _groups = new HashMap<String, Integer>();
    static volatile long id = 0L;

    AsyncHessianProxy(HessianProxyFactory factory, Class api, Map options) {
        this._factory = factory;
        this._api = api;
        this._options = options;
    }

    Channel getChannel() {
        if (!this._valid) {
            throw new RuntimeException("invalidated proxy");
        }
        return this._factory.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mangleName;
        if (method.getName().equals("hashCode") && (args == null || args.length == 0)) {
            return new Integer(System.identityHashCode(this));
        }
        if (method.getName().equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (method.getName().equals("toString") && (args == null || args.length == 0)) {
            return "HessianProxy[" + this._api + "]";
        }
        Channel channel = this.getChannel();
        if (method.getName().equals("getHessianURL")) {
            return channel == null ? "?" : channel.toString();
        }
        WeakHashMap<Method, String> weakHashMap = this._mangleMap;
        synchronized (weakHashMap) {
            mangleName = this._mangleMap.get(method);
        }
        if (mangleName == null) {
            String methodName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
                Object value = args[0];
                if (value == null || !Proxy.isProxyClass(value.getClass())) {
                    return Boolean.FALSE;
                }
                InvocationHandler proxyHandler = Proxy.getInvocationHandler(value);
                if (!(proxyHandler instanceof AsyncHessianProxy)) {
                    return Boolean.FALSE;
                }
                AsyncHessianProxy handler = (AsyncHessianProxy)proxyHandler;
                return new Boolean(this.equals(handler));
            }
            mangleName = !this._factory.isOverloadEnabled() ? method.getName() : this.mangleName(method);
            WeakHashMap<Method, String> weakHashMap2 = this._mangleMap;
            synchronized (weakHashMap2) {
                this._mangleMap.put(method, mangleName);
            }
        }
        Integer group = this.getGroup(mangleName, method.getName());
        return this.sendRequest(mangleName, args, group);
    }

    private Integer getGroup(String mangleName, String name) {
        Integer result = this._groups.get(mangleName);
        if (result == null) {
            result = (Integer)this._options.get("method.group." + mangleName);
            if (result == null) {
                result = (Integer)this._options.get("method.group." + name);
            }
            if (result == null) {
                result = 0;
            }
            this._groups.put(mangleName, result);
        }
        return result;
    }

    protected Future<Object> sendRequest(String methodName, Object[] args, Integer group) throws InterruptedException {
        if (!this._valid) {
            throw new RuntimeException("invalidated proxy");
        }
        HashMap<Integer, Integer> options = new HashMap<Integer, Integer>();
        options.put(GROUP_HEADER_KEY, group);
        options.put(SERVICE_ID_HEADER_KEY, (Integer)this._options.get(SERVICE_ID_HEADER_KEY));
        return this._factory.sendRequest(methodName, args, options);
    }

    protected Map getHeaders() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        result.put(CALL_ID_HEADER_KEY, id++);
        return result;
    }

    protected String mangleName(Method method) {
        Class<?>[] param = method.getParameterTypes();
        if (param == null || param.length == 0) {
            return method.getName();
        }
        return AbstractSkeleton.mangleName((Method)method, (boolean)false);
    }

    private Future immediateFuture(Object result) {
        HessianProxyFuture future = new HessianProxyFuture();
        future.set(new HessianRPCReplyMessage(result, null, null));
        return future;
    }

    protected void invalidate() {
        this._valid = false;
    }

    public String getHost() {
        Channel c = this.getChannel();
        if (c == null) {
            return null;
        }
        InetSocketAddress addr = (InetSocketAddress)c.remoteAddress();
        return addr.getHostName();
    }
}

