/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.io.Serializable;
import java.util.ArrayList;

public class IntIndexManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int nextIndex = 0;
    private ArrayList<Integer> freeList = new ArrayList();

    public int allocate() {
        if (this.freeList.size() == 0) {
            if (this.nextIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            int temp = this.nextIndex++;
            return temp;
        }
        Integer i = this.freeList.remove(this.freeList.size() - 1);
        return i;
    }

    public void deallocate(int index) {
        if (index < 0 || index >= this.nextIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.nextIndex - 1) {
            --this.nextIndex;
        } else {
            this.freeList.add(new Integer(index));
        }
        if (this.nextIndex == this.freeList.size()) {
            this.clear();
        }
    }

    public void clear() {
        this.nextIndex = 0;
        this.freeList.clear();
    }
}

