/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.ShortKeyIndexer;
import ghidra.util.exception.NoValueException;
import java.io.Serializable;

public class ShortLongHashtable
implements Serializable {
    private ShortKeyIndexer indexer;
    private long[] values;
    private int capacity;

    public ShortLongHashtable() {
        this(3);
    }

    public ShortLongHashtable(short capacity) {
        capacity = (short)Prime.nextPrime(capacity);
        this.capacity = capacity;
        this.indexer = new ShortKeyIndexer(capacity);
        this.values = new long[capacity];
    }

    public void put(short key, long value) {
        short index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public long get(short key) throws NoValueException {
        short index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public boolean remove(short key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(short key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public short[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        long[] oldValues = this.values;
        this.values = new long[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

