/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.exception;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MultipleCauses
extends Throwable {
    private Collection<Throwable> causes = new ArrayList<Throwable>();

    public MultipleCauses() {
        super("Multiple Causes");
    }

    public MultipleCauses(Collection<Throwable> causes) {
        this();
        this.causes = causes;
    }

    @Override
    public synchronized Throwable getCause() {
        return null;
    }

    public synchronized Collection<Throwable> getCauses() {
        return this.causes;
    }

    public synchronized void addCause(Throwable cause) {
        this.causes.add(cause);
    }

    public synchronized void addFlattenedIfMultiple(Throwable e) {
        if (MultipleCauses.hasMultiple(e)) {
            this.addAllCauses(e);
        } else {
            this.addCause(e);
        }
    }

    public synchronized void addAllCauses(Throwable e) {
        if (e.getCause() != null) {
            this.addAllCauses((MultipleCauses)e.getCause());
        }
    }

    public synchronized void addAllCauses(MultipleCauses that) {
        this.causes.addAll(that.causes);
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException("Use addCause instead");
    }

    public synchronized boolean isEmpty() {
        return this.causes.isEmpty();
    }

    public static boolean hasMultiple(Throwable e) {
        Throwable cause = e.getCause();
        return cause != null && cause instanceof MultipleCauses;
    }

    public static void printTree(PrintStream out, Throwable e) {
        MultipleCauses.printTree(out, "", e);
    }

    public static void printTree(PrintStream out, String prefix, Throwable e) {
        out.print(prefix);
        e.printStackTrace(out);
        if (MultipleCauses.hasMultiple(e) && e.getCause() != null) {
            MultipleCauses report = (MultipleCauses)e.getCause();
            for (Throwable t : report.getCauses()) {
                MultipleCauses.printTree(out, prefix + ">", t);
            }
        }
    }

    public static class Util {
        public static Iterable<Throwable> iterCauses(Throwable exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof MultipleCauses) {
                return Collections.unmodifiableCollection(((MultipleCauses)cause).getCauses());
            }
            return Collections.singleton(cause);
        }
    }
}

