/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.datastruct.LongDoubleHashtable;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;
import java.util.Arrays;
import java.util.Comparator;

public class DoubleAttribute<T extends KeyedObject>
extends Attribute<T> {
    private LongDoubleHashtable values = new LongDoubleHashtable();
    private static String attributeType = "DOUBLE_TYPE";

    public DoubleAttribute(String name, KeyIndexableSet<T> set) {
        super(name, set);
    }

    public boolean setValue(T o, double value) {
        if (this.owningSet().contains(o)) {
            this.values.put(o.key(), value);
            this.update();
            return true;
        }
        return false;
    }

    public double getValue(KeyedObject o) throws NoValueException {
        return this.values.get(o.key());
    }

    public KeyedObject[] toSortedArray() {
        KeyedObject[] keyedObjects = this.owningSet().toArray();
        Arrays.sort(keyedObjects, new DoubleComparator());
        return keyedObjects;
    }

    public KeyedObject[] toSortedArray(KeyedObject[] keyedObjects) {
        KeyedObject[] clone = (KeyedObject[])keyedObjects.clone();
        Arrays.sort(clone, new DoubleComparator());
        return clone;
    }

    @Override
    public String attributeType() {
        return attributeType;
    }

    @Override
    public void clear() {
        this.values.removeAll();
    }

    @Override
    public String getValueAsString(KeyedObject o) {
        try {
            return Double.toString(this.getValue(o));
        }
        catch (NoValueException exc) {
            return "0.0";
        }
    }

    class DoubleComparator
    implements Comparator<KeyedObject> {
        DoubleComparator() {
        }

        @Override
        public int compare(KeyedObject object1, KeyedObject object2) {
            KeyedObject ko1 = object1;
            KeyedObject ko2 = object2;
            double value1 = 0.0;
            double value2 = 0.0;
            value1 = DoubleAttribute.this.getValue(ko1);
            try {
                value2 = DoubleAttribute.this.getValue(ko2);
                if (value1 - value2 < 0.0) {
                    return -1;
                }
                if (value1 - value2 > 0.0) {
                    return 1;
                }
                if (ko1.key() - ko2.key() < 0L) {
                    return -1;
                }
                if (ko1.key() - ko2.key() > 0L) {
                    return 1;
                }
                return 0;
            }
            catch (NoValueException exc2) {
                try {
                    return -1;
                }
                catch (NoValueException exc) {
                    try {
                        value2 = DoubleAttribute.this.getValue(ko2);
                        return 1;
                    }
                    catch (NoValueException exc22) {
                        if (ko1.key() - ko2.key() < 0L) {
                            return -1;
                        }
                        if (ko1.key() - ko2.key() > 0L) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }
        }
    }
}

