/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.TimeoutException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import utility.function.Callback;

public class TimeoutTaskMonitor
implements TaskMonitor {
    private TaskMonitor delegate;
    private GTimerMonitor timerMonitor;
    private long timeout;
    private TimeUnit timeUnit;
    private AtomicBoolean didTimeout = new AtomicBoolean(false);
    private Callback timeoutCallback = Callback.dummy();

    public static TimeoutTaskMonitor timeoutIn(long timeout, TimeUnit timeUnit) {
        TaskMonitorAdapter delegate = new TaskMonitorAdapter(true);
        TimeoutTaskMonitor timeoutMonitor = TimeoutTaskMonitor.timeoutIn(timeout, timeUnit, delegate);
        return timeoutMonitor;
    }

    public static TimeoutTaskMonitor timeoutIn(long timeout, TimeUnit timeUnit, TaskMonitor monitor) {
        TaskMonitor delegate = Objects.requireNonNull(monitor);
        if (!delegate.isCancelEnabled()) {
            delegate = new TaskMonitorAdapter(true);
        }
        TimeoutTaskMonitor timeoutMonitor = new TimeoutTaskMonitor(delegate, timeout, timeUnit);
        return timeoutMonitor;
    }

    TimeoutTaskMonitor(TaskMonitor delegate, long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(delegate);
        SystemUtilities.assertTrue((delegate != TaskMonitor.DUMMY ? 1 : 0) != 0, (String)"TaskMonitor.DUMMY is not cancellable.  Please pass a cancellable monitor.");
        SystemUtilities.assertTrue((timeout > 0L ? 1 : 0) != 0, (String)"Timeout must be greater than 0");
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.delegate = delegate;
        long millis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        this.timerMonitor = GTimer.scheduleRunnable(millis, () -> this.timeout());
    }

    public void setTimeoutListener(Callback timeoutCallback) {
        this.timeoutCallback = Callback.dummyIfNull((Callback)timeoutCallback);
    }

    public boolean didTimeout() {
        return this.didTimeout.get();
    }

    public void finished() {
        this.timeoutCallback = Callback.dummy();
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.delegate.setShowProgressValue(showProgressValue);
    }

    public void setMessage(String message) {
        this.delegate.setMessage(message);
    }

    public String getMessage() {
        return this.delegate.getMessage();
    }

    public void setProgress(long value) {
        this.delegate.setProgress(value);
    }

    public void initialize(long max) {
        this.delegate.initialize(max);
    }

    public void setMaximum(long max) {
        this.delegate.setMaximum(max);
    }

    public long getMaximum() {
        return this.delegate.getMaximum();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.delegate.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.delegate.isIndeterminate();
    }

    public void checkCanceled() throws CancelledException {
        if (this.didTimeout()) {
            throw new TimeoutException("Operation cancelled due to timeout of " + this.timeout + " " + this.timeUnit.toString());
        }
        this.delegate.checkCanceled();
    }

    public void incrementProgress(long incrementAmount) {
        this.delegate.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.delegate.getProgress();
    }

    private void timeout() {
        this.didTimeout.set(true);
        this.timeoutCallback.call();
        this.cancel();
    }

    public void cancel() {
        this.timerMonitor.cancel();
        this.delegate.cancel();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.delegate.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.delegate.removeCancelledListener(listener);
    }

    public void setCancelEnabled(boolean enable) {
        this.delegate.setCancelEnabled(enable);
    }

    public boolean isCancelEnabled() {
        return this.delegate.isCancelEnabled();
    }

    public void clearCanceled() {
        this.delegate.clearCanceled();
    }
}

