/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

/**
 * The <CODE>FunctionReturnTypeFieldLocation</CODE> class provides specific information
 * about the Function Return Type field within a program location.
 */
public class FunctionReturnTypeFieldLocation extends FunctionSignatureFieldLocation {

	private String returnTypeStr;

	/**
	 * Construct a new FunctionReturnTypeFieldLocation object.
	 * 
	 * @param the program of the location
	 * @param locationAddr the address of the listing location (i.e., referent code unit)
	 * @param functionAddr the function address
	 * @param charOffset the position within the function signature string for this location.
	 * @param signature the function signature string for this location.
	 * @param returnType the function return type String at this location.
	 */
	public FunctionReturnTypeFieldLocation(Program program, Address locationAddr,
			Address functionAddr, int charOffset, String signature, String returnType) {
		super(program, locationAddr, functionAddr, charOffset, signature);
		this.returnTypeStr = returnType;
	}

	/**
	 * Construct a new FunctionReturnTypeFieldLocation object.
	 * 
	 * @param the program of the location
	 * @param functionAddr the function address
	 * @param col the position within the function signature string for this location.
	 * @param signature the function signature string for this location.
	 * @param returnType the function return type String at this location.
	 */
	public FunctionReturnTypeFieldLocation(Program program, Address functionAddr, int col,
			String signature, String returnType) {
		this(program, functionAddr, functionAddr, col, signature, returnType);
	}

	/**
	 * Construct a new FunctionReturnTypeFieldLocation object that is field based.<P>
	 * @param the program of the location
	 * @param functionAddr the function address
	 * @param returnType the function return type String at this location.
	 */
	public FunctionReturnTypeFieldLocation(Program program, Address functionAddr, String returnType) {
		super(program, functionAddr);
		this.returnTypeStr = returnType;
	}

	/**
	 * Default constructor needed for restoring
	 * a program location from XML
	 */
	public FunctionReturnTypeFieldLocation() {
	}

	/**
	 * Return the function return type string at this location.
	 */
	public String getReturnType() {
		return returnTypeStr;
	}

	/**
	 * Returns a String representation of this location.
	 */
	@Override
	public String toString() {
		return super.toString() + ", Function Return Type: " + returnTypeStr;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((returnTypeStr == null) ? 0 : returnTypeStr.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		FunctionReturnTypeFieldLocation other = (FunctionReturnTypeFieldLocation) obj;
		if (returnTypeStr == null) {
			if (other.returnTypeStr != null)
				return false;
		}
		else if (!returnTypeStr.equals(other.returnTypeStr))
			return false;
		return true;
	}

	@Override
	public void saveState(SaveState obj) {
		super.saveState(obj);
		obj.putString("_RETURN_TYPE", returnTypeStr);
	}

	@Override
	public void restoreState(Program restoreProgram, SaveState obj) {
		super.restoreState(restoreProgram, obj);
		returnTypeStr = obj.getString("_RETURN_TYPE", null);
	}

}
