/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server.http;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;

class SecurityIdentityServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;

    public SecurityIdentityServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        final SecurityIdentityCallbackHandler securityIdentityCallbackHandler = new SecurityIdentityCallbackHandler(callbackHandler);
        final HttpServerAuthenticationMechanism delegate = this.delegate.createAuthenticationMechanism(mechanismName, properties, securityIdentityCallbackHandler);
        if (delegate != null) {
            return new HttpServerAuthenticationMechanism(){

                @Override
                public String getMechanismName() {
                    return delegate.getMechanismName();
                }

                @Override
                public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                    delegate.evaluateRequest(request);
                }

                @Override
                public Object getNegotiatedProperty(String propertyName) {
                    return "wildfly.http.security-identity".equals(propertyName) ? securityIdentityCallbackHandler.getSecurityIdentity() : delegate.getNegotiatedProperty(propertyName);
                }

                @Override
                public void dispose() {
                    delegate.dispose();
                }
            };
        }
        return null;
    }

    private static class SecurityIdentityCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler delegate;
        private SecurityIdentity securityIdentity;

        SecurityIdentityCallbackHandler(CallbackHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Callback[] theCallbacks = callbacks;
            SecurityIdentityCallback securityIdentityCallback = null;
            for (Callback current : callbacks) {
                if (!(current instanceof AuthenticationCompleteCallback) || !((AuthenticationCompleteCallback)current).succeeded()) continue;
                theCallbacks = new Callback[callbacks.length + 1];
                System.arraycopy(callbacks, 0, theCallbacks, 0, callbacks.length);
                securityIdentityCallback = new SecurityIdentityCallback();
                theCallbacks[theCallbacks.length - 1] = securityIdentityCallback;
            }
            this.delegate.handle(theCallbacks);
            if (securityIdentityCallback != null) {
                this.securityIdentity = securityIdentityCallback.getSecurityIdentity();
            }
        }

        SecurityIdentity getSecurityIdentity() {
            return this.securityIdentity;
        }
    }
}

