/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalRegionImpl;
import org.infinispan.quarkus.hibernate.cache.QuarkusInfinispanRegionFactory;
import org.infinispan.quarkus.hibernate.cache.Sync;
import org.jboss.logging.Logger;

final class QueryResultsRegionImpl
implements QueryResultsRegion,
ExtendedStatisticsSupport {
    private static final Logger log = Logger.getLogger(QueryResultsRegionImpl.class);
    private final InternalCache cache;
    private final String name;
    private final InternalRegionImpl internalRegion;
    private final RegionFactory regionFactory;
    private final ConcurrentMap<Object, Map> transactionContext = new ConcurrentHashMap<Object, Map>();

    public QueryResultsRegionImpl(InternalCache cache, String name, QuarkusInfinispanRegionFactory regionFactory) {
        this.cache = cache;
        this.name = name;
        this.regionFactory = regionFactory;
        this.internalRegion = new InternalRegionImpl((Region)this);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (!this.internalRegion.checkValid()) {
            return null;
        }
        Object result = null;
        Map map = (Map)this.transactionContext.get(session);
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = this.cache.getOrNull(key);
        }
        return result;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        if (!this.internalRegion.checkValid()) {
            return;
        }
        Sync sync = (Sync)session.getCacheTransactionSynchronization();
        if (sync != null && session.isTransactionInProgress()) {
            sync.registerAfterCommit(new PostTransactionQueryUpdate(session, key, value));
            this.transactionContext.computeIfAbsent(session, k -> new HashMap()).put(key, value);
        } else {
            this.cache.put(key, value);
        }
    }

    public String getName() {
        return this.name;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public void clear() {
        this.transactionContext.clear();
        this.internalRegion.beginInvalidation();
        this.runInvalidation();
        this.internalRegion.endInvalidation();
    }

    private void runInvalidation() {
        log.tracef("Non-transactional, clear in one go", new Object[0]);
        this.cache.invalidateAll();
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.cache.size(null);
    }

    public long getElementCountOnDisk() {
        return Long.MIN_VALUE;
    }

    public long getSizeInMemory() {
        return Long.MIN_VALUE;
    }

    private class PostTransactionQueryUpdate
    implements Function<Boolean, CompletableFuture<?>> {
        private final Object session;
        private final Object key;
        private final Object value;

        PostTransactionQueryUpdate(Object session, Object key, Object value) {
            this.session = session;
            this.key = key;
            this.value = value;
        }

        @Override
        public CompletableFuture<?> apply(Boolean success) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            if (success.booleanValue()) {
                QueryResultsRegionImpl.this.cache.put(this.key, this.value);
                return CompletableFuture.completedFuture(null);
            }
            return null;
        }
    }
}

