/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.regex.Pattern;
import org.keycloak.models.map.common.StringKeyConverter;

public class UuidValidator {
    protected static final Pattern UUID_REGEX_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}$");

    private UuidValidator() {
    }

    public static boolean isValid(String id) {
        return id == null ? false : UUID_REGEX_PATTERN.matcher(id).matches();
    }

    public static String validateAndConvert(String id) {
        return UuidValidator.isValid(id) ? id : StringKeyConverter.UUIDKey.INSTANCE.yieldNewUniqueKey().toString();
    }
}

