/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;
import org.logstash.plugins.pipeline.ReceiveResponse;

public class PipelineBus {
    final ConcurrentHashMap<String, AddressState> addressStates = new ConcurrentHashMap();
    final ConcurrentHashMap<PipelineOutput, ConcurrentHashMap<String, AddressState>> outputsToAddressStates = new ConcurrentHashMap();
    volatile boolean blockOnUnlisten = false;
    private static final Logger logger = LogManager.getLogger(PipelineBus.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvents(PipelineOutput sender, Collection<JrubyEventExtLibrary.RubyEvent> events, boolean ensureDelivery) {
        if (events.isEmpty()) {
            return;
        }
        PipelineOutput pipelineOutput = sender;
        synchronized (pipelineOutput) {
            ConcurrentHashMap<String, AddressState> addressesToInputs = this.outputsToAddressStates.get(sender);
            JrubyEventExtLibrary.RubyEvent[] orderedEvents = events.toArray(new JrubyEventExtLibrary.RubyEvent[0]);
            addressesToInputs.forEach((address, addressState) -> {
                boolean partialProcessing;
                boolean sendWasSuccess = false;
                ReceiveResponse lastResponse = null;
                int lastFailedPosition = 0;
                do {
                    Stream<JrubyEventExtLibrary.RubyEvent> clones = Arrays.stream(orderedEvents).skip(lastFailedPosition).map(e -> e.rubyClone(RubyUtil.RUBY));
                    PipelineInput input = addressState.getInput();
                    if (input != null) {
                        lastResponse = input.internalReceive(clones);
                        sendWasSuccess = lastResponse.wasSuccess();
                    }
                    boolean bl = partialProcessing = ensureDelivery && !sendWasSuccess;
                    if (!partialProcessing) continue;
                    if (lastResponse != null && lastResponse.getStatus() == PipelineInput.ReceiveStatus.FAIL) {
                        lastFailedPosition = lastResponse.getSequencePosition();
                        logger.warn("Attempted to send event to '{}' but that address reached error condition. Will Retry. Root cause {}", address, (Object)lastResponse.getCauseMessage());
                    } else {
                        logger.warn("Attempted to send event to '{}' but that address was unavailable. Maybe the destination pipeline is down or stopping? Will Retry.", address);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        logger.error("Sleep unexpectedly interrupted in bus retry loop", (Throwable)e2);
                    }
                } while (partialProcessing);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSender(PipelineOutput output, Iterable<String> addresses) {
        PipelineOutput pipelineOutput = output;
        synchronized (pipelineOutput) {
            addresses.forEach(address -> this.addressStates.compute((String)address, (k, value) -> {
                AddressState state = value != null ? value : new AddressState();
                state.addOutput(output);
                return state;
            }));
            this.updateOutputReceivers(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSender(PipelineOutput output, Iterable<String> addresses) {
        PipelineOutput pipelineOutput = output;
        synchronized (pipelineOutput) {
            addresses.forEach(address -> this.addressStates.computeIfPresent((String)address, (k, state) -> {
                state.removeOutput(output);
                if (state.isEmpty()) {
                    return null;
                }
                return state;
            }));
            this.outputsToAddressStates.remove(output);
        }
    }

    private void updateOutputReceivers(PipelineOutput output) {
        this.outputsToAddressStates.compute(output, (k, value) -> {
            ConcurrentHashMap outputAddressToInputMapping = value != null ? value : new ConcurrentHashMap();
            this.addressStates.forEach((address, state) -> {
                if (state.hasOutput(output)) {
                    outputAddressToInputMapping.put(address, state);
                }
            });
            return outputAddressToInputMapping;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listen(PipelineInput input, String address) {
        PipelineInput pipelineInput = input;
        synchronized (pipelineInput) {
            boolean[] result = new boolean[1];
            this.addressStates.compute(address, (k, value) -> {
                AddressState state;
                AddressState addressState = state = value != null ? value : new AddressState();
                if (state.assignInputIfMissing(input)) {
                    state.getOutputs().forEach(this::updateOutputReceivers);
                    result[0] = true;
                } else {
                    result[0] = false;
                }
                return state;
            });
            return result[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlisten(PipelineInput input, String address) throws InterruptedException {
        PipelineInput pipelineInput = input;
        synchronized (pipelineInput) {
            if (this.isBlockOnUnlisten()) {
                this.unlistenBlock(input, address);
            } else {
                this.unlistenNonblock(input, address);
            }
        }
    }

    private void unlistenBlock(PipelineInput input, String address) throws InterruptedException {
        boolean[] waiting = new boolean[]{true};
        while (true) {
            this.addressStates.compute(address, (k, state) -> {
                if (state == null) {
                    waiting[0] = false;
                    return null;
                }
                if (state.getOutputs().isEmpty()) {
                    state.unassignInput(input);
                    waiting[0] = false;
                    return null;
                }
                return state;
            });
            if (!waiting[0]) break;
            Thread.sleep(100L);
        }
    }

    @VisibleForTesting
    void unlistenNonblock(PipelineInput input, String address) {
        this.addressStates.computeIfPresent(address, (k, state) -> {
            state.unassignInput(input);
            state.getOutputs().forEach(this::updateOutputReceivers);
            return state.isEmpty() ? null : state;
        });
    }

    @VisibleForTesting
    boolean isBlockOnUnlisten() {
        return this.blockOnUnlisten;
    }

    public void setBlockOnUnlisten(boolean blockOnUnlisten) {
        this.blockOnUnlisten = blockOnUnlisten;
    }
}

